package com.xdja.reckon.api;

import com.xdja.reckon.model.AppCountPlus;
import com.xdja.reckon.model.AppInfo;
import com.xdja.reckon.model.AppResUsed;
import com.xdja.reckon.model.AppState;
import com.xdja.reckon.model.Response;

import java.util.Map;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Guojie on 16/9/6.
 */

public interface AppInfoApi {
    /**
     * 上传应用信息,获取AppID
     *
     * @param appInfo 应用信息
     * @return
     */
    @Headers("Content-Type: application/json;charset=UTF-8")
    @POST("appInfo.json")
    Observable<Response> getAppId(@Body AppInfo appInfo);

    /**
     * 上传App运行状态
     *
     * @param appState app运行状态
     * @return
     */
    @Headers("Content-Type: application/json;charset=UTF-8")
    @POST("appState.json")
    Observable<Response> uploadAppInfo(@Body AppState appState);

    /**
     * 上传App使用终端资源情况
     *
     * @param appResUsed 应用资源占用情况
     * @return
     */
    @Headers("Content-Type: application/json;charset=UTF-8")
    @POST("resStateAppUsed.json")
    Observable<Response> uploadAppResUsed(@Body AppResUsed appResUsed);
    /**
     * App使用次数
     *
     * @param appCountPlus
     * @return
     */
    @Headers("Content-Type: application/json;charset=UTF-8")
    @POST("appCountPlus.json")
    Observable<Response> appCountPlus(@Body AppCountPlus appCountPlus);
}
