package com.xdja.reckon.api;

import com.xdja.reckon.model.DeviceInfo;
import com.xdja.reckon.model.DeviceState;
import com.xdja.reckon.model.Response;

import java.util.Map;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Guojie on 16/9/6.
 */

public interface DeviceApi {
    /**
     * 上传设备信息,获取deviceId
     *
     * @param deviceInfo
     * @return
     */
    @Headers( "Content-Type: application/json;charset=UTF-8" )
    @POST("deviceInfo.json")
    Observable<Response> getDeviceID(@Body DeviceInfo deviceInfo);

    /**
     * 上传设备运行状态
     *
     * @param deviceState
     * @return
     */
    @Headers( "Content-Type: application/json;charset=UTF-8" )
    @POST("deviceState.json")
    Observable<Response> uploadDeviceState(@Body DeviceState deviceState);

}
