package com.xdja.reckon.device;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.google.gson.annotations.Expose;

/**
 * Created by Guojie on 16/8/31.
 */
public class PhoneInfoUtils {
    /**
     * 获取TelephonyManager
     *
     * @param context
     * @return
     */
    private static TelephonyManager getTelephonyManager(Context context) {
        TelephonyManager telephonyManager = null;
        try {
            if (context != null) {
                telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return telephonyManager;
    }

    /**
     * 获取设备imei
     *
     * @param context
     * @return
     */
    public static String getImei(Context context) {
        String imei = null;
        if (context != null) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                if (telephonyManager != null) {
                    imei = telephonyManager.getDeviceId();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imei;
    }

    /**
     * 获取imsi号
     *
     * @param context
     * @return
     */
    public static String getImsi(Context context) {
        String imsi = null;
        if (context != null) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                if (telephonyManager != null) {
                    imsi = telephonyManager.getSubscriberId();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imsi;
    }

    /**
     * 获取手机号码,实际能否取到值取决于是否已插入sim卡和运营商是否将手机号码写入sim卡
     *
     * @param context
     * @return
     */
    public static String getPhoneNumber(Context context) {
        String phoneNumber = null;
        TelephonyManager telephonyManager = getTelephonyManager(context);
        if (telephonyManager != null) {
            phoneNumber = telephonyManager.getLine1Number();
        }
        return phoneNumber;
    }

    /**
     * 获取运营商
     *
     * @param context
     * @return
     */
    public static String getCarrier(Context context) {
        String carrier = null;
        TelephonyManager telephonyManager = getTelephonyManager(context);
        if (telephonyManager != null) {
            String operator = telephonyManager.getSimOperator();
            if (operator != null) {
                if (operator.equals("46000") || operator.equals("46002") || operator.equals("46007")) {
                    //中国移动
                    carrier = "中国移动";
                } else if (operator.equals("46001")) {
                    //中国联通
                    carrier = "中国联通";
                } else if (operator.equals("46003")) {
                    //中国电信
                    carrier = "中国电信";
                }
            }
        }
        return carrier;
    }

    public static String GetNetworkType(Context context) {
        String strNetworkType = "";

        NetworkInfo networkInfo = ((ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE)).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == ConnectivityManager.TYPE_WIFI) {
                strNetworkType = "WIFI";
            } else if (networkInfo.getType() == ConnectivityManager.TYPE_MOBILE) {
                String _strSubTypeName = networkInfo.getSubtypeName();

                Log.e("TAG", "Network getSubtypeName : " + _strSubTypeName);

                // TD-SCDMA   networkType is 17
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case TelephonyManager.NETWORK_TYPE_GPRS:
                    case TelephonyManager.NETWORK_TYPE_EDGE:
                    case TelephonyManager.NETWORK_TYPE_CDMA:
                    case TelephonyManager.NETWORK_TYPE_1xRTT:
                    case TelephonyManager.NETWORK_TYPE_IDEN: //api<8 : replace by 11
                        strNetworkType = "2G";
                        break;
                    case TelephonyManager.NETWORK_TYPE_UMTS:
                    case TelephonyManager.NETWORK_TYPE_EVDO_0:
                    case TelephonyManager.NETWORK_TYPE_EVDO_A:
                    case TelephonyManager.NETWORK_TYPE_HSDPA:
                    case TelephonyManager.NETWORK_TYPE_HSUPA:
                    case TelephonyManager.NETWORK_TYPE_HSPA:
                    case TelephonyManager.NETWORK_TYPE_EVDO_B: //api<9 : replace by 14
                    case TelephonyManager.NETWORK_TYPE_EHRPD:  //api<11 : replace by 12
                    case TelephonyManager.NETWORK_TYPE_HSPAP:  //api<13 : replace by 15
                        strNetworkType = "3G";
                        break;
                    case TelephonyManager.NETWORK_TYPE_LTE:    //api<11 : replace by 13
                        strNetworkType = "4G";
                        break;
                    default:
                        // http://baike.baidu.com/item/TD-SCDMA 中国移动 联通 电信 三种3G制式
                        if (_strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000")) {
                            strNetworkType = "3G";
                        } else {
                            strNetworkType = _strSubTypeName;
                        }

                        break;
                }

                Log.e("TAG", "Network getSubtype : " + Integer.valueOf(networkType).toString());
            }
        }

        Log.e("TAG", "Network Type : " + strNetworkType);

        return strNetworkType;
    }
    public static final String getAPN(Context context){
        ConnectivityManager connectivityManager= (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo=connectivityManager.getActiveNetworkInfo();
        if(networkInfo!=null){
            return networkInfo.getExtraInfo();
        }
        return null;
    }
}
