package com.xdja.reckon.device;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;

/**
 * Created by Guojie on 16/9/20.
 */

public class SafeCardUtils {
    //获取安全卡ID
    public static final String METHOD_GETSAFECARDID = "getSafeCardID";
    //获取警员编号
    public static final String METHOD_GETPOLICEMANID = "getPolicemanID";

    public static final Uri SAFETF_URI = Uri.parse("content://" + "com.xdja.providers.safetfprovider");

    /**
     * 获取安全卡ID
     *
     * @param context
     * @return
     */
    public static String getCardID(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        Bundle resBundle = null;
        String cardID = null;

        if (contentResolver == null) {
            Log.e("app", "getCardID, contentResolver is null");
            return null;
        }

        try {
            resBundle = contentResolver.call(SAFETF_URI, METHOD_GETSAFECARDID, null, null);
        } catch (Exception e) {
            return null;
        }

        if (resBundle == null) {
            Log.e("app", "getCardID, METHOD_GETSAFECARDID failed");
            return null;
        }

        cardID = resBundle.getString("result");

        if (cardID == null) {
            Log.e("app", "getCardID, getString failed");
            return null;
        }

        return cardID;
    }

    /**
     * 获取警员编号
     *
     * @param context
     * @return
     */
    public static String getPolicemanID(Context context) {
        Bundle resBundle = null;
        String policemanID = null;
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            Log.e("app", "getPolicemanID, contentResolver is null");
            return null;
        }

        resBundle = contentResolver.call(SAFETF_URI, METHOD_GETPOLICEMANID, null, null);

        if (resBundle == null) {
            Log.e("app", "getPolicemanID, METHOD_GETPOLICEMANID failed");
            return null;
        }

        policemanID = resBundle.getString("result");

        if (policemanID == null) {
            Log.e("app", "getPolicemanID, getString failed");
            return null;
        }

        return policemanID;
    }
}
