package com.xdja.reckon.function;

import android.content.Context;
import android.text.TextUtils;

import com.xdja.reckon.share.SharePreConstants;
import com.xdja.reckon.share.SharePrefUtil;

/**
 * 应用ID管理
 *
 * Created by Guojie on 16/9/18.
 */

public class AppManager extends BaseManager{
    /**
     * 本地是否已记录应用ID
     * @param context
     * @return
     */
    public static boolean isExistAppID(Context context) {
        String appId = SharePrefUtil.getString(context, SharePreConstants.APP_ID, null);
        return !TextUtils.isEmpty(appId);
    }

    /**
     * 保存后台获取的应用ID
     * @param context
     * @param appId
     */
    public static void saveAppID(Context context, String appId) {
        SharePrefUtil.saveString(context, SharePreConstants.APP_ID, appId);
    }

    /**
     * 本地缓存的应用ID
     * @param context
     * @return
     */
    public static String getLocalAppID(Context context) {
        String appId = SharePrefUtil.getString(context, SharePreConstants.APP_ID, null);
        return appId;
    }
}
