package com.xdja.reckon.function;

import android.content.Context;
import android.text.TextUtils;

import com.xdja.reckon.share.SharePreConstants;
import com.xdja.reckon.share.SharePrefUtil;

/**
 * Created by Guojie on 16/9/18.
 */

public class PersonManager extends BaseManager {
    /**
     * 是否已缓存personID
     *
     * @param context
     * @return
     */
    public static boolean isExistPersonID(Context context) {
        String personID = SharePrefUtil.getString(context, SharePreConstants.PERSON_ID, null);
        return TextUtils.isEmpty(personID);
    }

    /**
     * 保存PersonID
     *
     * @param context
     * @param personID
     */
    public static void savePersonID(Context context, String personID) {
        SharePrefUtil.saveString(context, SharePreConstants.PERSON_ID, personID);
    }

    /**
     * 获取本地缓存personID
     *s
     * @param context
     * @return
     */
    public static String getLocalPersonID(Context context) {
        String personID = SharePrefUtil.getString(context, SharePreConstants.PERSON_ID, null);
        return personID;
    }
}
