package com.xdja.reckon.model;

import android.content.Context;
import android.os.Build;

import com.xdja.reckon.device.MemoryUtils;
import com.xdja.reckon.device.PhoneInfoUtils;
import com.xdja.reckon.device.SafeCardUtils;
import com.xdja.reckon.device.WifiUtils;
import com.xdja.reckon.function.PersonManager;

/**
 * 设备信息,用于上报设备信息,获取设备id
 *
 * @author Guojie
 *         on 16/9/6.
 */

public class DeviceInfo {
    private String personId;
    private String imei;
    private String imsi;
    private String cpuAbi;
    private String serial;
    private String cardId;
    private String phone;
    private String radioVersion;
    private String display;
    private String manuFacturer;
    private String model;
    private String fingerPrint;
    private String hardware;
    private String sdkInt;
    private String board;
    private String release;
    private String brand;
    private String bootLoader;
    private String device;
    private String macAddress;
    private String networkStandard;
    private String ram;
    private String carrier;

    public String getSdkInt() {
        return sdkInt;
    }

    public void setSdkInt(String sdkInt) {
        this.sdkInt = sdkInt;
    }

    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImsi() {
        return imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public String getCpuAbi() {
        return cpuAbi;
    }

    public void setCpuAbi(String cpuAbi) {
        this.cpuAbi = cpuAbi;
    }

    public String getSerial() {
        return serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public String getCardId() {
        return cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getRadioVersion() {
        return radioVersion;
    }

    public void setRadioVersion(String radioVersion) {
        this.radioVersion = radioVersion;
    }

    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getManuFacturer() {
        return manuFacturer;
    }

    public void setManuFacturer(String manuFacturer) {
        this.manuFacturer = manuFacturer;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getFingerPrint() {
        return fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String getHardware() {
        return hardware;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public String getBoard() {
        return board;
    }

    public void setBoard(String board) {
        this.board = board;
    }

    public String getRelease() {
        return release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getBootLoader() {
        return bootLoader;
    }

    public void setBootLoader(String bootLoader) {
        this.bootLoader = bootLoader;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getMacAddress() {
        return macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getNetworkStandard() {
        return networkStandard;
    }

    public void setNetworkStandard(String networkStandard) {
        this.networkStandard = networkStandard;
    }

    public String getRam() {
        return ram;
    }

    public void setRam(String ram) {
        this.ram = ram;
    }

    public String getCarrier() {
        return carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public static DeviceInfo buildEntity(Context context) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setPersonId(PersonManager.getLocalPersonID(context));
        deviceInfo.setImei(PhoneInfoUtils.getImei(context));
        deviceInfo.setImsi(PhoneInfoUtils.getImsi(context));
        deviceInfo.setCpuAbi(Build.CPU_ABI);
        deviceInfo.setSerial(Build.SERIAL);
        deviceInfo.setCardId(SafeCardUtils.getCardID(context));
        deviceInfo.setPhone(PhoneInfoUtils.getPhoneNumber(context));
        deviceInfo.setRadioVersion(Build.getRadioVersion());
        deviceInfo.setDisplay(Build.DISPLAY);
        deviceInfo.setManuFacturer(Build.MANUFACTURER);
        deviceInfo.setModel(Build.MODEL);
        deviceInfo.setFingerPrint(Build.FINGERPRINT);
        deviceInfo.setHardware(Build.HARDWARE);
        deviceInfo.setSdkInt(Build.VERSION.SDK_INT + "");
        deviceInfo.setBoard(Build.BOARD);
        deviceInfo.setRelease(Build.VERSION.RELEASE);
        deviceInfo.setBrand(Build.BRAND);
        deviceInfo.setBootLoader(Build.BOOTLOADER);
        deviceInfo.setDevice(Build.DEVICE);
        deviceInfo.setMacAddress(WifiUtils.getMacAddress(context));
        deviceInfo.setNetworkStandard(PhoneInfoUtils.GetNetworkType(context));
        deviceInfo.setRam(MemoryUtils.getTotalRAM());
        deviceInfo.setCarrier(PhoneInfoUtils.getCarrier(context));
        return deviceInfo;
    }
}
