package com.xdja.reckon.model;

import android.content.Context;

import com.xdja.reckon.device.BatteryUtils;
import com.xdja.reckon.device.BluetoothUtils;
import com.xdja.reckon.device.GPSUtils;
import com.xdja.reckon.device.MemoryUtils;
import com.xdja.reckon.device.NFCUtils;
import com.xdja.reckon.device.NetWorkUtil;
import com.xdja.reckon.device.PhoneInfoUtils;
import com.xdja.reckon.device.WifiUtils;
import com.xdja.reckon.function.AppManager;
import com.xdja.reckon.function.DeviceManager;
import com.xdja.reckon.function.PersonManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Guojie on 2016/9/26.
 */

public class DeviceState {


    /**
     * deviceId : ff80808157691be3015769437f8a0000
     * appId : 12014033019594423
     * personId : 12014033019594423
     * deviceStateTypes : [{"deviceState":"1","deviceStateType":"dst0001"},{"deviceState":"1","deviceStateType":"dst0002"},{"deviceState":"1","deviceStateType":"dst0004"},{"deviceState":"1","deviceStateType":"dst0005"},{"deviceState":"1","deviceStateType":"dst0006"},{"deviceState":"1","deviceStateType":"dst0008"},{"deviceState":"1","deviceStateType":"dst0009"},{"deviceState":"1","deviceStateType":"dst0010"},{"deviceState":"1","deviceStateType":"dst0011"},{"deviceState":"1","deviceStateType":"dst0012"}]
     */

    private String deviceId;
    private String appId;
    private String personId;
    /**
     * deviceState : 1
     * deviceStateType : dst0001
     */

    private List<DeviceStateTypesBean> deviceStateTypes;


    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public List<DeviceStateTypesBean> getDeviceStateTypes() {
        return deviceStateTypes;
    }

    public void setDeviceStateTypes(List<DeviceStateTypesBean> deviceStateTypes) {
        this.deviceStateTypes = deviceStateTypes;
    }

    public static class DeviceStateTypesBean {
        private Object deviceState;
        private String deviceStateType;

        public DeviceStateTypesBean(String deviceStateType,Object deviceState) {
            this.deviceState = deviceState;
            this.deviceStateType = deviceStateType;
        }

        public Object getDeviceState() {
            return deviceState;
        }

        public void setDeviceState(Object deviceState) {
            this.deviceState = deviceState;
        }

        public Object getDeviceStateType() {
            return deviceStateType;
        }

        public void setDeviceStateType(String deviceStateType) {
            this.deviceStateType = deviceStateType;
        }
    }
    public static DeviceState buildEntity(Context context){
        DeviceState deviceState=new DeviceState();
        deviceState.setPersonId(PersonManager.getLocalPersonID(context));
        deviceState.setDeviceId(DeviceManager.getLocalDeviceID(context));
//        deviceState.setAppId(AppManager.getLocalAppID(context));
        List<DeviceStateTypesBean> list=new ArrayList<>();
        list.add(new DeviceStateTypesBean("dst0001",BluetoothUtils.isEnable() == true ? "1" : "0"));
        list.add(new DeviceStateTypesBean("dst0002",WifiUtils.isEnable(context) == true ? "1" : "0"));
//        list.add(new DeviceStateTypesBean("dst0003",""));
        list.add(new DeviceStateTypesBean("dst0004",GPSUtils.isEnable(context) == true ? "1" : "0"));
        list.add(new DeviceStateTypesBean("dst0005", BatteryUtils.isCharageing(context)));
        list.add(new DeviceStateTypesBean("dst0006",BatteryUtils.getBattertPercent(context)));
        list.add(new DeviceStateTypesBean("dst0007",PhoneInfoUtils.getAPN(context)));
        list.add(new DeviceStateTypesBean("dst0008", NFCUtils.hasNfc(context)==true?"1":"0"));
        list.add(new DeviceStateTypesBean("dst0009", WifiUtils.getMacAddress(context)));
        list.add(new DeviceStateTypesBean("dst0010",PhoneInfoUtils.GetNetworkType(context)));
        list.add(new DeviceStateTypesBean("dst0011", MemoryUtils.getTotalRAM()));
        if(PhoneInfoUtils.getCarrier(context)!=null){
            list.add(new DeviceStateTypesBean("dst0012",PhoneInfoUtils.getCarrier(context)));
        }
        deviceState.setDeviceStateTypes(list);
        return deviceState;
    }
}
