/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon.model;

import android.content.Context;
import com.xdja.reckon.device.BatteryUtils;
import com.xdja.reckon.device.BluetoothUtils;
import com.xdja.reckon.device.GPSUtils;
import com.xdja.reckon.device.MemoryUtils;
import com.xdja.reckon.device.NFCUtils;
import com.xdja.reckon.device.PhoneInfoUtils;
import com.xdja.reckon.device.WifiUtils;
import com.xdja.reckon.function.DeviceManager;
import com.xdja.reckon.function.PersonManager;
import java.util.ArrayList;
import java.util.List;

public class DeviceState {
    private String deviceId;
    private String appId;
    private String personId;
    private List<DeviceStateTypesBean> deviceStateTypes;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public List<DeviceStateTypesBean> getDeviceStateTypes() {
        return this.deviceStateTypes;
    }

    public void setDeviceStateTypes(List<DeviceStateTypesBean> deviceStateTypes) {
        this.deviceStateTypes = deviceStateTypes;
    }

    public static DeviceState buildEntity(Context context) {
        DeviceState deviceState = new DeviceState();
        deviceState.setPersonId(PersonManager.getLocalPersonID(context));
        deviceState.setDeviceId(DeviceManager.getLocalDeviceID(context));
        ArrayList<DeviceStateTypesBean> list = new ArrayList<DeviceStateTypesBean>();
        list.add(new DeviceStateTypesBean("dst0001", BluetoothUtils.isEnable() ? "1" : "0"));
        list.add(new DeviceStateTypesBean("dst0002", WifiUtils.isEnable(context) ? "1" : "0"));
        list.add(new DeviceStateTypesBean("dst0004", GPSUtils.isEnable(context) ? "1" : "0"));
        list.add(new DeviceStateTypesBean("dst0005", BatteryUtils.isCharageing(context)));
        list.add(new DeviceStateTypesBean("dst0006", Float.valueOf(BatteryUtils.getBattertPercent(context))));
        list.add(new DeviceStateTypesBean("dst0007", PhoneInfoUtils.getAPN(context)));
        list.add(new DeviceStateTypesBean("dst0008", NFCUtils.hasNfc(context) ? "1" : "0"));
        list.add(new DeviceStateTypesBean("dst0009", WifiUtils.getMacAddress(context)));
        list.add(new DeviceStateTypesBean("dst0010", PhoneInfoUtils.GetNetworkType(context)));
        list.add(new DeviceStateTypesBean("dst0011", MemoryUtils.getTotalRAM()));
        if (PhoneInfoUtils.getCarrier(context) != null) {
            list.add(new DeviceStateTypesBean("dst0012", PhoneInfoUtils.getCarrier(context)));
        }
        deviceState.setDeviceStateTypes(list);
        return deviceState;
    }

    public static class DeviceStateTypesBean {
        private Object deviceState;
        private String deviceStateType;

        public DeviceStateTypesBean(String deviceStateType, Object deviceState) {
            this.deviceState = deviceState;
            this.deviceStateType = deviceStateType;
        }

        public Object getDeviceState() {
            return this.deviceState;
        }

        public void setDeviceState(Object deviceState) {
            this.deviceState = deviceState;
        }

        public Object getDeviceStateType() {
            return this.deviceStateType;
        }

        public void setDeviceStateType(String deviceStateType) {
            this.deviceStateType = deviceStateType;
        }
    }
}

