/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon.device;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class WifiUtils {
    public static boolean isEnable(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        return wifiManager.isWifiEnabled();
    }

    public static String getMacAddress(Context context) {
        String macAddress = null;
        try {
            Enumeration<NetworkInterface> interfaces = null;
            interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iF = interfaces.nextElement();
                byte[] addr = iF.getHardwareAddress();
                if (addr == null || addr.length == 0) continue;
                StringBuilder buf = new StringBuilder();
                for (byte b : addr) {
                    buf.append(String.format("%02X:", b));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                macAddress = buf.toString();
                Log.d((String)"mac", (String)("interfaceName=" + iF.getName() + ", mac=" + macAddress));
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return macAddress;
    }
}

