/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon.model;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.xdja.reckon.function.DeviceManager;
import com.xdja.reckon.function.PersonManager;

public class AppInfo {
    private static final String TAG = AppInfo.class.getSimpleName();
    private String personId;
    private String deviceId;
    private String appPackage;
    private String appName;
    private String appVersionName;
    private String appVersionCode;
    private long installTime;

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppVersionName() {
        return this.appVersionName;
    }

    public void setAppVersionName(String appVersionName) {
        this.appVersionName = appVersionName;
    }

    public String getAppVersionCode() {
        return this.appVersionCode;
    }

    public void setAppVersionCode(String appVersionCode) {
        this.appVersionCode = appVersionCode;
    }

    public long getInstallTime() {
        return this.installTime;
    }

    public void setInstallTime(long installTime) {
        this.installTime = installTime;
    }

    public static AppInfo buildEntity(Context context) {
        AppInfo appInfo = new AppInfo();
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            appInfo.setPersonId(PersonManager.getLocalPersonID(context));
            appInfo.setDeviceId(DeviceManager.getLocalDeviceID(context));
            appInfo.setAppName(packageInfo.applicationInfo.loadLabel(pm).toString());
            appInfo.setAppPackage(packageInfo.packageName);
            appInfo.setAppVersionCode(packageInfo.versionCode + "");
            appInfo.setAppVersionName(packageInfo.versionName);
            appInfo.setInstallTime(packageInfo.firstInstallTime);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appInfo;
    }
}

