/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.reckon.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import com.xdja.reckon.api.APIManager;
import com.xdja.reckon.common.Log;
import com.xdja.reckon.function.AppManager;
import com.xdja.reckon.function.DeviceManager;
import com.xdja.reckon.function.PersonManager;
import com.xdja.reckon.function.StateListener;
import com.xdja.reckon.model.AppCountPlus;
import com.xdja.reckon.model.AppInfo;
import com.xdja.reckon.model.AppResUsed;
import com.xdja.reckon.model.AppState;
import com.xdja.reckon.model.DeviceInfo;
import com.xdja.reckon.model.DeviceState;
import com.xdja.reckon.model.Response;
import com.xdja.reckon.share.SharePrefUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class ReckonService
extends Service {
    private static final String TAG = ReckonService.class.getSimpleName();
    private CompositeDisposable mCompositeDisposable;
    private ReportBinder reportBinder;
    private Context context;
    private boolean isResport = false;
    private String deviceId;
    private String appId;
    private String personID;
    private int count;
    private RepotrStateListener mRepotrStateListener;
    private StateListener mStateListener;

    public void onCreate() {
        super.onCreate();
        this.context = this;
        this.mCompositeDisposable = new CompositeDisposable();
    }

    public IBinder onBind(Intent intent) {
        Log.i(TAG, "onBind");
        this.reportBinder = new ReportBinder();
        return this.reportBinder;
    }

    private void startReportState() {
        this.addState("\u5f00\u542f\u7edf\u8ba1\u670d\u52a1\u6210\u529f");
        this.mRepotrStateListener.onSuccess();
        this.isResport = true;
        this.reportAppState("1");
        Disposable reportDisposable = Observable.interval((long)5L, (TimeUnit)TimeUnit.MINUTES).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                if (ReckonService.this.isResport) {
                    ReckonService.this.reportAppState("2");
                    ReckonService.this.reportAppResUsed();
                }
            }
        });
        this.mCompositeDisposable.add(reportDisposable);
    }

    private String getRemoteDeviceID() {
        Observable.just((Object)1).flatMap((Function)new Function<Integer, ObservableSource<Response>>(){

            public ObservableSource<Response> apply(Integer integer) throws Exception {
                DeviceInfo deviceInfo = DeviceInfo.buildEntity(ReckonService.this.context);
                return APIManager.getInstance(ReckonService.this.context).getDeviceApiService().getDeviceID(deviceInfo);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Response>(){

            public void onSubscribe(Disposable d) {
                ReckonService.this.mCompositeDisposable.add(d);
            }

            public void onNext(Response response) {
                if ("1".equals(response.getState())) {
                    ReckonService.this.deviceId = response.getData();
                    DeviceManager.saveDeviceID(ReckonService.this.context, ReckonService.this.deviceId);
                    DeviceManager.saveDeviceInfo(ReckonService.this.context);
                    ReckonService.this.reportDeviceState();
                    ReckonService.this.getRemoteAppID();
                    ReckonService.this.addState("\u83b7\u53d6\u8bbe\u5907ID\u6210\u529f:" + ReckonService.this.deviceId);
                } else {
                    ReckonService.this.mRepotrStateListener.onError();
                    ReckonService.this.addState("\u83b7\u53d6\u8bbe\u5907ID\u9519\u8bef:" + response.getError());
                }
            }

            public void onError(Throwable e) {
                ReckonService.this.mRepotrStateListener.onError();
                ReckonService.this.addState("\u83b7\u53d6\u8bbe\u5907ID\u9519\u8bef:" + e.getMessage());
            }

            public void onComplete() {
                Log.i(TAG, "onCompleted");
            }
        });
        return this.deviceId;
    }

    private String getRemoteAppID() {
        AppInfo appInfo = AppInfo.buildEntity(this.context);
        APIManager.getInstance(this.context).getAppInfoApiService().getAppId(appInfo).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Response>(){

            public void onError(Throwable e) {
                ReckonService.this.mRepotrStateListener.onError();
                ReckonService.this.addState("\u83b7\u53d6\u5e94\u7528ID\u9519\u8bef:" + e.getMessage());
            }

            public void onComplete() {
                Log.i(TAG, "onCompleted");
            }

            public void onSubscribe(Disposable d) {
                ReckonService.this.mCompositeDisposable.add(d);
            }

            public void onNext(Response response) {
                if ("1".equals(response.getState())) {
                    ReckonService.this.appId = response.getData();
                    AppManager.saveAppID(ReckonService.this.context, ReckonService.this.appId);
                    ReckonService.this.addState("\u83b7\u53d6\u5e94\u7528ID\u6210\u529f:" + ReckonService.this.appId);
                    ReckonService.this.reportAppUseCount();
                    ReckonService.this.startReportState();
                } else {
                    ReckonService.this.mRepotrStateListener.onError();
                    ReckonService.this.addState("\u83b7\u53d6\u5e94\u7528ID\u9519\u8bef:" + response.getError());
                }
            }
        });
        return this.appId;
    }

    private void reportAppState(final String state) {
        AppState appState = new AppState();
        appState.setPersonId(SharePrefUtil.getString(this.context, "person_id", null));
        appState.setDeviceId(SharePrefUtil.getString(this.context, "device_id", null));
        appState.setAppId(SharePrefUtil.getString(this.context, "app_id", null));
        appState.setAppState(state);
        APIManager.getInstance(this.context).getAppInfoApiService().uploadAppInfo(appState).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Response>(){

            public void onError(Throwable e) {
                if ("3".equals(state)) {
                    ReckonService.this.mRepotrStateListener.onError();
                }
                ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u8fd0\u884c\u72b6\u6001\u5931\u8d25:" + e.getMessage());
            }

            public void onComplete() {
                Log.i(TAG, "onCompleted");
            }

            public void onSubscribe(Disposable d) {
                ReckonService.this.mCompositeDisposable.add(d);
            }

            public void onNext(Response response) {
                Log.i(TAG, response.toString());
                if ("1".equals(response.getState())) {
                    ++ReckonService.this.count;
                    ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u8fd0\u884c\u72b6\u6001\u6210\u529f,\u8fd0\u884c\u72b6\u6001:" + state + ",\u7b2c" + ReckonService.this.count + "\u6b21\u4e0a\u4f20");
                    if (null != ReckonService.this.mRepotrStateListener && "3".equals(state)) {
                        ReckonService.this.mRepotrStateListener.onStopReport();
                    }
                } else {
                    ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u8fd0\u884c\u72b6\u6001\u5931\u8d25:" + response.getError());
                }
            }
        });
    }

    private String reportDeviceState() {
        DeviceState deviceState = DeviceState.buildEntity(this.context);
        APIManager.getInstance(this.context).getDeviceApiService().uploadDeviceState(deviceState).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Response>(){

            public void onError(Throwable e) {
                ReckonService.this.addState("\u4e0a\u62a5\u8bbe\u5907\u72b6\u6001\u5931\u8d25:" + e.getMessage());
            }

            public void onComplete() {
                Log.i(TAG, "onCompleted");
            }

            public void onSubscribe(Disposable d) {
                ReckonService.this.mCompositeDisposable.add(d);
            }

            public void onNext(Response response) {
                if ("1".equals(response.getState())) {
                    ReckonService.this.addState("\u4e0a\u62a5\u8bbe\u5907\u72b6\u6001\u6210\u529f");
                } else {
                    ReckonService.this.addState("\u4e0a\u62a5\u8bbe\u5907\u72b6\u6001\u5931\u8d25:" + response.getError());
                }
            }
        });
        return this.appId;
    }

    private String reportAppResUsed() {
        AppResUsed appResUsed = AppResUsed.buildEntity(this.context);
        APIManager.getInstance(this.context).getAppInfoApiService().uploadAppResUsed(appResUsed).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Response>(){

            public void onError(Throwable e) {
                ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u5360\u7528\u8d44\u6e90\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            }

            public void onComplete() {
                Log.i(TAG, "onCompleted");
            }

            public void onSubscribe(Disposable d) {
                ReckonService.this.mCompositeDisposable.add(d);
            }

            public void onNext(Response response) {
                if ("1".equals(response.getState())) {
                    ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u5360\u7528\u8d44\u6e90\u4fe1\u606f\u6210\u529f");
                } else {
                    ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u5360\u7528\u8d44\u6e90\u4fe1\u606f\u5931\u8d25:" + response.getError());
                }
            }
        });
        return this.appId;
    }

    private String reportAppUseCount() {
        AppCountPlus appCountPlus = new AppCountPlus();
        appCountPlus.setDeviceId(DeviceManager.getLocalDeviceID(this.context));
        appCountPlus.setPersonId(PersonManager.getLocalPersonID(this.context));
        appCountPlus.setAppId(AppManager.getLocalAppID(this.context));
        APIManager.getInstance(this.context).getAppInfoApiService().appCountPlus(appCountPlus).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Response>(){

            public void onError(Throwable e) {
                ReckonService.this.mRepotrStateListener.onError();
                ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u4f7f\u7528\u6b21\u6570\u5931\u8d25:" + e.getMessage());
            }

            public void onComplete() {
                Log.i(TAG, "onCompleted");
            }

            public void onSubscribe(Disposable d) {
                ReckonService.this.mCompositeDisposable.add(d);
            }

            public void onNext(Response response) {
                if ("1".equals(response.getState())) {
                    ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u4f7f\u7528\u6b21\u6570\u6210\u529f");
                } else {
                    ReckonService.this.mRepotrStateListener.onError();
                    ReckonService.this.addState("\u4e0a\u62a5\u5e94\u7528\u4f7f\u7528\u6b21\u6570\u5931\u8d25:" + response.getError());
                }
            }
        });
        return this.deviceId;
    }

    public void onDestroy() {
        super.onDestroy();
        this.unsubcrible();
        this.addState("\u7ec8\u6b62\u7edf\u8ba1\u5206\u6790\u670d\u52a1");
    }

    private void unsubcrible() {
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
        }
    }

    private void addState(String state) {
        if (this.mStateListener != null) {
            this.mStateListener.reportState(state);
            Log.i(TAG, state);
        }
    }

    public static interface RepotrStateListener {
        public void onSuccess();

        public void onStopReport();

        public void onError();
    }

    public class ReportBinder
    extends Binder {
        public void startReport(String personID, RepotrStateListener repotrStateListener) {
            ReckonService.this.mRepotrStateListener = repotrStateListener;
            PersonManager.savePersonID(ReckonService.this.context, personID);
            ReckonService.this.personID = personID;
            if (DeviceManager.isExistDeviceID(ReckonService.this.context) && DeviceManager.isSameDevice(ReckonService.this.context)) {
                ReckonService.this.reportDeviceState();
                if (AppManager.isExistAppID(ReckonService.this.context)) {
                    ReckonService.this.reportAppUseCount();
                    ReckonService.this.startReportState();
                } else {
                    ReckonService.this.getRemoteAppID();
                }
            } else {
                ReckonService.this.getRemoteDeviceID();
            }
        }

        public void stopReport() {
            ReckonService.this.reportAppResUsed();
            ReckonService.this.reportAppState("3");
            ReckonService.this.isResport = false;
            Log.i(TAG, "stopReport");
        }

        public void addSateListener(StateListener stateListener) {
            if (stateListener != null) {
                ReckonService.this.mStateListener = stateListener;
            }
        }
    }
}

