/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sslvpn.api;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.xdja.sslvpn.api.VpnApi50;
import com.xdja.sslvpn.api.VpnStandard;
import com.xdja.sslvpn.api.VpnStartCallback;
import com.xdja.sslvpn.api.VpnState;
import com.xdja.sslvpn.bean.ErrorInfo;
import com.xdja.sslvpn.bean.GateWay;
import com.xdja.sslvpn.bean.MonitorAddress;
import com.xdja.sslvpn.bean.VerifyTime;
import com.xdja.sslvpn.util.GsonUtils;
import java.util.ArrayList;
import java.util.List;

public class VpnApi50Impl
implements VpnApi50 {
    private VpnStandard apiStandard;
    ContentResolver contentResolver;
    private final String RESULT_KEY = "ret";
    private final String PARAM_KEY = "param";
    private final String GET_GATE_WAY_LIST_METHOD = "gateWayList";
    private final String START_VPN = "startSafeClient";
    private final String STOP_VPN = "stopSafeClient";
    private final String VERIFY_TIME = "getLastVerifyTime";
    private final String GET_TUN_STATE = "getVPNTunnelState";
    private final String ERROR_INFO = "getErrorCode";
    private final String MONITOR_SERVER_ADDRESS = "getMonitorServerAddress";
    private final String THIS_FILE = "VpnApi50Impl";

    public VpnApi50Impl(Context context) {
        this.apiStandard = new VpnStandard(context);
        this.contentResolver = context.getContentResolver();
    }

    @Override
    public List<GateWay> getGateWayList() {
        Log.i((String)"VpnApi50Impl", (String)"\u83b7\u53d6\u914d\u7f6e\u7f51\u5173\u5217\u8868");
        Bundle result = this.contentResolver.call(URI, "gateWayList", null, null);
        String jsonValue = result.getString("ret");
        return GsonUtils.listFromJson(jsonValue, GateWay.class);
    }

    @Override
    public int startSafeClient(List<String> marklist) {
        if (marklist == null || marklist.isEmpty()) {
            int result = this.apiStandard.start();
            return result;
        }
        String jsonParam = new Gson().toJson(marklist);
        Log.i((String)"VpnApi50Impl", (String)("\u542f\u52a8\u5b89\u5168\u63a5\u5165 \u53c2\u6570-----------------" + jsonParam));
        Bundle extras = new Bundle();
        extras.putString("param", jsonParam);
        Bundle bundle = this.contentResolver.call(URI, "startSafeClient", null, extras);
        int result = bundle.getInt("ret");
        return result;
    }

    @Override
    public void stopSafeClient(List<String> marklist) {
        if (marklist == null || marklist.isEmpty()) {
            this.apiStandard.stop();
            return;
        }
        Bundle extras = new Bundle();
        String jsonParam = new Gson().toJson(marklist);
        Log.i((String)"VpnApi50Impl", (String)("\u505c\u6b62\u5b89\u5168\u63a5\u5165 \u53c2\u6570 -----------------" + jsonParam));
        extras.putString("param", jsonParam);
        this.contentResolver.call(URI, "stopSafeClient", null, extras);
    }

    @Override
    public List<VerifyTime> getLastVerifyTime(List<String> marklist) {
        List<GateWay> gateWayList;
        ArrayList<VerifyTime> timeList = new ArrayList<VerifyTime>();
        if (marklist == null) {
            marklist = new ArrayList<String>();
        }
        if (marklist.isEmpty() && !(gateWayList = this.getGateWayList()).isEmpty()) {
            for (GateWay gateWay : gateWayList) {
                marklist.add(gateWay.getMark());
            }
        }
        String jsonParam = new Gson().toJson(marklist);
        Log.i((String)"VpnApi50Impl", (String)("\u83b7\u53d6\u8ba4\u8bc1\u65f6\u95f4\u8f93\u5165-----------------" + jsonParam));
        Bundle bundle = new Bundle();
        bundle.putString("param", jsonParam);
        Bundle retBundle = this.contentResolver.call(URI, "getLastVerifyTime", null, bundle);
        if (retBundle != null) {
            String timeStr = retBundle.getString("ret");
            Log.i((String)"VpnApi50Impl", (String)("\u83b7\u53d6\u8ba4\u8bc1\u65f6\u95f4\u8fd4\u56de------" + timeStr));
            timeList = GsonUtils.listFromJson(timeStr, VerifyTime.class);
        }
        return timeList;
    }

    @Override
    public boolean getVPNTunnelState() {
        Log.i((String)"VpnApi50Impl", (String)"\u83b7\u53d6\u901a\u9053\u8fde\u63a5\u72b6\u6001");
        Bundle bundle = this.contentResolver.call(URI, "getVPNTunnelState", null, null);
        boolean connected = bundle.getBoolean("result");
        Log.i((String)"VpnApi50Impl", (String)("\u901a\u9053\u8fde\u63a5\u6210\u529f\uff1f" + connected));
        return connected;
    }

    @Override
    public List<ErrorInfo> getErrorInfo(List<String> marklist) {
        List<GateWay> gateWayList;
        ArrayList errList = new ArrayList();
        if (marklist == null) {
            marklist = new ArrayList<String>();
        }
        if (marklist.isEmpty() && !(gateWayList = this.getGateWayList()).isEmpty()) {
            for (GateWay gateWay : gateWayList) {
                marklist.add(gateWay.getMark());
            }
        }
        String jsonParam = new Gson().toJson(marklist);
        Log.i((String)"VpnApi50Impl", (String)("\u83b7\u53d6\u9519\u8bef\u4fe1\u606f \u53c2\u6570-----------------" + jsonParam));
        Bundle param = new Bundle();
        param.putString("param", jsonParam);
        Bundle bundle = this.contentResolver.call(URI, "getErrorCode", null, param);
        String errStr = bundle.getString("ret");
        Log.d((String)"VpnApi50Impl", (String)("\u83b7\u53d6\u9519\u8bef\u4fe1\u606f \u8fd4\u56de------------------" + errStr));
        return GsonUtils.listFromJson(errStr, ErrorInfo.class);
    }

    @Override
    public List<MonitorAddress> getMonitorServerAddress(List<String> marklist) {
        List<GateWay> gateWayList;
        ArrayList<MonitorAddress> addressList = new ArrayList<MonitorAddress>();
        if (marklist == null) {
            marklist = new ArrayList<String>();
        }
        if (marklist.isEmpty() && !(gateWayList = this.getGateWayList()).isEmpty()) {
            for (GateWay gateWay : gateWayList) {
                marklist.add(gateWay.getMark());
            }
        }
        String jsonParam = new Gson().toJson(marklist);
        Log.i((String)"VpnApi50Impl", (String)("\u83b7\u53d6\u670d\u52a1\u76d1\u542c\u5730\u5740 \u53c2\u6570-----------------" + jsonParam));
        Bundle param = new Bundle();
        param.putString("param", jsonParam);
        Bundle bundle = this.contentResolver.call(URI, "getMonitorServerAddress", null, param);
        String serverStr = bundle.getString("ret");
        if (!TextUtils.isEmpty((CharSequence)serverStr)) {
            Log.i((String)"VpnApi50Impl", (String)("\u83b7\u53d6\u670d\u52a1\u76d1\u542c\u5730\u5740 \u8fd4\u56de-----------------" + serverStr));
            addressList = GsonUtils.listFromJson(serverStr, MonitorAddress.class);
        }
        return addressList;
    }

    @Override
    public int startTunClient() {
        return this.apiStandard.startTunClient();
    }

    @Override
    public int stopTunClient() {
        return this.apiStandard.stopTunClient();
    }

    @Override
    public int start() {
        return this.apiStandard.start();
    }

    @Override
    public int start(VpnStartCallback vpnStartCallback, long connectTime) {
        return this.apiStandard.start(vpnStartCallback, connectTime);
    }

    @Override
    public int stop() {
        return this.apiStandard.stop();
    }

    @Override
    public VpnState getStatus() {
        return this.apiStandard.getStatus();
    }

    @Override
    public String getCardID() {
        return this.apiStandard.getCardID();
    }

    @Override
    public String getDefaultCertSN() {
        return this.apiStandard.getDefaultCertSN();
    }

    @Override
    public byte[] getDefaultCert() {
        return this.apiStandard.getDefaultCert();
    }

    @Override
    public long getLastVerifyTime() {
        return this.apiStandard.getLastVerifyTime();
    }

    @Override
    public int verifyPIN(String pin, int role) {
        return this.apiStandard.verifyPIN(pin, role);
    }

    @Override
    public int RSAPrikeyCalc(byte[] prifid, byte[] datain, int inlen, byte[] out, int[] outlen) {
        return this.apiStandard.RSAPrikeyCalc(prifid, datain, inlen, out, outlen);
    }

    @Override
    public int SM2Sign(byte[] pubfid, byte[] prifid, int datatype, byte[] datain, int inlen, byte[] sign, int[] signlen) {
        return this.apiStandard.SM2Sign(pubfid, prifid, datatype, datain, inlen, sign, signlen);
    }

    @Override
    public int readFile(byte[] fid, int pos, int len, byte[] out) {
        return this.apiStandard.readFile(fid, pos, len, out);
    }

    @Override
    public int readCert(byte[] fid, byte[] cert, int[] len) {
        return this.apiStandard.readCert(fid, cert, len);
    }

    @Override
    public String getMonitorAddress() {
        return this.apiStandard.getMonitorAddress();
    }

    @Override
    public void killSafeClient() {
        this.apiStandard.killSafeClient();
    }
}

