/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sslvpn.api;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.xdja.sslvpn.api.VpnApi40;
import com.xdja.sslvpn.api.VpnStartCallback;
import com.xdja.sslvpn.api.VpnState;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VpnStandard
implements VpnApi40 {
    public static final String AUTOHORITY = "com.xdja.providers.safetfprovider";
    public static final String METHOD_STARTSAFECLIENT = "startSafeClient";
    public static final String METHOD_VERIFYPIN = "verifyPIN";
    public static final String METHOD_READFILE = "readFile";
    public static final String METHOD_READCERT = "readCert";
    public static final String METHOD_RSAPRIKEYCALC = "rsaPriKeyCalc";
    public static final String METHOD_SM2SIGN = "sm2Sign";
    public static final String METHOD_GETSAFECARDID = "getSafeCardID";
    public static final String METHOD_GET_DEFAULT_CERT_SN = "getDefaultCertSN";
    public static final String METHOD_GET_LAST_VERIFY_TIME = "getLastVerifyTime";
    public static final String METHOD_GET_MONITOR_SERVER_ADDRESS = "getMonitorServerAddress";
    public static final String METHOD_KILL_SAFECLIENT = "killSafeClient";
    public static final String METHOD_READ_DEFAULT_CERT = "readDefaultCert";
    public static final String METHOD_EXCUTE_CMD = "excuteCmd";
    private static final Uri URI = Uri.parse((String)"content://com.xdja.providers.safetfprovider");
    private ContentResolver contentResolver = null;
    private Context mContext = null;

    public VpnStandard(Context c) {
        this.mContext = c.getApplicationContext();
        this.contentResolver = c.getContentResolver();
    }

    @Override
    public int startTunClient() {
        ComponentName componetName = new ComponentName("com.xdja.safeclient.tun", "com.xdja.safeclient.tun.StartVpnActivity");
        try {
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            intent.setComponent(componetName);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public int stopTunClient() {
        Intent intent = new Intent();
        intent.setAction("com.xdja.safeclient.tun.action.STOP_SERVICE");
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    @Override
    public int start() {
        Intent intent;
        ComponentName componetName;
        int ret;
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_STARTSAFECLIENT, null, null);
            ret = result.getInt("ret");
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = -2;
        }
        if (ret != 0) {
            componetName = new ComponentName("com.xdja.safeclient", "com.xdja.safeclient.activity.StartVpnActivity");
            try {
                intent = new Intent();
                intent.setFlags(0x10400000);
                intent.setComponent(componetName);
                this.mContext.startActivity(intent);
                ret = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = -2;
            }
        }
        if (ret != 0) {
            componetName = new ComponentName("com.xdja.safeclient", "com.xdja.safeclient.StartVpnActivity");
            try {
                intent = new Intent();
                intent.setFlags(0x10400000);
                intent.setComponent(componetName);
                this.mContext.startActivity(intent);
                ret = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = -2;
            }
        }
        return ret;
    }

    @Override
    public int start(final VpnStartCallback vpnStartCallback, final long connectTime) {
        int ret = this.start();
        if (vpnStartCallback == null || ret == -2) {
            return ret;
        }
        new Thread(){

            @Override
            public void run() {
                long curTime = System.currentTimeMillis();
                while (true) {
                    VpnState result;
                    if ((result = VpnStandard.this.getStatus()).getCode() == 1001) {
                        vpnStartCallback.onSuccess();
                        break;
                    }
                    if (result.getCode() == 1002) {
                        // empty if block
                    }
                    if (result.getCode() == 1003) {
                        vpnStartCallback.onFailed(1003, result.getComment());
                        break;
                    }
                    if (System.currentTimeMillis() - curTime > connectTime) {
                        vpnStartCallback.onTimeout();
                        break;
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        return 0;
    }

    @Override
    public int stop() {
        Intent intent = new Intent();
        intent.setAction("com.xdja.safeclient.action.STOP_SERVICE");
        this.mContext.sendBroadcast(intent);
        return 0;
    }

    @Override
    public VpnState getStatus() {
        VpnState state = new VpnState();
        Bundle inBundle = new Bundle();
        inBundle.putString("cmd", "GETSTATUS");
        try {
            Bundle outBundle = this.contentResolver.call(URI, METHOD_EXCUTE_CMD, null, inBundle);
            int ret = outBundle.getInt("ret");
            if (ret == 0) {
                String comment = outBundle.getString("result");
                String[] commentArray = comment.split(" ");
                String resultStr = commentArray[0];
                String stageStr = commentArray[1];
                String errCodeStr = commentArray[2];
                int errCode = Integer.valueOf(errCodeStr);
                int commentStartIndex = VpnStandard.getCharacterPosition(comment, " ", 3);
                String reasonStr = comment.substring(commentStartIndex);
                state.setComment(reasonStr);
                if (resultStr.equals("OK") && stageStr.equals("100")) {
                    state.setCode(1001);
                } else if (resultStr.equals("OK") || errCode >= 0) {
                    state.setCode(1002);
                } else if (resultStr.equals("FAILED")) {
                    state.setCode(1003);
                }
            } else {
                state.setCode(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            state.setCode(-2);
        }
        return state;
    }

    @Override
    public String getCardID() {
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_GETSAFECARDID, null, null);
            return result.getString("result");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getDefaultCertSN() {
        String certSN = null;
        try {
            Bundle outBundle = this.contentResolver.call(URI, METHOD_READ_DEFAULT_CERT, null, null);
            byte[] certBuf = outBundle.getByteArray("result");
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
                CertificateFactory cf = null;
                cf = CertificateFactory.getInstance("X.509", "BC");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(bin);
                certSN = cert.getSerialNumber().toString(16);
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return certSN;
    }

    @Override
    public byte[] getDefaultCert() {
        byte[] certBuf = null;
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_READ_DEFAULT_CERT, null, null);
            certBuf = result.getByteArray("result");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return certBuf;
    }

    @Override
    public long getLastVerifyTime() {
        long time = 0L;
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_GET_LAST_VERIFY_TIME, null, null);
            time = result.getLong("lastVerifyTime");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    @Override
    public int verifyPIN(String pin, int role) {
        Bundle inBundle = new Bundle();
        int ret = -1;
        try {
            inBundle.putInt("pinrole", role);
            inBundle.putByteArray("pin", pin.getBytes());
            inBundle.putInt("pinlen", pin.getBytes().length);
            Bundle result = this.contentResolver.call(URI, METHOD_VERIFYPIN, null, inBundle);
            ret = result.getInt("ret");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public int RSAPrikeyCalc(byte[] prifid, byte[] datain, int inlen, byte[] out, int[] outlen) {
        Bundle inBundle = new Bundle();
        int ret = -1;
        try {
            inBundle.putByteArray("fid", prifid);
            inBundle.putByteArray("datain", datain);
            inBundle.putInt("inlen", inlen);
            Bundle result = this.contentResolver.call(URI, METHOD_RSAPRIKEYCALC, null, inBundle);
            ret = result.getInt("ret");
            if (ret == 0) {
                byte[] outData = result.getByteArray("result");
                System.arraycopy(outData, 0, out, 0, inlen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public int SM2Sign(byte[] pubfid, byte[] prifid, int datatype, byte[] datain, int inlen, byte[] sign, int[] signlen) {
        Bundle inBundle = new Bundle();
        int ret = -1;
        try {
            inBundle.putByteArray("pubfid", pubfid);
            inBundle.putByteArray("prifid", prifid);
            inBundle.putInt("datatype", datatype);
            inBundle.putByteArray("datain", datain);
            inBundle.putInt("inlen", inlen);
            Bundle result = this.contentResolver.call(URI, METHOD_SM2SIGN, null, inBundle);
            ret = result.getInt("ret");
            if (ret == 0) {
                byte[] outData = result.getByteArray("result");
                System.arraycopy(outData, 0, sign, 0, outData.length);
                signlen[0] = outData.length;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public int readFile(byte[] fid, int pos, int len, byte[] out) {
        Bundle inBundle = new Bundle();
        int ret = -1;
        try {
            inBundle.putByteArray("fid", fid);
            inBundle.putInt("readpos", pos);
            inBundle.putInt("readlen", len);
            Bundle result = this.contentResolver.call(URI, METHOD_READFILE, null, inBundle);
            ret = result.getInt("ret");
            if (ret == 0) {
                byte[] outData = result.getByteArray("result");
                System.arraycopy(outData, 0, out, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public int readCert(byte[] fid, byte[] cert, int[] len) {
        Bundle inBundle = new Bundle();
        inBundle.putByteArray("fid", fid);
        int ret = -1;
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_READCERT, null, inBundle);
            ret = result.getInt("ret");
            if (ret == 0) {
                byte[] certBuf = result.getByteArray("result");
                System.arraycopy(certBuf, 0, cert, 0, certBuf.length);
                len[0] = certBuf.length;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String getMonitorAddress() {
        try {
            Bundle result = this.contentResolver.call(URI, METHOD_GET_MONITOR_SERVER_ADDRESS, null, null);
            return result.getString("result");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "SafeClient not installed";
        }
    }

    @Override
    public void killSafeClient() {
        try {
            this.contentResolver.call(URI, METHOD_KILL_SAFECLIENT, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static int getCharacterPosition(String string, String pattern, int index) {
        Matcher slashMatcher = Pattern.compile(pattern).matcher(string);
        int mIdx = 0;
        while (slashMatcher.find() && ++mIdx != index) {
        }
        return slashMatcher.start();
    }

    @Override
    public String readPoliceManID() throws UnsupportedEncodingException {
        String policemanID = "";
        byte[] fid = new byte[]{0, -102};
        int readPos = 0;
        int readLen = 2;
        int dataLen = 0;
        byte[] pDataLen = new byte[2];
        int result = this.readFile(fid, readPos, readLen, pDataLen);
        if (result == 0) {
            dataLen = this.byteToInt(pDataLen, 2);
            byte[] pData = new byte[dataLen];
            result = this.readFile(fid, readPos += 2, dataLen, pDataLen);
            if (result == 0) {
                policemanID = new String(pData, 0, dataLen, "gbk");
            }
        }
        return policemanID;
    }

    int byteToInt(byte[] b, int len) {
        int mask = 255;
        int temp = 0;
        int n = 0;
        for (int i = 0; i < len; ++i) {
            n <<= 8;
            temp = b[i] & mask;
            n |= temp;
        }
        return n;
    }
}

