package com.xdja.authorize;

import android.content.Context;
import android.text.TextUtils;

/**
 * 统一认证入口
 * Created by lizhiyang on 16-5-14.
 */
public class AuthorHelper {
    private static AuthorHelper instance;
    private Context mcontext;
    private AuthorizeLoginHandler mauthorizeLoginHandler;
    private boolean isAuth;

    private AuthorHelper() {

    }

    public static AuthorHelper getInstance() {
        if (instance == null) {
            synchronized (AuthorHelper.class) {
                if (instance == null) {
                    instance = new AuthorHelper();
                }
            }
        }
        return instance;
    }

    public AuthorHelper init(Context context, AuthorizeLoginHandler authorizeLoginHandler) {
        this.mcontext = context;
        this.mauthorizeLoginHandler = authorizeLoginHandler;
        AuthorizeReceiver.setHandle(mauthorizeLoginHandler);
        isAuth = false;
        return instance;
    }

    public AuthorHelper author(String packageName) {
        author(packageName, AuthorizeLogin.NEED_LOGIN_PAGE);
        return instance;
    }

    public AuthorHelper author(String packageName, String needLoginPage) {
        if (!isAuth) {
            isAuth = true;
            String billString = AuthorizeLogin.getBill(mcontext, packageName, needLoginPage);
            if (!TextUtils.isEmpty(billString)) {
                mauthorizeLoginHandler.onAuthorizeOKHandle(billString);
                isAuth = false;
            } else {
                if (mauthorizeLoginHandler != null) {
                    mauthorizeLoginHandler.onAuthorizeErrorHandle(AuthorizeLogin.getCode(),
                            AuthorizeLogin.getMessage());
                }
                isAuth = false;
            }
        }
        return instance;
    }

    public boolean isAuth() {
        return isAuth;
    }
}
