package com.xdja.authorize;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;

import java.security.PublicKey;


/**
 * 统一认证访问类
 *
 * @author dut
 */
public class AuthorizeLogin {
    /**
     * 需要调起登录页
     */
    public static final String NEED_LOGIN_PAGE="1";
    /**
     * 不需要调起登录页
     */
    public static final String UNNEED_LOGIN_PAGE="0";
    /**
     * 错误代码
     */
    private static String code;
    /**
     * 错误信息
     */
    private static String message;

    /**
     * 从统一认证中取票据
     *
     * @param context 句柄
     * @param packageName
     * @return 票据信息
     */
    public static String getBill(Context context, String packageName) {
        return getBill(context,packageName,NEED_LOGIN_PAGE);
    }
    /**
     * 从统一认证中取票据
     *
     * @param context 句柄
     * @param packageName
     * @param needLoginPage 0：不需要默认的登录界面，1：需要默认的登录界面
     * @return 票据信息
     */
    public static String getBill(Context context, String packageName, String needLoginPage) {
        ContentResolver resolver = context.getContentResolver();
        BillConifg.PAGE_NAME = packageName;
        Uri baseUri = Uri.parse(BillConifg.CONTENT_URI + "/" + BillConifg.PAGE_NAME);
        /**
         * 获取票据的时候是否启动默认的登录界面
         * 0：不需要默认的登录界面，1：需要默认的登录界面
         */
        Uri.Builder builder = baseUri.buildUpon();
        Uri uri = builder.appendQueryParameter("needLoginPage", needLoginPage).build();
        Cursor query = resolver.query(uri, null, null, null, null);
        String billString = null;
        if (query != null) {
            query.moveToFirst();
            if ("0".equals(query.getString(query.getColumnIndex(BillConifg.RESULT_CODE)))) {
                billString = BillOperation.getBillInfoByCurosr(query);
            } else {
                code = query.getString(query.getColumnIndex(BillConifg.RESULT_CODE));
                message = query.getString(query.getColumnIndex(BillConifg.RESULT_MESSAGE));
            }
            query.close();
        }
        return billString;
    }
    public static String getCode() {
        return code;
    }

    public static String getMessage() {
        return message;
    }


}
