package com.xdja.authorize;


import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;

/**
 * 统一认证广播接收器
 *
 * @author dut
 */
public class AuthorizeReceiver extends BroadcastReceiver {

    Context context;
    /**
     * 统一认证访问回调
     */
    static AuthorizeLoginHandler handle;
    /**
     * 请求票据
     */
    private final int REQUEST_BILL = 0;

    /**
     * 设置监听对象
     *
     * @param _handle 监听对象
     */
    public static void setHandle(AuthorizeLoginHandler _handle) {
        handle = _handle;
    }

    @Override
    public void onReceive(Context arg0, Intent arg1) {
        context = arg0;
        if (arg1.getAction().equals(BillConifg.PAGE_NAME)) {
            getData(REQUEST_BILL);
        } else if (arg1.getAction().equals(BillConifg.LOGOUT_SYSTEM)) {
            String packageName = arg1.getStringExtra("packageName");
            //如果包名不是自己，说明是其他应用发启登出，需要退程序
            if (!packageName.equals(BillConifg.PAGE_NAME)) {
                ActivityManager am = (ActivityManager) arg0.getSystemService(Context.ACTIVITY_SERVICE);
                am.killBackgroundProcesses(BillConifg.PAGE_NAME);
                System.exit(0);
            }
        }
    }

    /**
     * 获取数据
     *
     * @param type 类型 请求票据|更新票据
     */
    private void getData(int type) {
        ContentResolver resolver = context.getContentResolver();
        Uri uri = Uri.parse(BillConifg.CONTENT_URI + "/" + BillConifg.PAGE_NAME);
        Cursor query = resolver.query(uri, null, null, null, null);
        if (query != null) {
            query.moveToFirst();
            if ("0".equals(query.getString(query.getColumnIndex(BillConifg.RESULT_CODE)))) {
                if (type == REQUEST_BILL && handle != null) {
                    String billString = BillOperation.getBillInfoByCurosr(query);
                    handle.onAuthorizeOKHandle(billString);
                }

            } else {
                if (handle != null) {
                    handle.onAuthorizeErrorHandle(query.getString(query.getColumnIndex(BillConifg.RESULT_CODE)),
                            query.getString(query.getColumnIndex(BillConifg.RESULT_MESSAGE)));
                }

            }
            query.close();
        }
    }

}
