package com.xdja.authorize;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;


/**
 * 票据操作类
 * @author dut
 *
 */
public class BillOperation {
	
	/**
	 * 从游标中获取票据信息
	 * @param query 游标
	 * @return 票据信息
	 */
	public static String getBillInfoByCurosr(Cursor query) {
		return query.getString(query
				.getColumnIndex(BillConifg.BILLSTR));
	}

	/**
	 * 删除统一认证的票据
	 * @param context 句柄
	 */
	public static void deleteAuthorizeBill(Context context)
	{
		ContentResolver resolver = context.getContentResolver();
		Uri uri = Uri.parse(BillConifg.CONTENT_URI+"/"+context.getPackageName());
		resolver.delete(uri, null, null);
	}
}
