/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.authorize;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.authorize.AuthorizeLogin;
import com.xdja.authorize.AuthorizeLoginHandler;
import com.xdja.authorize.AuthorizeReceiver;

public class AuthorHelper {
    private static AuthorHelper instance;
    private Context mcontext;
    private AuthorizeLoginHandler mauthorizeLoginHandler;
    private boolean isAuth;

    private AuthorHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthorHelper getInstance() {
        if (instance != null) return instance;
        Class<AuthorHelper> clazz = AuthorHelper.class;
        synchronized (AuthorHelper.class) {
            if (instance != null) return instance;
            instance = new AuthorHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AuthorHelper init(Context context, AuthorizeLoginHandler authorizeLoginHandler) {
        this.mcontext = context;
        this.mauthorizeLoginHandler = authorizeLoginHandler;
        AuthorizeReceiver.setHandle(this.mauthorizeLoginHandler);
        this.isAuth = false;
        return instance;
    }

    public AuthorHelper author(String packageName) {
        this.author(packageName, "1");
        return instance;
    }

    public AuthorHelper author(String packageName, String needLoginPage) {
        if (!this.isAuth) {
            this.isAuth = true;
            String billString = AuthorizeLogin.getBill(this.mcontext, packageName, needLoginPage);
            if (!TextUtils.isEmpty((CharSequence)billString)) {
                this.mauthorizeLoginHandler.onAuthorizeOKHandle(billString);
                this.isAuth = false;
            } else {
                if (this.mauthorizeLoginHandler != null) {
                    this.mauthorizeLoginHandler.onAuthorizeErrorHandle(AuthorizeLogin.getCode(), AuthorizeLogin.getMessage());
                }
                this.isAuth = false;
            }
        }
        return instance;
    }

    public boolean isAuth() {
        return this.isAuth;
    }
}

