/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.vpnclient;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.xdja.vpnclient.SafeClientResponse;
import com.xdja.vpnclient.VPNConfig;
import com.xdja.vpnclient.VPNSocket;

public class VPNConnect
implements Runnable {
    private Context context;
    private String IP = "127.0.0.1";
    private int PORT = 3001;
    private int PORT_TUN = 3003;
    private StartSafeClientCallBack sender;
    public static final int ERROR_CODE_FAILURE = -101;
    public static final int ERROR_CODE_TIMEOUT = -102;
    public static final int ERROR_START_FAILURE = -103;
    public static final int ERROR_AUTH_FAILURE = -104;
    private final int STATE_CODE_INIT = 20;
    private final int STATE_AUTH = 30;
    private final int STATE_DEVICE_REPORT = 40;
    private final int STATE_SUCCESS = 100;
    private SafeClientResponse msg = new SafeClientResponse();
    private static final String DEFAULT_PING = "111111";
    public static final int SAFE_TYPE_TRANSMIT = 0;
    public static final int SAFE_TYPE_TUNNEL = 1;
    public static int SAFE_TYPE = 0;

    public VPNConnect(Context context, int safeType, StartSafeClientCallBack sender) {
        this.context = context;
        this.sender = sender;
        SAFE_TYPE = safeType;
    }

    private void startVPNService() {
        if (this.context != null) {
            if (SAFE_TYPE == 0) {
                String safePin = "";
                if (TextUtils.isEmpty((CharSequence)safePin)) {
                    safePin = DEFAULT_PING;
                }
                Intent intent = new Intent();
                intent.setClassName("com.xdja.safeclient", "com.xdja.safeclient.VpnService");
                intent.putExtra("SafePin", safePin);
                this.context.startService(intent);
            } else if (SAFE_TYPE == 1) {
                ComponentName componetName = new ComponentName("com.xdja.safeclient.tun", "com.xdja.safeclient.tun.StartVpnActivity");
                try {
                    Intent intent = new Intent();
                    intent.setFlags(0x10000000);
                    intent.setComponent(componetName);
                    this.context.startActivity(intent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            Toast.makeText((Context)this.context, (CharSequence)"\u53e5\u67c4\u65e0\u6548\uff0c\u542f\u52a8\u670d\u52a1\u5931\u8d25\uff01", (int)1).show();
        }
    }

    public static void stopVPNService(Context context) {
        if (context != null) {
            if (SAFE_TYPE == 0) {
                Intent intent = new Intent();
                intent.setClassName("com.xdja.safeclient", "com.xdja.safeclient.VpnService");
                context.stopService(intent);
            } else if (SAFE_TYPE == 1) {
                Intent intent = new Intent();
                intent.setAction("com.xdja.safeclient.action.STOP_SERVICE");
                context.sendBroadcast(intent);
            }
            Log.e((String)"safeClient", (String)"\u5b89\u5168\u7f51\u7edc\u670d\u52a1\u5df2\u7ecf\u5173\u95ed");
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u53e5\u67c4\u65e0\u6548\uff0c\u542f\u52a8\u670d\u52a1\u5931\u8d25\uff01", (int)1).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        block24: {
            this.startVPNService();
            byte[] vpnstate = new byte[100];
            int vpnstatelen = 0;
            VPNSocket vpnCS = null;
            if (SAFE_TYPE == 0) {
                this.IP = VPNConfig.TRANSMIT_IP;
                this.PORT = VPNConfig.TRANSMIT_PORT;
                vpnCS = new VPNSocket(this.IP, this.PORT);
            } else if (SAFE_TYPE == 1) {
                this.IP = VPNConfig.TUNNEL_IP;
                this.PORT = VPNConfig.TUNNEL_PORT;
                vpnCS = new VPNSocket(this.IP, this.PORT);
            }
            try {
                int nres = vpnCS.connect();
                Log.e((String)"safeClient", (String)(nres + ""));
                Long ctime = System.currentTimeMillis();
                while (nres != 0) {
                    if (System.currentTimeMillis() - ctime > 20000L) {
                        this.msg.setState(-101);
                        this.msg.setDescription("\u8fde\u63a5vpn\u670d\u52a1\u5931\u8d25\uff01");
                        this.sender.sendMessage(this.msg);
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    nres = vpnCS.connect();
                }
                if (nres != 0) break block24;
                vpnCS.sendData("VPNSTART");
                vpnstatelen = vpnCS.recvData(vpnstate);
                String state = null;
                state = new String(vpnstate, 0, vpnstatelen);
                if (!state.startsWith("OK")) {
                    this.msg.setState(-103);
                    this.msg.setDescription("vpn\u8fde\u63a5\u542f\u52a8\u5931\u8d25\uff01");
                    this.sender.sendMessage(this.msg);
                    return;
                }
                ctime = System.currentTimeMillis();
                if (state.startsWith("OK 100")) {
                    this.msg.setState(100);
                    this.msg.setDescription("\u5b89\u5168\u901a\u9053\u5df2\u7ecf\u5efa\u7acb");
                    this.sender.sendMessage(this.msg);
                    break block24;
                }
                while (!state.startsWith("OK 100")) {
                    if (state.startsWith("FAILED")) {
                        String[] temp = state.split(" ");
                        int len = temp[0].length() + 1 + temp[1].length() + 1;
                        String msgTp = new String(vpnstate, len, vpnstatelen - len, "gbK");
                        this.msg.setState(-104);
                        this.msg.setDescription("vpn\u8ba4\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + msgTp);
                        this.sender.sendMessage(this.msg);
                    } else if (System.currentTimeMillis() - ctime > 30000L) {
                        this.msg.setState(-102);
                        this.msg.setDescription("vpn\u8fde\u63a5\u5efa\u7acb\u8d85\u65f6\uff01");
                        this.sender.sendMessage(this.msg);
                    } else {
                        vpnCS.sendData("GETSTATUS");
                        vpnstatelen = vpnCS.recvData(vpnstate);
                        state = new String(vpnstate, 0, vpnstatelen);
                        if (state.startsWith("OK 20")) {
                            this.msg.setState(20);
                            this.msg.setDescription("\u5b89\u5168\u6a21\u5757\u521d\u59cb\u5316\u4e2d...");
                            this.sender.sendMessage(this.msg);
                            continue;
                        }
                        if (state.startsWith("OK 30")) {
                            this.msg.setState(30);
                            this.msg.setDescription("\u6b63\u5728\u8fdb\u884c\u5b89\u5168\u8ba4\u8bc1...");
                            this.sender.sendMessage(this.msg);
                            continue;
                        }
                        if (state.startsWith("OK 40")) {
                            this.msg.setState(40);
                            this.msg.setDescription("\u7ec8\u7aef\u72b6\u6001\u4e0a\u62a5\u4e2d...");
                            this.sender.sendMessage(this.msg);
                            continue;
                        }
                        if (!state.startsWith("OK 100")) continue;
                        this.msg.setState(100);
                        this.msg.setDescription("\u5b89\u5168\u901a\u9053\u5df2\u7ecf\u5efa\u7acb");
                        this.sender.sendMessage(this.msg);
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.msg.setState(-101);
                this.msg.setDescription("\u8fde\u63a5vpn\u670d\u52a1\u5931\u8d25\uff01");
                this.sender.sendMessage(this.msg);
                e.printStackTrace();
            }
            finally {
                if (vpnCS != null) {
                    vpnCS.close();
                }
            }
        }
    }

    @Override
    public void run() {
        this.connect();
    }

    public static interface StartSafeClientCallBack {
        public void sendMessage(SafeClientResponse var1);
    }
}

