package com.xdja.vpnclient;


import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public class SafeClientTool {

    public static final int CODE_ERROR = 101;
    public static final int CODE_SUCCESS = 102;
    private final int safeType;
    private Context context = null;
    private SafeCilentResponseHandle responseHandle;

    /**
     * @param context         上下文
     * @param safeType        // 安全客户端类型0转发1隧道(默认时0转发模式)
     * @param _responseHandle 回调
     */
    public SafeClientTool(Context context,
                          int safeType, SafeCilentResponseHandle _responseHandle) {
        this.context = context;
        this.responseHandle = _responseHandle;
        this.safeType = safeType;
    }

    public void startConnect() {
        // TODO Auto-generated method stub
        VPNConnect connect = new VPNConnect(context, safeType,
                new VPNConnect.StartSafeClientCallBack() {
                    @Override
                    public void sendMessage(SafeClientResponse msg) {
                        // TODO Auto-generated method stub
                        Log.e("msg---->", msg.getDescription());
                        if (msg.getState() == VPNConnect.ERROR_START_FAILURE
                                || msg.getState() == VPNConnect.ERROR_AUTH_FAILURE
                                || msg.getState() == VPNConnect.ERROR_CODE_FAILURE
                                || msg.getState() == VPNConnect.ERROR_CODE_TIMEOUT
                                || msg.getState() == VPNConnect.ERROR_START_CLIENT_FAILURE) {
                            Message msgs = handler.obtainMessage();
                            msgs.obj = msg.getDescription();
                            msgs.what = CODE_ERROR;
                            handler.sendMessage(msgs);
                        } else {
                            Message msgs = handler.obtainMessage();
                            msgs.what = msg.getState();
                            msgs.obj = msg.getDescription();
                            handler.sendMessage(msgs);
                        }
                    }
                });
        Thread thread = new Thread(connect);
        thread.start();

    }

    private Handler handler = new Handler() {
        public void dispatchMessage(Message msg) {
            String msgTip = "";
            switch (msg.what) {
                case CODE_ERROR:
                    msgTip = "安全服务启动失败，请检查网络是否连接正常！";
                    if (msg.obj != null) {
                        msgTip = (String) msg.obj;
                    }
                    if (responseHandle != null) {
                        responseHandle.safeCilentHanledError(CODE_ERROR, msgTip);
                    }
                    break;
                default:
                    msgTip = (String) msg.obj;
                    // Toast.makeText(activity, msgTip, Toast.LENGTH_SHORT).show();
                    if (responseHandle != null) {
                        responseHandle
                                .safeClientHandleSucceed(msg.what, msgTip);
                    }
                    break;
            }
        }

        ;
    };

    public void closeSafeClient() {
        VPNConnect.stopVPNService(context);
    }

}
