package com.xdja.vpnclient;


import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public class SafeClientTool {

    public static final int CODE_ERROR = 101;
    public static final int CODE_SUCCESS = 102;
    private final int safeType;
    private Context context = null;
    private SafeCilentResponseHandle responseHandle;
    private int reConnectCount;

    /**
     * @param context        上下文
     * @param safeType       // 安全客户端类型0转发1隧道(默认时0转发模式)
     * @param responseHandle 回调
     */
    public SafeClientTool(Context context,
                          int safeType, SafeCilentResponseHandle responseHandle) {
        this.context = context;
        this.responseHandle = responseHandle;
        this.safeType = safeType;
    }

    public void startConnect() {
        VPNConnect connect = new VPNConnect(context, safeType,
                new VPNConnect.StartSafeClientCallBack() {
                    @Override
                    public void sendMessage(SafeClientResponse msg) {
                        Log.i("ygj", "msg_what=" + msg.getState());
                        Log.i("ygj", "msg_obj=" + msg.getDescription());
                        if (msg.getState() != VPNConnect.STATE_SUCCESS) {
                            Message msgs = handler.obtainMessage();
                            msgs.obj = msg.getDescription();
                            msgs.what = CODE_ERROR;
                            handler.sendMessage(msgs);
                        } else {
                            if (msg.getState() != VPNConnect.STATE_CODE_INIT
                                    || msg.getState() != VPNConnect.STATE_AUTH
                                    || msg.getState() != VPNConnect.STATE_DEVICE_REPORT) {
                                Message msgs = handler.obtainMessage();
                                msgs.what = msg.getState();
                                msgs.obj = msg.getDescription();
                                handler.sendMessage(msgs);
                            }
                        }
                    }
                });
        Thread thread = new Thread(connect);
        thread.start();

    }

    private Handler handler = new Handler() {
        @Override
        public void dispatchMessage(Message msg) {
            reConnectCount++;
            String msgTip = "";
            switch (msg.what) {
                case CODE_ERROR:
                    Log.i("ygj", "连接安全客户端失败:" + (String) msg.obj);
                    if (reConnectCount <= 5) {
                        startConnect();
                    } else {
                        msgTip = "安全服务启动失败，请检查网络是否连接正常！";
                        if (msg.obj != null) {
                            msgTip = (String) msg.obj;
                        }
                        if (responseHandle != null) {
                            responseHandle.safeCilentHanledError(CODE_ERROR, msgTip);
                        }
                    }
                    break;
                default:
                    Log.i("ygj", "连接安全客户端成功");
                    msgTip = (String) msg.obj;
                    // Toast.makeText(activity, msgTip, Toast.LENGTH_SHORT).show();
                    if (responseHandle != null) {
                        responseHandle.safeClientHandleSucceed(msg.what, msgTip);
                    }
                    break;
            }
        }

        ;
    };

    public void closeSafeClient() {
        VPNConnect.stopVPNService(context);
    }

}
