package com.xdja.vpnclient;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

public class VPNConnect implements Runnable {

    private Context context;
    private String IP = "127.0.0.1";
    private int PORT = 3001;
    private int PORT_TUN = 3003;
    private StartSafeClientCallBack sender;
    public static final int ERROR_CODE_FAILURE = -101; // 连接vpn服务失败
    public static final int ERROR_CODE_TIMEOUT = -102; // 连接超时
    public static final int ERROR_START_FAILURE = -103; // vpn连接启动失败
    public static final int ERROR_AUTH_FAILURE = -104; // vpn认证失败
    public static final int ERROR_START_CLIENT_FAILURE = -105; // 启动安全客户端失败

    public static final int STATE_CODE_INIT = 20; // 安全模块初始化
    public static final int STATE_AUTH = 30; // 正在进行安全认证
    public static final int STATE_DEVICE_REPORT = 40; // 终端状态上报
    public static final int STATE_SUCCESS = 100; // 安全通道已经建立
    private SafeClientResponse msg = new SafeClientResponse();
    private static final String DEFAULT_PING = "111111";

    // 转发
    public static final int SAFE_TYPE_TRANSMIT = 0;
    // 隧道
    public static final int SAFE_TYPE_TUNNEL = 1;

    // 安全客户端类型0转发1隧道
    public static int SAFE_TYPE = SAFE_TYPE_TRANSMIT;

    public VPNConnect(Context context, int safeType, StartSafeClientCallBack sender) {
        super();
        this.context = context;
        this.sender = sender;
        SAFE_TYPE = safeType;
    }

    //启动安全客户端
    private void startSafeClient() {

        if (context != null) {
            try {
                Bundle bundle = context.getContentResolver().call(VPNContants.SAFETF_URI, VPNContants.METHOD_STARTSAFECLIENT, null, null);
                if (bundle != null) {
                    int ret = bundle.getInt("result");
                    if (ret != 0) {
                        msg.setState(ERROR_START_CLIENT_FAILURE);
                        msg.setDescription("启动安全客户端失败");
                        sender.sendMessage(msg);
                    } else {
                        connect();
                    }
                } else {
                    msg.setState(ERROR_START_CLIENT_FAILURE);
                    msg.setDescription("启动安全客户端失败");
                    sender.sendMessage(msg);
                }
            } catch (Exception e) {
                e.printStackTrace();
                msg.setState(ERROR_START_CLIENT_FAILURE);
                msg.setDescription("未设置允许安全客户端自启或关联启动，请到相关软件中设置");
                sender.sendMessage(msg);
            }
        } else {
            msg.setState(ERROR_START_CLIENT_FAILURE);
            msg.setDescription("句柄无效，启动服务失败");
            sender.sendMessage(msg);
        }
    }

    /**
     * 启动VPN service
     */
    private void startVPNService() {
        if (context != null) {
            if (SAFE_TYPE == SAFE_TYPE_TRANSMIT) {
                String safePin = "";//SafeCardManager.getSafeCardManager().getPin();
                if (TextUtils.isEmpty(safePin)) {
                    safePin = DEFAULT_PING;
                }

                Intent intent = new Intent();
                intent.setClassName("com.xdja.safeclient",
                        "com.xdja.safeclient.VpnService");
                intent.putExtra("SafePin", safePin);
                context.startService(intent);
            } else if (SAFE_TYPE == SAFE_TYPE_TUNNEL) {
                ComponentName componetName = new ComponentName(
                        // 这个是另外一个应用程序的包名
                        "com.xdja.safeclient.tun",
                        // 这个参数是要启动的Activity
                        "com.xdja.safeclient.tun.StartVpnActivity");

                try {
                    Intent intent = new Intent();
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.setComponent(componetName);
                    context.startActivity(intent);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        } else {
            Toast.makeText(context, "句柄无效，启动服务失败！", Toast.LENGTH_LONG).show();
        }
    }

    /**
     * 关闭服务
     *
     * @param context
     */
    public static void stopVPNService(Context context) {
        if (context != null) {
            if (SAFE_TYPE == SAFE_TYPE_TRANSMIT) {
//				Intent intent = new Intent("com.xdja.safeclient.VpnService");
                Intent intent = new Intent();
                intent.setClassName("com.xdja.safeclient",
                        "com.xdja.safeclient.VpnService");
                context.stopService(intent);
            } else if (SAFE_TYPE == SAFE_TYPE_TUNNEL) {
                //发送停止服务广播
                Intent intent = new Intent();
                intent.setAction("com.xdja.safeclient.action.STOP_SERVICE");
                context.sendBroadcast(intent);
            }

            Log.e("safeClient", "安全网络服务已经关闭");
        } else {
            Toast.makeText(context, "句柄无效，启动服务失败！", Toast.LENGTH_LONG).show();
        }
    }

    private void connect() {
        byte[] vpnstate = new byte[100];
        int vpnstatelen = 0;
        // 连接安全客户端
        // VPNSocket类是一个简单的socket类
        VPNSocket vpnCS = null;
        if (SAFE_TYPE == SAFE_TYPE_TRANSMIT) {
            IP = VPNConfig.TRANSMIT_IP;
            PORT = VPNConfig.TRANSMIT_PORT;
            vpnCS = new VPNSocket(IP, PORT);
        } else if (SAFE_TYPE == SAFE_TYPE_TUNNEL) {
            IP = VPNConfig.TUNNEL_IP;
            PORT = VPNConfig.TUNNEL_PORT;
            vpnCS = new VPNSocket(IP, PORT);
        }
        try {
            int nres = vpnCS.connect();
            Log.e("safeClient", nres + "");
            Long ctime = System.currentTimeMillis();
            while (nres != 0) {
                if (System.currentTimeMillis() - ctime > 20000) {
                    msg.setState(ERROR_CODE_FAILURE);
                    msg.setDescription("连接vpn服务失败！");
                    sender.sendMessage(msg);
                    break;
                }
                try {
                    Thread.sleep(1000);
                } catch (Exception ex) {
                }
                nres = vpnCS.connect();
            }
            // 启动安全客户端
            if (nres == 0) {
                vpnCS.sendData("VPNSTART"); // 发送启动命令
                vpnstatelen = vpnCS.recvData(vpnstate);
                // 通过判断返回的状态判断是否启动安全客户端成功
                String state = null;
                state = new String(vpnstate, 0, vpnstatelen);
                if (!state.startsWith("OK")) {
                    msg.setState(ERROR_START_FAILURE);
                    msg.setDescription("vpn连接启动失败！");
                    sender.sendMessage(msg);
                    return;
                }
                // 循环发送getstatus命令检测安全通道是否已经建立，如果出错或者超//时将返回对应错误
                ctime = System.currentTimeMillis();
                if (state.startsWith("OK 100")) {
                    msg.setState(STATE_SUCCESS);
                    msg.setDescription("安全通道已经建立");
                    sender.sendMessage(msg);
                } else {
                    while (!state.startsWith("OK 100")) {
                        if (state.startsWith("FAILED")) {
                            String[] temp = state.split(" ");
                            int len = temp[0].length() + 1 + temp[1].length()
                                    + 1;
                            String msgTp = new String(vpnstate, len,
                                    vpnstatelen - len, "gbK");
                            // Log.e("AUTH FAILURE", msgTp+"");
                            msg.setState(ERROR_AUTH_FAILURE);
                            msg.setDescription("vpn认证失败，失败原因：" + msgTp);
                            sender.sendMessage(msg);
                            break;
                        }
                        if (System.currentTimeMillis() - ctime > 30000) {
                            msg.setState(ERROR_CODE_TIMEOUT);
                            msg.setDescription("vpn连接建立超时！");
                            sender.sendMessage(msg);
                            break;
                        }
                        vpnCS.sendData("GETSTATUS");
                        vpnstatelen = vpnCS.recvData(vpnstate);
                        state = new String(vpnstate, 0, vpnstatelen);
                        // Log.e("state", state);
                        if (state.startsWith("OK 20")) {
                            msg.setState(STATE_CODE_INIT);
                            msg.setDescription("安全模块初始化中...");
                            sender.sendMessage(msg);
                        } else if (state.startsWith("OK 30")) {
                            msg.setState(STATE_AUTH);
                            msg.setDescription("正在进行安全认证...");
                            sender.sendMessage(msg);
                        } else if (state.startsWith("OK 40")) {
                            msg.setState(STATE_DEVICE_REPORT);
                            msg.setDescription("终端状态上报中...");
                            sender.sendMessage(msg);
                        } else if (state.startsWith("OK 100")) {
                            msg.setState(STATE_SUCCESS);
                            msg.setDescription("安全通道已经建立");
                            sender.sendMessage(msg);
                            break;
                        }
                    }
                }
            }
        } catch (Exception e) {
            msg.setState(ERROR_CODE_FAILURE);
            msg.setDescription("连接vpn服务失败！");
            sender.sendMessage(msg);
            e.printStackTrace();
        } finally {
            if (vpnCS != null) {
                vpnCS.close();
            }
        }
    }

    public interface StartSafeClientCallBack {
        public void sendMessage(SafeClientResponse msg);
    }

    @Override
    public void run() {
        startSafeClient();
    }

}
