/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils;

import android.app.Activity;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.view.View;
import com.lidroid.xutils.util.LogUtils;
import com.lidroid.xutils.view.EventListenerManager;
import com.lidroid.xutils.view.ResLoader;
import com.lidroid.xutils.view.ViewFinder;
import com.lidroid.xutils.view.ViewInjectInfo;
import com.lidroid.xutils.view.annotation.ContentView;
import com.lidroid.xutils.view.annotation.PreferenceInject;
import com.lidroid.xutils.view.annotation.ResInject;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.EventBase;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ViewUtils {
    private ViewUtils() {
    }

    public static void inject(View view) {
        ViewUtils.injectObject(view, new ViewFinder(view));
    }

    public static void inject(Activity activity) {
        ViewUtils.injectObject(activity, new ViewFinder(activity));
    }

    public static void inject(PreferenceActivity preferenceActivity) {
        ViewUtils.injectObject(preferenceActivity, new ViewFinder(preferenceActivity));
    }

    public static void inject(Object handler, View view) {
        ViewUtils.injectObject(handler, new ViewFinder(view));
    }

    public static void inject(Object handler, Activity activity) {
        ViewUtils.injectObject(handler, new ViewFinder(activity));
    }

    public static void inject(Object handler, PreferenceGroup preferenceGroup) {
        ViewUtils.injectObject(handler, new ViewFinder(preferenceGroup));
    }

    public static void inject(Object handler, PreferenceActivity preferenceActivity) {
        ViewUtils.injectObject(handler, new ViewFinder(preferenceActivity));
    }

    private static void injectObject(Object handler, ViewFinder finder) {
        Method[] methods;
        Field[] fields;
        Class<?> handlerType = handler.getClass();
        ContentView contentView = handlerType.getAnnotation(ContentView.class);
        if (contentView != null) {
            try {
                Method setContentViewMethod = handlerType.getMethod("setContentView", Integer.TYPE);
                setContentViewMethod.invoke(handler, contentView.value());
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
        if ((fields = handlerType.getDeclaredFields()) != null && fields.length > 0) {
            for (Field field : fields) {
                ViewInject viewInject = field.getAnnotation(ViewInject.class);
                if (viewInject != null) {
                    try {
                        View view = finder.findViewById(viewInject.value(), viewInject.parentId());
                        if (view == null) continue;
                        field.setAccessible(true);
                        field.set(handler, view);
                    }
                    catch (Throwable e) {
                        LogUtils.e(e.getMessage(), e);
                    }
                    continue;
                }
                ResInject resInject = field.getAnnotation(ResInject.class);
                if (resInject != null) {
                    try {
                        Object res = ResLoader.loadRes(resInject.type(), finder.getContext(), resInject.id());
                        if (res == null) continue;
                        field.setAccessible(true);
                        field.set(handler, res);
                    }
                    catch (Throwable e) {
                        LogUtils.e(e.getMessage(), e);
                    }
                    continue;
                }
                PreferenceInject preferenceInject = field.getAnnotation(PreferenceInject.class);
                if (preferenceInject == null) continue;
                try {
                    Preference preference = finder.findPreference(preferenceInject.value());
                    if (preference == null) continue;
                    field.setAccessible(true);
                    field.set(handler, preference);
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
        if ((methods = handlerType.getDeclaredMethods()) != null && methods.length > 0) {
            for (Method method : methods) {
                Annotation[] annotations = method.getDeclaredAnnotations();
                if (annotations == null || annotations.length <= 0) continue;
                for (Annotation annotation : annotations) {
                    Class<? extends Annotation> annType = annotation.annotationType();
                    if (annType.getAnnotation(EventBase.class) == null) continue;
                    method.setAccessible(true);
                    try {
                        Method valueMethod = annType.getDeclaredMethod("value", new Class[0]);
                        Method parentIdMethod = null;
                        try {
                            parentIdMethod = annType.getDeclaredMethod("parentId", new Class[0]);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        Object values = valueMethod.invoke((Object)annotation, new Object[0]);
                        Object parentIds = parentIdMethod == null ? null : parentIdMethod.invoke((Object)annotation, new Object[0]);
                        int parentIdsLen = parentIds == null ? 0 : Array.getLength(parentIds);
                        int len = Array.getLength(values);
                        for (int i = 0; i < len; ++i) {
                            ViewInjectInfo info = new ViewInjectInfo();
                            info.value = Array.get(values, i);
                            info.parentId = parentIdsLen > i ? (Integer)Array.get(parentIds, i) : 0;
                            EventListenerManager.addEventMethod(finder, info, annotation, handler, method);
                        }
                    }
                    catch (Throwable e) {
                        LogUtils.e(e.getMessage(), e);
                    }
                }
            }
        }
    }
}

