/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.cache;

import com.lidroid.xutils.cache.FileNameGenerator;
import com.lidroid.xutils.cache.MD5FileNameGenerator;
import com.lidroid.xutils.util.IOUtils;
import com.lidroid.xutils.util.LogUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class LruDiskCache
implements Closeable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final char CLEAN = 'C';
    private static final char UPDATE = 'U';
    private static final char DELETE = 'D';
    private static final char READ = 'R';
    private static final char EXPIRY_PREFIX = 't';
    private final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    private final int valueCount;
    private long size = 0L;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private int redundantOpCount;
    private long nextSequenceNumber = 0L;
    final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> cleanupCallable = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LruDiskCache lruDiskCache = LruDiskCache.this;
            synchronized (lruDiskCache) {
                if (LruDiskCache.this.journalWriter == null) {
                    return null;
                }
                LruDiskCache.this.trimToSize();
                if (LruDiskCache.this.journalRebuildRequired()) {
                    LruDiskCache.this.rebuildJournal();
                    LruDiskCache.this.redundantOpCount = 0;
                }
            }
            return null;
        }
    };
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    private FileNameGenerator fileNameGenerator = new MD5FileNameGenerator();

    private LruDiskCache(File directory, int appVersion, int valueCount, long maxSize) {
        this.directory = directory;
        this.appVersion = appVersion;
        this.journalFile = new File(directory, JOURNAL_FILE);
        this.journalFileTmp = new File(directory, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(directory, JOURNAL_FILE_BACKUP);
        this.valueCount = valueCount;
        this.maxSize = maxSize;
    }

    public static LruDiskCache open(File directory, int appVersion, int valueCount, long maxSize) throws IOException {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (valueCount <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        File backupFile = new File(directory, JOURNAL_FILE_BACKUP);
        if (backupFile.exists()) {
            File journalFile = new File(directory, JOURNAL_FILE);
            if (journalFile.exists()) {
                backupFile.delete();
            } else {
                LruDiskCache.renameTo(backupFile, journalFile, false);
            }
        }
        LruDiskCache cache = new LruDiskCache(directory, appVersion, valueCount, maxSize);
        if (cache.journalFile.exists()) {
            try {
                cache.readJournal();
                cache.processJournal();
                cache.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cache.journalFile, true), "US-ASCII"));
                return cache;
            }
            catch (Throwable journalIsCorrupt) {
                LogUtils.e("DiskLruCache " + directory + " is corrupt: " + journalIsCorrupt.getMessage() + ", removing", journalIsCorrupt);
                cache.delete();
            }
        }
        if (directory.exists() || directory.mkdirs()) {
            cache = new LruDiskCache(directory, appVersion, valueCount, maxSize);
            cache.rebuildJournal();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJournal() throws IOException {
        StrictLineReader reader = null;
        try {
            reader = new StrictLineReader(new FileInputStream(this.journalFile));
            String magic = reader.readLine();
            String version = reader.readLine();
            String appVersionString = reader.readLine();
            String valueCountString = reader.readLine();
            String blank = reader.readLine();
            if (!(MAGIC.equals(magic) && VERSION.equals(version) && Integer.toString(this.appVersion).equals(appVersionString) && Integer.toString(this.valueCount).equals(valueCountString) && "".equals(blank))) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + "]");
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine(reader.readLine());
                    ++lineCount;
                }
            }
            catch (EOFException endOfJournal) {
                this.redundantOpCount = lineCount - this.lruEntries.size();
                IOUtils.closeQuietly(reader);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
    }

    private void readJournalLine(String line) throws IOException {
        Entry entry;
        String diskKey;
        int firstSpace = line.indexOf(32);
        char lineTag = '\u0000';
        if (firstSpace != 1) {
            throw new IOException("unexpected journal line: " + line);
        }
        lineTag = line.charAt(0);
        int keyBegin = firstSpace + 1;
        int secondSpace = line.indexOf(32, keyBegin);
        if (secondSpace == -1) {
            diskKey = line.substring(keyBegin);
            if (lineTag == 'D') {
                this.lruEntries.remove(diskKey);
                return;
            }
        } else {
            diskKey = line.substring(keyBegin, secondSpace);
        }
        if ((entry = this.lruEntries.get(diskKey)) == null) {
            entry = new Entry(diskKey);
            this.lruEntries.put(diskKey, entry);
        }
        switch (lineTag) {
            case 'C': {
                entry.readable = true;
                entry.currentEditor = null;
                String[] parts = line.substring(secondSpace + 1).split(" ");
                if (parts.length <= 0) break;
                try {
                    if (parts[0].charAt(0) == 't') {
                        entry.expiryTimestamp = Long.valueOf(parts[0].substring(1));
                        entry.setLengths(parts, 1);
                        break;
                    }
                    entry.expiryTimestamp = Long.MAX_VALUE;
                    entry.setLengths(parts, 0);
                    break;
                }
                catch (Throwable e) {
                    throw new IOException("unexpected journal line: " + line);
                }
            }
            case 'U': {
                entry.currentEditor = new Editor(entry);
                break;
            }
            case 'R': {
                break;
            }
            default: {
                throw new IOException("unexpected journal line: " + line);
            }
        }
    }

    private void processJournal() throws IOException {
        LruDiskCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            Entry entry = i.next();
            if (entry.currentEditor == null) {
                for (t = 0; t < this.valueCount; ++t) {
                    this.size += entry.lengths[t];
                }
                continue;
            }
            entry.currentEditor = null;
            for (t = 0; t < this.valueCount; ++t) {
                LruDiskCache.deleteIfExists(entry.getCleanFile(t));
                LruDiskCache.deleteIfExists(entry.getDirtyFile(t));
            }
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rebuildJournal() throws IOException {
        if (this.journalWriter != null) {
            IOUtils.closeQuietly(this.journalWriter);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), "US-ASCII"));
            writer.write(MAGIC);
            writer.write("\n");
            writer.write(VERSION);
            writer.write("\n");
            writer.write(Integer.toString(this.appVersion));
            writer.write("\n");
            writer.write(Integer.toString(this.valueCount));
            writer.write("\n");
            writer.write("\n");
            for (Entry entry : this.lruEntries.values()) {
                if (entry.currentEditor != null) {
                    writer.write("U " + entry.diskKey + '\n');
                    continue;
                }
                writer.write("C " + entry.diskKey + " " + 't' + entry.expiryTimestamp + entry.getLengths() + '\n');
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        if (this.journalFile.exists()) {
            LruDiskCache.renameTo(this.journalFile, this.journalFileBackup, true);
        }
        LruDiskCache.renameTo(this.journalFileTmp, this.journalFile, false);
        this.journalFileBackup.delete();
        this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), "US-ASCII"));
    }

    private static void deleteIfExists(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    private static void renameTo(File from, File to, boolean deleteDestination) throws IOException {
        if (deleteDestination) {
            LruDiskCache.deleteIfExists(to);
        }
        if (!from.renameTo(to)) {
            throw new IOException();
        }
    }

    public synchronized long getExpiryTimestamp(String key) throws IOException {
        String diskKey = this.fileNameGenerator.generate(key);
        this.checkNotClosed();
        Entry entry = this.lruEntries.get(diskKey);
        if (entry == null) {
            return 0L;
        }
        return entry.expiryTimestamp;
    }

    public File getCacheFile(String key, int index) {
        String diskKey = this.fileNameGenerator.generate(key);
        File result = new File(this.directory, diskKey + "." + index);
        if (result.exists()) {
            return result;
        }
        try {
            this.remove(key);
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return null;
    }

    public Snapshot get(String key) throws IOException {
        String diskKey = this.fileNameGenerator.generate(key);
        return this.getByDiskKey(diskKey);
    }

    private synchronized Snapshot getByDiskKey(String diskKey) throws IOException {
        this.checkNotClosed();
        Entry entry = this.lruEntries.get(diskKey);
        if (entry == null) {
            return null;
        }
        if (!entry.readable) {
            return null;
        }
        if (entry.expiryTimestamp < System.currentTimeMillis()) {
            for (int i = 0; i < this.valueCount; ++i) {
                File file = entry.getCleanFile(i);
                if (file.exists() && !file.delete()) {
                    throw new IOException("failed to delete " + file);
                }
                this.size -= entry.lengths[i];
                ((Entry)entry).lengths[i] = 0L;
            }
            ++this.redundantOpCount;
            this.journalWriter.append("D " + diskKey + '\n');
            this.lruEntries.remove(diskKey);
            if (this.journalRebuildRequired()) {
                this.executorService.submit(this.cleanupCallable);
            }
            return null;
        }
        FileInputStream[] ins = new FileInputStream[this.valueCount];
        try {
            for (int i = 0; i < this.valueCount; ++i) {
                ins[i] = new FileInputStream(entry.getCleanFile(i));
            }
        }
        catch (FileNotFoundException e) {
            for (int i = 0; i < this.valueCount && ins[i] != null; ++i) {
                IOUtils.closeQuietly(ins[i]);
            }
            return null;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("R " + diskKey + '\n');
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return new Snapshot(diskKey, entry.sequenceNumber, ins, entry.lengths);
    }

    public Editor edit(String key) throws IOException {
        String diskKey = this.fileNameGenerator.generate(key);
        return this.editByDiskKey(diskKey, -1L);
    }

    private synchronized Editor editByDiskKey(String diskKey, long expectedSequenceNumber) throws IOException {
        this.checkNotClosed();
        Entry entry = this.lruEntries.get(diskKey);
        if (expectedSequenceNumber != -1L && (entry == null || entry.sequenceNumber != expectedSequenceNumber)) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(diskKey);
            this.lruEntries.put(diskKey, entry);
        } else if (entry.currentEditor != null) {
            return null;
        }
        Editor editor = new Editor(entry);
        entry.currentEditor = editor;
        this.journalWriter.write("U " + diskKey + '\n');
        this.journalWriter.flush();
        return editor;
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        this.executorService.submit(this.cleanupCallable);
    }

    public synchronized long size() {
        return this.size;
    }

    private synchronized void completeEdit(Editor editor, boolean success) throws IOException {
        int i;
        Entry entry = editor.entry;
        if (entry.currentEditor != editor) {
            throw new IllegalStateException();
        }
        if (success && !entry.readable) {
            for (i = 0; i < this.valueCount; ++i) {
                if (!editor.written[i]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                }
                if (entry.getDirtyFile(i).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (i = 0; i < this.valueCount; ++i) {
            File dirty = entry.getDirtyFile(i);
            if (success) {
                long newLength;
                if (!dirty.exists()) continue;
                File clean = entry.getCleanFile(i);
                dirty.renameTo(clean);
                long oldLength = entry.lengths[i];
                ((Entry)entry).lengths[i] = newLength = clean.length();
                this.size = this.size - oldLength + newLength;
                continue;
            }
            LruDiskCache.deleteIfExists(dirty);
        }
        ++this.redundantOpCount;
        entry.currentEditor = null;
        if (entry.readable | success) {
            entry.readable = true;
            this.journalWriter.write("C " + entry.diskKey + " " + 't' + entry.expiryTimestamp + entry.getLengths() + '\n');
            if (success) {
                entry.sequenceNumber = this.nextSequenceNumber++;
            }
        } else {
            this.lruEntries.remove(entry.diskKey);
            this.journalWriter.write("D " + entry.diskKey + '\n');
        }
        this.journalWriter.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
    }

    private boolean journalRebuildRequired() {
        int redundantOpCompactThreshold = 2000;
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public boolean remove(String key) throws IOException {
        String diskKey = this.fileNameGenerator.generate(key);
        return this.removeByDiskKey(diskKey);
    }

    private synchronized boolean removeByDiskKey(String diskKey) throws IOException {
        this.checkNotClosed();
        Entry entry = this.lruEntries.get(diskKey);
        if (entry == null || entry.currentEditor != null) {
            return false;
        }
        for (int i = 0; i < this.valueCount; ++i) {
            File file = entry.getCleanFile(i);
            if (file.exists() && !file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.size -= entry.lengths[i];
            ((Entry)entry).lengths[i] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("D " + diskKey + '\n');
        this.lruEntries.remove(diskKey);
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return true;
    }

    public synchronized boolean isClosed() {
        return this.journalWriter == null;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() throws IOException {
        this.checkNotClosed();
        this.trimToSize();
        this.journalWriter.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.journalWriter == null) {
            return;
        }
        for (Entry entry : new ArrayList<Entry>(this.lruEntries.values())) {
            if (entry.currentEditor == null) continue;
            entry.currentEditor.abort();
        }
        this.trimToSize();
        this.journalWriter.close();
        this.journalWriter = null;
    }

    private void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            Map.Entry<String, Entry> toEvict = this.lruEntries.entrySet().iterator().next();
            this.removeByDiskKey(toEvict.getKey());
        }
    }

    public void delete() throws IOException {
        IOUtils.closeQuietly(this);
        LruDiskCache.deleteContents(this.directory);
    }

    private static String inputStreamToString(InputStream in) throws IOException {
        return LruDiskCache.readFully(new InputStreamReader(in, "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFully(Reader reader) throws IOException {
        StringWriter writer = null;
        try {
            int count;
            writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(writer);
        }
    }

    private static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("not a readable directory: " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                LruDiskCache.deleteContents(file);
            }
            if (!file.exists() || file.delete()) continue;
            throw new IOException("failed to delete file: " + file);
        }
    }

    public FileNameGenerator getFileNameGenerator() {
        return this.fileNameGenerator;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        if (fileNameGenerator != null) {
            this.fileNameGenerator = fileNameGenerator;
        }
    }

    private class StrictLineReader
    implements Closeable {
        private static final byte CR = 13;
        private static final byte LF = 10;
        private final InputStream in;
        private final Charset charset = Charset.forName("US-ASCII");
        private byte[] buf;
        private int pos;
        private int end;

        public StrictLineReader(InputStream in) {
            this(in, 8192);
        }

        public StrictLineReader(InputStream in, int capacity) {
            if (in == null) {
                throw new NullPointerException();
            }
            if (capacity < 0) {
                throw new IllegalArgumentException("capacity <= 0");
            }
            this.in = in;
            this.buf = new byte[capacity];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                if (this.buf != null) {
                    this.buf = null;
                    this.in.close();
                }
            }
        }

        public String readLine() throws IOException {
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                if (this.buf == null) {
                    throw new IOException("LineReader is closed");
                }
                if (this.pos >= this.end) {
                    this.fillBuf();
                }
                for (int i = this.pos; i != this.end; ++i) {
                    if (this.buf[i] != 10) continue;
                    int lineEnd = i != this.pos && this.buf[i - 1] == 13 ? i - 1 : i;
                    String res = new String(this.buf, this.pos, lineEnd - this.pos, this.charset.name());
                    this.pos = i + 1;
                    return res;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream(this.end - this.pos + 80){

                    @Override
                    public String toString() {
                        int length = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                        try {
                            return new String(this.buf, 0, length, StrictLineReader.this.charset.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                };
                block4: while (true) {
                    out.write(this.buf, this.pos, this.end - this.pos);
                    this.end = -1;
                    this.fillBuf();
                    int i = this.pos;
                    while (true) {
                        if (i == this.end) continue block4;
                        if (this.buf[i] == 10) {
                            if (i != this.pos) {
                                out.write(this.buf, this.pos, i - this.pos);
                            }
                            out.flush();
                            this.pos = i + 1;
                            return out.toString();
                        }
                        ++i;
                    }
                    break;
                }
            }
        }

        private void fillBuf() throws IOException {
            int result = this.in.read(this.buf, 0, this.buf.length);
            if (result == -1) {
                throw new EOFException();
            }
            this.pos = 0;
            this.end = result;
        }
    }

    private final class Entry {
        private final String diskKey;
        private long expiryTimestamp = Long.MAX_VALUE;
        private final long[] lengths;
        private boolean readable;
        private Editor currentEditor;
        private long sequenceNumber;

        private Entry(String diskKey) {
            this.diskKey = diskKey;
            this.lengths = new long[LruDiskCache.this.valueCount];
        }

        public String getLengths() throws IOException {
            StringBuilder result = new StringBuilder();
            for (long size : this.lengths) {
                result.append(" ").append(size);
            }
            return result.toString();
        }

        private void setLengths(String[] strings, int startIndex) throws IOException {
            if (strings.length - startIndex != LruDiskCache.this.valueCount) {
                throw this.invalidLengths(strings);
            }
            try {
                for (int i = 0; i < LruDiskCache.this.valueCount; ++i) {
                    this.lengths[i] = Long.parseLong(strings[i + startIndex]);
                }
            }
            catch (NumberFormatException e) {
                throw this.invalidLengths(strings);
            }
        }

        private IOException invalidLengths(String[] strings) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(strings));
        }

        public File getCleanFile(int i) {
            return new File(LruDiskCache.this.directory, this.diskKey + "." + i);
        }

        public File getDirtyFile(int i) {
            return new File(LruDiskCache.this.directory, this.diskKey + "." + i + ".tmp");
        }
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean hasErrors;
        private boolean committed;

        private Editor(Entry entry) {
            this.entry = entry;
            this.written = entry.readable ? null : new boolean[LruDiskCache.this.valueCount];
        }

        public void setEntryExpiryTimestamp(long timestamp) {
            this.entry.expiryTimestamp = timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int index) throws IOException {
            LruDiskCache lruDiskCache = LruDiskCache.this;
            synchronized (lruDiskCache) {
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    return null;
                }
                try {
                    return new FileInputStream(this.entry.getCleanFile(index));
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        }

        public String getString(int index) throws IOException {
            InputStream in = this.newInputStream(index);
            return in != null ? LruDiskCache.inputStreamToString(in) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int index) throws IOException {
            LruDiskCache lruDiskCache = LruDiskCache.this;
            synchronized (lruDiskCache) {
                FileOutputStream outputStream;
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    this.written[index] = true;
                }
                File dirtyFile = this.entry.getDirtyFile(index);
                try {
                    outputStream = new FileOutputStream(dirtyFile);
                }
                catch (FileNotFoundException e) {
                    LruDiskCache.this.directory.mkdirs();
                    try {
                        outputStream = new FileOutputStream(dirtyFile);
                    }
                    catch (FileNotFoundException e2) {
                        return NULL_OUTPUT_STREAM;
                    }
                }
                return new FaultHidingOutputStream(outputStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int index, String value) throws IOException {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(this.newOutputStream(index), "UTF-8");
                writer.write(value);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }

        public void commit() throws IOException {
            if (this.hasErrors) {
                LruDiskCache.this.completeEdit(this, false);
                LruDiskCache.this.removeByDiskKey(this.entry.diskKey);
            } else {
                LruDiskCache.this.completeEdit(this, true);
            }
            this.committed = true;
        }

        public void abort() throws IOException {
            LruDiskCache.this.completeEdit(this, false);
        }

        public void abortUnlessCommitted() {
            if (!this.committed) {
                try {
                    this.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private class FaultHidingOutputStream
        extends FilterOutputStream {
            private FaultHidingOutputStream(OutputStream out) {
                super(out);
            }

            @Override
            public void write(int oneByte) {
                try {
                    this.out.write(oneByte);
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void write(byte[] buffer, int offset, int length) {
                try {
                    this.out.write(buffer, offset, length);
                    this.out.flush();
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (Throwable e) {
                    Editor.this.hasErrors = true;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String diskKey;
        private final long sequenceNumber;
        private final FileInputStream[] ins;
        private final long[] lengths;

        private Snapshot(String diskKey, long sequenceNumber, FileInputStream[] ins, long[] lengths) {
            this.diskKey = diskKey;
            this.sequenceNumber = sequenceNumber;
            this.ins = ins;
            this.lengths = lengths;
        }

        public Editor edit() throws IOException {
            return LruDiskCache.this.editByDiskKey(this.diskKey, this.sequenceNumber);
        }

        public FileInputStream getInputStream(int index) {
            return this.ins[index];
        }

        public String getString(int index) throws IOException {
            return LruDiskCache.inputStreamToString(this.getInputStream(index));
        }

        public long getLength(int index) {
            return this.lengths[index];
        }

        @Override
        public void close() {
            for (FileInputStream in : this.ins) {
                IOUtils.closeQuietly(in);
            }
        }
    }
}

