/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.sqlite;

import android.text.TextUtils;
import com.lidroid.xutils.db.converter.ColumnConverterFactory;
import com.lidroid.xutils.db.sqlite.ColumnDbType;
import com.lidroid.xutils.db.table.ColumnUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WhereBuilder {
    private final List<String> whereItems = new ArrayList<String>();

    private WhereBuilder() {
    }

    public static WhereBuilder b() {
        return new WhereBuilder();
    }

    public static WhereBuilder b(String columnName, String op, Object value) {
        WhereBuilder result = new WhereBuilder();
        result.appendCondition(null, columnName, op, value);
        return result;
    }

    public WhereBuilder and(String columnName, String op, Object value) {
        this.appendCondition(this.whereItems.size() == 0 ? null : "AND", columnName, op, value);
        return this;
    }

    public WhereBuilder or(String columnName, String op, Object value) {
        this.appendCondition(this.whereItems.size() == 0 ? null : "OR", columnName, op, value);
        return this;
    }

    public WhereBuilder expr(String expr) {
        this.whereItems.add(" " + expr);
        return this;
    }

    public WhereBuilder expr(String columnName, String op, Object value) {
        this.appendCondition(null, columnName, op, value);
        return this;
    }

    public int getWhereItemSize() {
        return this.whereItems.size();
    }

    public String toString() {
        if (this.whereItems.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String item : this.whereItems) {
            sb.append(item);
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendCondition(String conj, String columnName, String op, Object value) {
        StringBuilder sqlSb = new StringBuilder();
        if (this.whereItems.size() > 0) {
            sqlSb.append(" ");
        }
        if (!TextUtils.isEmpty((CharSequence)conj)) {
            sqlSb.append(conj + " ");
        }
        sqlSb.append(columnName);
        if ("!=".equals(op)) {
            op = "<>";
        } else if ("==".equals(op)) {
            op = "=";
        }
        if (value == null) {
            if ("=".equals(op)) {
                sqlSb.append(" IS NULL");
            } else if ("<>".equals(op)) {
                sqlSb.append(" IS NOT NULL");
            } else {
                sqlSb.append(" " + op + " NULL");
            }
        } else {
            sqlSb.append(" " + op + " ");
            if ("IN".equalsIgnoreCase(op)) {
                ArrayList<Object> items = null;
                if (value instanceof Iterable) {
                    items = (ArrayList<Object>)value;
                } else if (value.getClass().isArray()) {
                    void var9_16;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    int len = Array.getLength(value);
                    boolean bl = false;
                    while (var9_16 < len) {
                        arrayList.add(Array.get(value, (int)var9_16));
                        ++var9_16;
                    }
                    items = arrayList;
                }
                if (items == null) throw new IllegalArgumentException("value must be an Array or an Iterable.");
                StringBuffer stringBuffer = new StringBuffer("(");
                for (Object t : items) {
                    Object itemColValue = ColumnUtils.convert2DbColumnValueIfNeeded(t);
                    if (ColumnDbType.TEXT.equals((Object)ColumnConverterFactory.getDbColumnType(itemColValue.getClass()))) {
                        String valueStr = itemColValue.toString();
                        if (valueStr.indexOf(39) != -1) {
                            valueStr = valueStr.replace("'", "''");
                        }
                        stringBuffer.append("'" + valueStr + "'");
                    } else {
                        stringBuffer.append(itemColValue);
                    }
                    stringBuffer.append(",");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer.append(")");
                sqlSb.append(stringBuffer.toString());
            } else if ("BETWEEN".equalsIgnoreCase(op)) {
                ArrayList<Object> items = null;
                if (value instanceof Iterable) {
                    items = (ArrayList<Object>)value;
                } else if (value.getClass().isArray()) {
                    void var9_19;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    int len = Array.getLength(value);
                    boolean bl = false;
                    while (var9_19 < len) {
                        arrayList.add(Array.get(value, (int)var9_19));
                        ++var9_19;
                    }
                    items = arrayList;
                }
                if (items == null) throw new IllegalArgumentException("value must be an Array or an Iterable.");
                Iterator iterator = items.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("value must have tow items.");
                }
                Object start = iterator.next();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("value must have tow items.");
                }
                Object t = iterator.next();
                Object startColValue = ColumnUtils.convert2DbColumnValueIfNeeded(start);
                Object endColValue = ColumnUtils.convert2DbColumnValueIfNeeded(t);
                if (ColumnDbType.TEXT.equals((Object)ColumnConverterFactory.getDbColumnType(startColValue.getClass()))) {
                    String endStr;
                    String startStr = startColValue.toString();
                    if (startStr.indexOf(39) != -1) {
                        startStr = startStr.replace("'", "''");
                    }
                    if ((endStr = endColValue.toString()).indexOf(39) != -1) {
                        endStr = endStr.replace("'", "''");
                    }
                    sqlSb.append("'" + startStr + "'");
                    sqlSb.append(" AND ");
                    sqlSb.append("'" + endStr + "'");
                } else {
                    sqlSb.append(startColValue);
                    sqlSb.append(" AND ");
                    sqlSb.append(endColValue);
                }
            } else if (ColumnDbType.TEXT.equals((Object)ColumnConverterFactory.getDbColumnType((value = ColumnUtils.convert2DbColumnValueIfNeeded(value)).getClass()))) {
                String valueStr = value.toString();
                if (valueStr.indexOf(39) != -1) {
                    valueStr = valueStr.replace("'", "''");
                }
                sqlSb.append("'" + valueStr + "'");
            } else {
                sqlSb.append(value);
            }
        }
        this.whereItems.add(sqlSb.toString());
    }
}

