/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.util;

import android.text.TextUtils;
import android.util.Log;
import com.lidroid.xutils.util.OtherUtils;

public class LogUtils {
    public static String customTagPrefix = "";
    public static boolean allowD = true;
    public static boolean allowE = true;
    public static boolean allowI = true;
    public static boolean allowV = true;
    public static boolean allowW = true;
    public static boolean allowWtf = true;
    public static CustomLogger customLogger;

    private LogUtils() {
    }

    private static String generateTag(StackTraceElement caller) {
        String tag = "%s.%s(L:%d)";
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        tag = String.format(tag, callerClazzName, caller.getMethodName(), caller.getLineNumber());
        tag = TextUtils.isEmpty((CharSequence)customTagPrefix) ? tag : customTagPrefix + ":" + tag;
        return tag;
    }

    public static void d(String content) {
        if (!allowD) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.d(tag, content);
        } else {
            Log.d((String)tag, (String)content);
        }
    }

    public static void d(String content, Throwable tr) {
        if (!allowD) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.d(tag, content, tr);
        } else {
            Log.d((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void e(String content) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.e(tag, content);
        } else {
            Log.e((String)tag, (String)content);
        }
    }

    public static void e(String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.e(tag, content, tr);
        } else {
            Log.e((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void i(String content) {
        if (!allowI) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.i(tag, content);
        } else {
            Log.i((String)tag, (String)content);
        }
    }

    public static void i(String content, Throwable tr) {
        if (!allowI) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.i(tag, content, tr);
        } else {
            Log.i((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void v(String content) {
        if (!allowV) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.v(tag, content);
        } else {
            Log.v((String)tag, (String)content);
        }
    }

    public static void v(String content, Throwable tr) {
        if (!allowV) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.v(tag, content, tr);
        } else {
            Log.v((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void w(String content) {
        if (!allowW) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.w(tag, content);
        } else {
            Log.w((String)tag, (String)content);
        }
    }

    public static void w(String content, Throwable tr) {
        if (!allowW) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.w(tag, content, tr);
        } else {
            Log.w((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void w(Throwable tr) {
        if (!allowW) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.w(tag, tr);
        } else {
            Log.w((String)tag, (Throwable)tr);
        }
    }

    public static void wtf(String content) {
        if (!allowWtf) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.wtf(tag, content);
        } else {
            Log.wtf((String)tag, (String)content);
        }
    }

    public static void wtf(String content, Throwable tr) {
        if (!allowWtf) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.wtf(tag, content, tr);
        } else {
            Log.wtf((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void wtf(Throwable tr) {
        if (!allowWtf) {
            return;
        }
        StackTraceElement caller = OtherUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        if (customLogger != null) {
            customLogger.wtf(tag, tr);
        } else {
            Log.wtf((String)tag, (Throwable)tr);
        }
    }

    public static interface CustomLogger {
        public void d(String var1, String var2);

        public void d(String var1, String var2, Throwable var3);

        public void e(String var1, String var2);

        public void e(String var1, String var2, Throwable var3);

        public void i(String var1, String var2);

        public void i(String var1, String var2, Throwable var3);

        public void v(String var1, String var2);

        public void v(String var1, String var2, Throwable var3);

        public void w(String var1, String var2);

        public void w(String var1, String var2, Throwable var3);

        public void w(String var1, Throwable var2);

        public void wtf(String var1, String var2);

        public void wtf(String var1, String var2, Throwable var3);

        public void wtf(String var1, Throwable var2);
    }
}

