/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import com.lidroid.xutils.util.CharsetUtils;
import com.lidroid.xutils.util.LogUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpRequestBase;

public class OtherUtils {
    private static final int STRING_BUFFER_LENGTH = 100;
    private static SSLSocketFactory sslSocketFactory;

    private OtherUtils() {
    }

    public static String getUserAgent(Context context) {
        String id;
        String model;
        String webUserAgent = null;
        if (context != null) {
            try {
                Class<?> sysResCls = Class.forName("com.android.internal.R$string");
                Field webUserAgentField = sysResCls.getDeclaredField("web_user_agent");
                Integer resId = (Integer)webUserAgentField.get(null);
                webUserAgent = context.getString(resId.intValue());
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty(webUserAgent)) {
            webUserAgent = "Mozilla/5.0 (Linux; U; Android %s) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 %sSafari/533.1";
        }
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer();
        String version = Build.VERSION.RELEASE;
        if (version.length() > 0) {
            buffer.append(version);
        } else {
            buffer.append("1.0");
        }
        buffer.append("; ");
        String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language.toLowerCase());
            String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country.toLowerCase());
            }
        } else {
            buffer.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
            buffer.append("; ");
            buffer.append(model);
        }
        if ((id = Build.ID).length() > 0) {
            buffer.append(" Build/");
            buffer.append(id);
        }
        return String.format(webUserAgent, buffer, "Mobile ");
    }

    public static String getDiskCacheDir(Context context, String dirName) {
        File cacheDir;
        File externalCacheDir;
        String cachePath = null;
        if ("mounted".equals(Environment.getExternalStorageState()) && (externalCacheDir = context.getExternalCacheDir()) != null) {
            cachePath = externalCacheDir.getPath();
        }
        if (cachePath == null && (cacheDir = context.getCacheDir()) != null && cacheDir.exists()) {
            cachePath = cacheDir.getPath();
        }
        return cachePath + File.separator + dirName;
    }

    public static long getAvailableSpace(File dir) {
        try {
            StatFs stats = new StatFs(dir.getPath());
            return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return -1L;
        }
    }

    public static boolean isSupportRange(HttpResponse response) {
        if (response == null) {
            return false;
        }
        Header header = response.getFirstHeader("Accept-Ranges");
        if (header != null) {
            return "bytes".equals(header.getValue());
        }
        header = response.getFirstHeader("Content-Range");
        if (header != null) {
            String value = header.getValue();
            return value != null && value.startsWith("bytes");
        }
        return false;
    }

    public static String getFileNameFromHttpResponse(HttpResponse response) {
        if (response == null) {
            return null;
        }
        String result = null;
        Header header = response.getFirstHeader("Content-Disposition");
        if (header != null) {
            for (HeaderElement element : header.getElements()) {
                NameValuePair fileNamePair = element.getParameterByName("filename");
                if (fileNamePair == null) continue;
                result = fileNamePair.getValue();
                result = CharsetUtils.toCharset(result, "UTF-8", result.length());
                break;
            }
        }
        return result;
    }

    public static Charset getCharsetFromHttpRequest(HttpRequestBase request) {
        if (request == null) {
            return null;
        }
        String charsetName = null;
        Header header = request.getFirstHeader("Content-Type");
        if (header != null) {
            for (HeaderElement element : header.getElements()) {
                NameValuePair charsetPair = element.getParameterByName("charset");
                if (charsetPair == null) continue;
                charsetName = charsetPair.getValue();
                break;
            }
        }
        boolean isSupportedCharset = false;
        if (!TextUtils.isEmpty(charsetName)) {
            try {
                isSupportedCharset = Charset.isSupported(charsetName);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return isSupportedCharset ? Charset.forName(charsetName) : null;
    }

    public static long sizeOfString(String str, String charset) throws UnsupportedEncodingException {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return 0L;
        }
        int len = str.length();
        if (len < 100) {
            return str.getBytes(charset).length;
        }
        long size = 0L;
        for (int i = 0; i < len; i += 100) {
            int end = i + 100;
            end = end < len ? end : len;
            String temp = OtherUtils.getSubString(str, i, end);
            size += (long)temp.getBytes(charset).length;
        }
        return size;
    }

    public static String getSubString(String str, int start, int end) {
        return new String(str.substring(start, end));
    }

    public static StackTraceElement getCurrentStackTraceElement() {
        return Thread.currentThread().getStackTrace()[3];
    }

    public static StackTraceElement getCallerStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];
    }

    public static void trustAllHttpsURLConnection() {
        if (sslSocketFactory == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustAllCerts, null);
                sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
        if (sslSocketFactory != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
    }
}

