package com.xdja.aspectjmodule.advise;

import android.util.Log;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

/**
 * Created by xingjianqiang on 2018/5/28.
 */

@Aspect
public class AdviseCheckCryptoDev implements IAspectj {

    @Around("execution(@com.xdja.aspectjmodule.annotation.CheckCryptoDev * *(..))")
    public Object weaveJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        String className = methodSignature.getDeclaringType().getSimpleName();
        String methodName = methodSignature.getName();
        Log.d(TAG,"-------------className:"+className+"methodName:"+methodName);
        Log.d(TAG,"method start time-------------:"+ System.currentTimeMillis());
        Object result = joinPoint.proceed();
        Log.d(TAG,"method end time-------------:"+ System.currentTimeMillis());
        return result;
    }
}
