package com.xdja.aspectjmodule.advise;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;

import com.xdja.aspectjmodule.annotation.XdjaPermission;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * Created by 王浩 on 2018/4/8.
 * 针对程序里面使用的动态权限申请进行横向拦截，有助于程序的简介性
 */
@Aspect
public class AdvisePermission implements IAspectj {

    @Around("execution(@com.xdja.aspectjmodule.annotation.XdjaPermission * *(..)) && @annotation(annot)")
    public Object weavePermission(ProceedingJoinPoint joinPoint, XdjaPermission annot) throws Throwable{
        final Context context = (Context) joinPoint.getTarget();
        if(!(context instanceof Activity)){
            Log.e(TAG,"----动态权限申请，发现context不是Activity对象");return null;
        }
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            Log.i(TAG,"----动态权限申请---");
            String[] permissions = annot.permissions();
            if(!validatePermissions(context,permissions)){
                ActivityCompat.requestPermissions((Activity) context,permissions,1);
            }else {
                ((Activity) context).requestPermissions(permissions, 1);
            }
        }
        return joinPoint.proceed();
    }

    private boolean validatePermissions(Context context, String... permissions){
        for(String permission : permissions) {
            Log.i(TAG,"----validatePermissions-----permission:"+permission);
            int result = ContextCompat.checkSelfPermission(context, permission);
            if (result == PackageManager.PERMISSION_GRANTED) {
                continue;
            }else{
                Log.i(TAG, "permission " + permission +" return false");
                return false;
            }
        }
        return true;
    }

}
