package com.xdja.aspectjmodule.advise;

import android.util.Log;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

/**
 * Created by wanghao on 2017/6/14.
 * 根据自定义的log注解进行函数拦截便于跟踪日志记录或者调试开发使用
 */
@Aspect
public class AdviseXdjaLog implements IAspectj {

    private static final String POINTCUT_METHOD =
            "execution(@com.xdja.aspectjmodule.annotation.XdjaLog * *(..))";

    private static final String POINTCUT_CONSTRUCTOR =
            "execution(@com.xdja.aspectjmodule.annotation.XdjaLog *.new(..))";

    @Pointcut(POINTCUT_METHOD)
    public void methodAnnotatedWithXdjaLog() {}

    @Pointcut(POINTCUT_CONSTRUCTOR)
    public void constructorAnnotatedXdjaLog() {}

    @Around("methodAnnotatedWithXdjaLog() || constructorAnnotatedXdjaLog()")
    public Object weaveJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        String className = methodSignature.getDeclaringType().getSimpleName();
        String methodName = methodSignature.getName();
        Log.i(TAG,"-------------className:"+className+"methodName:"+methodName);
        Log.i(TAG,"method start time-------------:"+ System.currentTimeMillis());
        Object result = joinPoint.proceed();
        Log.i(TAG,"method end time-------------:"+ System.currentTimeMillis());
        return result;
    }


}
