/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.dao.BasicSyncCommonDao;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BasicSyncCommonDaoImpl
implements BasicSyncCommonDao {
    private static Logger log = LoggerFactory.getLogger(BasicSyncCommonDaoImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public int updateBySql(String sql, final Object[] args) {
        if (log.isDebugEnabled()) {
            log.debug("execute sql:\u3010{}\u3011,params:\u3010{}\u3011", (Object)sql, (Object)args);
        }
        return this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement preparedStatement) throws SQLException {
                if (args != null && args.length > 0) {
                    for (int i = 1; i <= args.length; ++i) {
                        preparedStatement.setObject(i, args[i - 1]);
                    }
                }
            }
        });
    }

    @Override
    public boolean batchUpdateBySql(String sql, List<Object[]> batchArgs) {
        if (log.isDebugEnabled()) {
            log.debug("execute update sql:\u3010{}\u3011,params:\u3010{}\u3011", (Object)sql, (Object)this.formatPrintBatchArgs(batchArgs));
        }
        this.jdbcTemplate.batchUpdate(sql, batchArgs);
        return true;
    }

    @Override
    public Object selectOne(String sql, Object[] args, Class<?> requiredClassType) {
        List<?> list = this.selectList(sql, args, requiredClassType);
        return null != list && list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public List<?> selectList(String sql, Object[] args, Class<?> requiredClassType) {
        List list = null;
        Object rowMapper = null;
        rowMapper = Map.class.isAssignableFrom(requiredClassType) ? new ColumnMapRowMapper() : (String.class.equals(requiredClassType) || Integer.class.equals(requiredClassType) || Integer.TYPE.equals(requiredClassType) || Long.class.equals(requiredClassType) || Long.TYPE.equals(requiredClassType) || Double.class.equals(requiredClassType) || Double.TYPE.equals(requiredClassType) || Float.class.equals(requiredClassType) || Float.TYPE.equals(requiredClassType) || Byte.class.equals(requiredClassType) || Byte.TYPE.equals(requiredClassType) || Short.class.equals(requiredClassType) || Short.TYPE.equals(requiredClassType) || Number.class.equals(requiredClassType) ? new SingleColumnRowMapper(requiredClassType) : new BeanPropertyRowMapper(requiredClassType));
        if (args == null) {
            args = new Object[]{};
        }
        if (log.isDebugEnabled()) {
            log.debug("execute select sql:\u3010{}\u3011,params:\u3010{}\u3011,page:\u3010{}\u3011", (Object)sql, (Object)args);
        }
        list = this.jdbcTemplate.query(sql, (RowMapper)rowMapper, args);
        return list;
    }

    private String formatPrintBatchArgs(List<Object[]> batchArgs) {
        if (null == batchArgs || batchArgs.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < batchArgs.size(); ++i) {
            Object[] objects = batchArgs.get(i);
            if (null == objects || objects.length < 1) continue;
            buffer.append("[");
            for (int j = 0; j < objects.length; ++j) {
                buffer.append(objects[j]);
                if (j == objects.length - 1) continue;
                buffer.append(",");
            }
            buffer.append("]");
            if (i == batchArgs.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

