/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.HttpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AppSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    private volatile boolean syncRunning = false;
    private int pageSize = 200;
    String insertAppSql = "INSERT INTO t_sync_app (id, app_id, app_name, app_package, app_description, app_type, app_version, app_status, network_area_code, app_file_size, create_time, version_code, app_url, regionalism_Code, update_time, power_type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    String updateAppSql = "UPDATE t_sync_app SET app_name=?, app_package=?, app_description=?, app_type=?, app_version=?, app_status=?, network_area_code=?, app_file_size=?, create_time=?, version_code=?, app_url=?, update_time=?, power_type=?  where app_id = ?  and regionalism_Code = ? ";

    @Override
    String getPoolName() {
        return "app";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncApp();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            }
        }, 2L, 600L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncApp() {
        AppSyncHandler appSyncHandler = this;
        synchronized (appSyncHandler) {
            if (this.syncRunning) {
                logger.error("\u5e94\u7528\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncRunning = true;
        }
        int syncAppTotal = 0;
        try {
            String sql = "SELECT code FROM t_sync_regionalism WHERE status = 1";
            List<?> listRegionalismCode = this.basicSyncCommonDao.selectList(sql, null, String.class);
            if (CollectionUtils.isEmpty(listRegionalismCode)) {
                logger.error("\u5168\u56fd\u884c\u653f\u533a\u5212\u7f16\u7801\u4e3a\u7a7a(t_sync_regionalisms),\u5e94\u7528\u4fe1\u606f\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            block13: for (String regionalismCode : listRegionalismCode) {
                Long lastUpdateTime;
                block23: {
                    sql = "SELECT MAX(update_time) from t_sync_app where regionalism_Code = ?";
                    lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{regionalismCode}, Long.class);
                    lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
                    if (!CollectionUtils.isEmpty(listRegionalismCode)) break block23;
                    logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212regionalismCode:[{}],lastUpdateTime:[{}]>>>", (Object)regionalismCode, (Object)lastUpdateTime);
                    int n = syncAppTotal;
                    return n;
                }
                try {
                    HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
                    int pageNo = 1;
                    mapReqParam.put("pageNo", pageNo);
                    mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
                    mapReqParam.put("updateTime", lastUpdateTime);
                    mapReqParam.put("fromRegionalismCode", localRegionalismCode);
                    mapReqParam.put("appRegionalismCode", regionalismCode);
                    while (true) {
                        mapReqParam.put("pageNo", pageNo);
                        JSONArray appList = this.queryOffsiteAppList(regionalismCode, localNetworkCode, mapReqParam);
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801regionalismCode:\u3010{}\u3011\u62c9\u53d6\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{regionalismCode, pageNo, appList.toJSONString()});
                        }
                        for (int i = 0; i < appList.size(); ++i) {
                            JSONObject jsonObject = appList.getJSONObject(i);
                            String appId = jsonObject.getString("appId");
                            String networkAreaCode = jsonObject.getString("networkAreaCode");
                            String powerType = jsonObject.getString("powerType");
                            String appRegionalismCode = jsonObject.getString("appRegionalismCode");
                            String appName = jsonObject.getString("appName");
                            String appVersion = jsonObject.getString("appVersion");
                            int versionCode = jsonObject.getIntValue("versionCode");
                            String appLogoUrl = jsonObject.getString("appLogoUrl");
                            String appDescription = jsonObject.getString("appDescription");
                            String appType = jsonObject.getString("appType");
                            String appUrl = jsonObject.getString("appUrl");
                            String appPackage = jsonObject.getString("appPackage");
                            int appFileSize = jsonObject.getIntValue("appFileSize");
                            String appFileMD5 = jsonObject.getString("appFileMD5");
                            String updateNote = jsonObject.getString("updateNote");
                            JSONArray appPictures = jsonObject.getJSONArray("appPictures");
                            String appVideoUrl = jsonObject.getString("appVideoUrl");
                            String appVideoImage = jsonObject.getString("appVideoImage");
                            long createTime = jsonObject.getLongValue("createTime");
                            long updateTime = jsonObject.getLongValue("updateTime");
                            int appStatus = 1;
                            sql = "SELECT count(1) FROM t_sync_app  where app_id = ?  and regionalism_Code = ? ";
                            Long count = (long)((Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{appId, regionalismCode}, Long.class));
                            Object[] args = null;
                            String id = UUID.randomUUID().toString().replaceAll("-", "");
                            if (!Objects.isNull(count) && count > 0L) {
                                sql = this.updateAppSql;
                                args = new Object[]{appName, appPackage, appDescription, appType, appVersion, appStatus, networkAreaCode, appFileSize, createTime, versionCode, appUrl, updateTime, powerType, appId, appRegionalismCode};
                            } else {
                                sql = this.insertAppSql;
                                args = new Object[]{id, appId, appName, appPackage, appDescription, appType, appVersion, appStatus, networkAreaCode, appFileSize, createTime, versionCode, appUrl, appRegionalismCode, updateTime, powerType};
                            }
                            this.basicSyncCommonDao.updateBySql(sql, args);
                        }
                        syncAppTotal += appList.size();
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801regionalismCode:\u3010{}\u3011\u62c9\u53d6\u7b2c[{}]\u9875\u6570\u636e\u540c\u6b65\u5b8c\u6210,\u5df2\u540c\u6b65:[{}]\u6761<<<", new Object[]{regionalismCode, pageNo, syncAppTotal});
                        }
                        if (CollectionUtils.isEmpty((Collection)appList) || appList.size() < this.pageSize) {
                            if (!logger.isDebugEnabled()) continue block13;
                            logger.debug("\u672c\u6b21\u5206\u9875\u62c9\u53d6\u7684\u6570\u636e\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f");
                            continue block13;
                        }
                        ++pageNo;
                    }
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u3010{}\u3011\u5e94\u7528\u5f02\u5e38", (Object)regionalismCode, (Object)e);
                    throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
                    return syncAppTotal;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncRunning = false;
        }
    }

    private JSONArray queryOffsiteAppList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        HttpUtils.ResponseWrap responseWrap;
        String interfaceUrl = this.basicInfoSyncService.getServiceAddress(regionalismCode, localNetworkCode, InterfaceCodeEnum.IF_MAM_SVC_01);
        if (interfaceUrl == null) {
            logger.error("\u672a\u627e\u5230\u884c\u653f\u533a\u5212\u3010{}\u3011\u7684\u5e94\u7528\u7b80\u9879\u63a5\u53e3\u5730\u5740", (Object)regionalismCode);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u672a\u627e\u5230\u884c\u653f\u533a\u5212" + regionalismCode + "\u7684\u5e94\u7528\u7b80\u9879\u63a5\u53e3\u5730\u5740");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u884c\u653f\u533a\u5212\u3010{}\u3011\u7684\u5e94\u7528\u7b80\u9879\u63a5\u53e3\u5730\u5740:\u3010{}\u3011", (Object)regionalismCode, (Object)interfaceUrl);
        }
        if ((responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(Consts.MESSAGE_ID, UUID.randomUUID().toString().replaceAll("-", "")).addHeader(Consts.APP_CREDENTIAL, CredentialUtil.getSodAppCredential()).addHeader(Consts.USER_CREDENTIAL, CredentialUtil.getSodUserCredential()).addJsonBody(mapReqParam).execute()) == null) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (Object)regionalismCode);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u62c9\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801\u3010{}\u3011, \u8fd4\u56de\u5185\u5bb9\u3010{}\u3011", new Object[]{regionalismCode, responseWrap.statusCode(), responseWrap.getString()});
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), String.format("\u62c9\u53d6\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801 %s, \u8fd4\u56de\u5185\u5bb9%s", responseWrap.statusCode(), responseWrap.getString()));
        }
        String code = responseWrap.getHeaderValue(Consts.CODE);
        if (!String.valueOf(Consts.SUCCESS_CODE).equals(code)) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801\u3010{}\u3011, \u8fd4\u56de\u9519\u8bef\u6d88\u606f\u3010{}\u3011", new Object[]{regionalismCode, code, responseWrap.getHeaderValue(Consts.MESSAGE)});
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), String.format("\u62c9\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u5931\u8d25,\u8fd4\u56de\u72b6\u6001\u7801 %s, \u8fd4\u56de\u9519\u8bef\u6d88\u606f%s", code, responseWrap.getHeaderValue(Consts.MESSAGE)));
        }
        try {
            JSONObject result = (JSONObject)JSON.toJavaObject((JSON)JSON.parseObject((String)responseWrap.getString()), JSONObject.class);
            if (logger.isDebugEnabled()) {
                logger.debug("\u62c9\u53d6regionalismCode:[{}]\u5e94\u7528\u4fe1\u606f:\u3010{}\u3011", (Object)regionalismCode, (Object)result.toJSONString());
            }
            resultList = result.getJSONArray("roamAppList");
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u5e94\u7528\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)responseWrap.getString());
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u5e94\u7528\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38, \u539f\u6570\u636e\uff1a" + responseWrap.getString());
        }
        if (null == resultList) {
            return new JSONArray();
        }
        for (int i = 0; i < resultList.size(); ++i) {
            JSONObject simpleApp = resultList.getJSONObject(i);
            String appId = simpleApp.getString("appId");
            try {
                JSONObject detail = this.httpQueryAppDetail(appId, regionalismCode, localNetworkCode);
                if (Objects.isNull(detail)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("\u62c9\u53d6regionalismCode:[{}]\u5e94\u7528appId:[{}]\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a", (Object)regionalismCode, (Object)appId);
                    continue;
                }
                simpleApp.putAll((Map)detail);
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5f02\u5730regionalismCode:\u3010{}\u3011\u5e94\u7528appId:\u3010{}\u3011\u8be6\u60c5\u5931\u8d25:", new Object[]{regionalismCode, appId, e});
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u5e94\u7528\u8be6\u60c5\u9519\u8bef:" + e.getMessage());
            }
        }
        return resultList;
    }

    private JSONObject httpQueryAppDetail(String appId, String regionalismCode, String localNetworkCode) {
        JSONObject result;
        String interfaceUrl = this.basicInfoSyncService.getServiceAddress(regionalismCode, localNetworkCode, InterfaceCodeEnum.IF_MAM_SVC_02);
        if (interfaceUrl == null) {
            logger.error("\u672a\u627e\u5230\u884c\u653f\u533a\u5212" + regionalismCode + "\u7684\u5e94\u7528\u8be6\u60c5\u63a5\u53e3\u5730\u5740");
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u672a\u627e\u5230\u884c\u653f\u533a\u5212" + regionalismCode + "\u7684\u5e94\u7528\u8be6\u60c5\u63a5\u53e3\u5730\u5740");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u884c\u653f\u533a\u5212\u3010{}\u3011\u7684\u5e94\u7528\u8be6\u60c5\u63a5\u53e3\u5730\u5740:\u3010{}\u3011", (Object)regionalismCode, (Object)interfaceUrl);
        }
        HttpUtils.ResponseWrap responseWrap = null;
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("appId", appId);
        query.put("appRegionalismCode", regionalismCode);
        responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(Consts.MESSAGE_ID, UUID.randomUUID().toString().replace("-", "")).addHeader(Consts.APP_CREDENTIAL, CredentialUtil.getSodAppCredential()).addHeader(Consts.USER_CREDENTIAL, CredentialUtil.getSodUserCredential()).addJsonBody(query).execute();
        if (responseWrap == null) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a, \u8bf7\u68c0\u67e5\u5730\u5740\u3010{}\u3011\u7f51\u7edc\u662f\u5426\u7545\u901a", new Object[]{regionalismCode, appId, interfaceUrl});
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), String.format("\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a, \u8bf7\u68c0\u67e5\u5730\u5740%s\u7f51\u7edc\u662f\u5426\u7545\u901a", regionalismCode, appId, interfaceUrl));
        }
        if (200 != responseWrap.statusCode()) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801 \u3010{}\u3011, \u8fd4\u56de\u5185\u5bb9\u3010{}\u3011", new Object[]{regionalismCode, appId, responseWrap.statusCode(), responseWrap.getString()});
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), String.format("\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u5f02\u5e38,\u8fd4\u56deHTTP\u72b6\u6001\u7801 %s, \u8fd4\u56de\u5185\u5bb9%s", regionalismCode, appId, responseWrap.statusCode(), responseWrap.getString()));
        }
        String code = responseWrap.getHeaderValue(Consts.CODE);
        if (!String.valueOf(Consts.SUCCESS_CODE).equals(code)) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u4e1a\u52a1\u5931\u8d25,\u8fd4\u56de\u4e1a\u52a1\u72b6\u6001\u7801 \u3010{}\u3011, \u8fd4\u56de\u9519\u8bef\u6d88\u606f\u3010{}\u3011", new Object[]{regionalismCode, appId, code, responseWrap.getHeaderValue(Consts.MESSAGE)});
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), String.format("\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u4e1a\u52a1\u5931\u8d25,\u8fd4\u56de\u4e1a\u52a1\u72b6\u6001\u7801 %s, \u8fd4\u56de\u9519\u8bef\u6d88\u606f%s", regionalismCode, appId, code, responseWrap.getHeaderValue(Consts.MESSAGE)));
        }
        try {
            result = (JSONObject)JSON.toJavaObject((JSON)JSON.parseObject((String)responseWrap.getString()), JSONObject.class);
            if (logger.isDebugEnabled()) {
                logger.debug("\u62c9\u53d6regionalismCode:[{}]\u5e94\u7528appId:[{}]\u8be6\u7ec6\u4fe1\u606f:\u3010{}\u3011", new Object[]{regionalismCode, appId, result.toJSONString()});
            }
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u6f2b\u6e38\u5e94\u7528\u3010{}\u3011\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a\u3010{}\u3011", new Object[]{regionalismCode, appId, responseWrap.getString()});
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), String.format("\u63a5\u6536\u62c9\u53d6\u5f02\u5730%s\u6f2b\u6e38\u5e94\u7528%s\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a%s", regionalismCode, appId, responseWrap.getString()));
        }
        return result;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

