/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.RestfulQuery;
import com.xdja.sync.bean.common.RestfulResult;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.util.HttpUtils;
import com.xdja.sync.util.RegionalismUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CcmSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(CcmSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    private volatile boolean syncRegionalismRunning = false;
    private volatile boolean syncBusinessTypeRunning = false;
    private volatile boolean syncServiceAndInterfaceInfoRunning = false;
    String SYNC_REGIONALISM = TableEnum.TABLE_REGISIONALISM.getUri();
    String SYNC_SERVICE_INTERFACE = TableEnum.TABLE_SERVICE.getUri();
    String SYNC_SERVICE_TYPE = TableEnum.TABLE_BUSINESS_TYPE.getUri();
    private static String insertServiceInterfaceSql = "INSERT INTO t_sync_service_interface (interface_id, interface_code, interface_name, interface_url, network_area_code, regionalism_code, version, version_note, status, create_time, update_time, service_id, service_name, public_key, service_type) VALUES  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updateServiceInterfaceSql = "UPDATE t_sync_service_interface SET interface_code = ?, interface_name = ?, interface_url = ?, network_area_code = ?, regionalism_code = ?, version = ?, version_note = ?, status = ?, create_time = ?, update_time = ?, service_id = ?, service_name = ?, public_key = ?, service_type = ? WHERE interface_id = ?";
    private static String insertBussinessTypeSql = "INSERT INTO t_sync_business_type (code, name, status, create_time, update_time) VALUES  (?, ?, ?, ?, ?)";
    private static String updateBussinessTypeSql = "UPDATE t_sync_business_type SET name = ?, status = ?, create_time = ?, update_time = ? WHERE  code = ?";
    private static String insertRegialismSql = "INSERT INTO t_sync_regionalism (code, name, parent_code, short_name, status, create_time, update_time) VALUES  (?, ?, ?, ?, ?, ?, ?)";

    @Override
    String getPoolName() {
        return "ccm";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    String tableName = tableEnum.getTableName();
                    String uri = tableEnum.getUri();
                    if (this.SYNC_REGIONALISM.equals(uri)) {
                        try {
                            this.syncRegionalism();
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    if (this.SYNC_SERVICE_TYPE.equals(uri)) {
                        try {
                            this.syncBusinessType();
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    if (!this.SYNC_SERVICE_INTERFACE.equals(uri)) continue;
                    try {
                        this.syncServiceAndInterfaceInfo();
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u63a5\u53e3\u670d\u52a1\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65ccm\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            }
        }, 2L, 600L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized int syncRegionalism() {
        CcmSyncHandler ccmSyncHandler = this;
        synchronized (ccmSyncHandler) {
            if (this.syncRegionalismRunning) {
                logger.error("\u884c\u653f\u533a\u5212\u7f16\u7801\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new RuntimeException("\u884c\u653f\u533a\u5212\u7f16\u7801\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncRegionalismRunning = true;
        }
        try {
            JSONArray listRegionalismBean;
            if (logger.isDebugEnabled()) {
                logger.debug("===========================\u5f00\u59cb\u540c\u6b65\u4e92\u901a\u4e2d\u5fc3\u884c\u653f\u533a\u5212\u5217\u8868===========================");
            }
            if (null != (listRegionalismBean = this.pullRegionalism()) && !listRegionalismBean.isEmpty()) {
                try {
                    String sql = "DELETE FROM t_sync_regionalism";
                    this.basicSyncCommonDao.updateBySql(sql, null);
                    Object[] args = null;
                    for (int i = 0; i < listRegionalismBean.size(); ++i) {
                        JSONObject jsonObject = listRegionalismBean.getJSONObject(i);
                        String code = jsonObject.getString("regionCode");
                        String name = jsonObject.getString("name");
                        String parentCode = jsonObject.getString("parentRegionCode");
                        String shortName = "";
                        shortName = parentCode == null ? RegionalismUtils.getShortNameByRegionalismCode(jsonObject.getString("regionCode")) : RegionalismUtils.getShortNameByRegionalismCode(parentCode);
                        Integer status = jsonObject.getInteger("status");
                        Long createTime = jsonObject.getLong("createTime");
                        Long updateTime = jsonObject.getLong("updateTime");
                        args = new Object[]{code, name, parentCode, shortName, status, createTime, updateTime};
                        try {
                            this.basicSyncCommonDao.updateBySql(insertRegialismSql, args);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error("\u4fdd\u5b58\u884c\u653f\u533a\u5212\u7f16\u7801\u5931\u8d25:", (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.error("\u4fdd\u5b58\u4e92\u901a\u4e2d\u5fc3\u884c\u653f\u533a\u5212\u5217\u8868\u5f02\u5e38" + throwable.getMessage(), throwable);
                    throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u4fdd\u5b58\u4e92\u901a\u4e2d\u5fc3\u884c\u653f\u533a\u5212\u5217\u8868\u5f02\u5e38" + throwable.getMessage());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("===========================\u540c\u6b65\u4e92\u901a\u4e2d\u5fc3\u884c\u653f\u533a\u5212\u5217\u8868\u7ed3\u675f===========================");
            }
            int n = listRegionalismBean.size();
            return n;
        }
        catch (Exception e) {
            logger.error("\u884c\u653f\u533a\u5212\u7f16\u7801\u4fe1\u606f\u540c\u6b65\u5931\u8d25", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncRegionalismRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized int syncServiceAndInterfaceInfo() {
        CcmSyncHandler ccmSyncHandler = this;
        synchronized (ccmSyncHandler) {
            if (this.syncServiceAndInterfaceInfoRunning) {
                logger.error("\u670d\u52a1\u548c\u63a5\u53e3\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new RuntimeException("\u670d\u52a1\u548c\u63a5\u53e3\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncServiceAndInterfaceInfoRunning = true;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("===========================\u5f00\u59cb\u540c\u6b65\u4e92\u901a\u4e2d\u5fc3\u670d\u52a1&\u63a5\u53e3\u5217\u8868===========================");
            }
            int sumCount = this.pullAndSaveServiceAndInterfaceInfo();
            if (logger.isDebugEnabled()) {
                logger.debug("===========================\u540c\u6b65\u4e92\u901a\u4e2d\u5fc3\u670d\u52a1&\u63a5\u53e3\u5217\u8868\u7ed3\u675f===========================");
            }
            int n = sumCount;
            return n;
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u548c\u63a5\u53e3\u4fe1\u606f\u540c\u6b65\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncServiceAndInterfaceInfoRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized int syncBusinessType() {
        CcmSyncHandler ccmSyncHandler = this;
        synchronized (ccmSyncHandler) {
            if (this.syncBusinessTypeRunning) {
                logger.error("\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new RuntimeException("\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncBusinessTypeRunning = true;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("===========================\u5f00\u59cb\u540c\u6b65\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u7c7b\u578b===========================");
            }
            JSONArray result = this.pullBusinessType();
            try {
                for (int i = 0; i < result.size(); ++i) {
                    JSONObject jsonObject = result.getJSONObject(i);
                    String code = jsonObject.getString("code");
                    String name = jsonObject.getString("name");
                    int status = jsonObject.getIntValue("status");
                    long createTime = jsonObject.getLongValue("createTime");
                    long updateTime = jsonObject.getLongValue("updateTime");
                    String sql = "SELECT count(1) FROM t_sync_business_type WHERE code = ?";
                    Long count = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{code}, Long.class);
                    Object[] args = null;
                    if (!Objects.isNull(count) && count > 0L) {
                        sql = updateBussinessTypeSql;
                        args = new Object[]{name, status, createTime, updateTime, code};
                    } else {
                        sql = insertBussinessTypeSql;
                        args = new Object[]{code, name, status, createTime, updateTime};
                    }
                    this.basicSyncCommonDao.updateBySql(sql, args);
                }
            }
            catch (Throwable throwable) {
                logger.error("\u4e8b\u52a1\u4fdd\u5b58\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u7c7b\u578b" + throwable.getMessage(), throwable);
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), throwable.getMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("===========================\u540c\u6b65\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u7c7b\u578b\u7ed3\u675f===========================");
            }
            int n = result.size();
            return n;
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u540c\u6b65\u5931\u8d25");
        }
        finally {
            this.syncBusinessTypeRunning = false;
        }
        return 0;
    }

    private JSONArray pullServiceInterfaceInfo(int pageNum, int pageSize, Long lastUpdateTime, String url) {
        RestfulResult rmcResult;
        JSONArray listServiceInterface = new JSONArray();
        if (logger.isDebugEnabled()) {
            logger.debug("\u5206\u9875\u4ece\u4e92\u901a\u4e2d\u5fc3\u62c9\u53d6\u670d\u52a1\u63a5\u53e3\u4fe1\u606f\u53c2\u6570, pageNum:{}, pageSize:{}, lastUpdateTimestamp:{} url:{}", new Object[]{pageNum, pageSize, lastUpdateTime, url});
        }
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            RestfulQuery<JSONObject> query = new RestfulQuery<JSONObject>();
            JSONObject parameter = new JSONObject();
            parameter.put("pageNo", (Object)pageNum);
            parameter.put("pageSize", (Object)pageSize);
            parameter.put("lastUpdateTimestamp", (Object)lastUpdateTime);
            query.setParameter(parameter);
            responseWrap = HttpUtils.createPost(url).addJsonBody(query).execute();
            if (responseWrap == null) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u670d\u52a1\u63a5\u53e3\u4fe1\u606f\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return listServiceInterface;
            }
            if (200 != responseWrap.statusCode()) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u670d\u52a1\u63a5\u53e3\u4fe1\u606f\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
                return listServiceInterface;
            }
        }
        catch (Exception e) {
            logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u884c\u670d\u52a1\u63a5\u53e3\u4fe1\u606f\u5217\u8868\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listServiceInterface;
        }
        try {
            rmcResult = (RestfulResult)JSON.toJavaObject((JSON)JSON.parseObject((String)responseWrap.getString()), RestfulResult.class);
            if (rmcResult == null || !String.valueOf(200).equals(rmcResult.getCode())) {
                logger.error("\u63a5\u6536\u670d\u52a1\u4fe1\u606f\u5217\u8868\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u8fd4\u56de\u4ee3\u7801\u5f02\u5e38 {}", (Object)JSON.toJSONString((Object)rmcResult));
                return listServiceInterface;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f\u3010{}\u3011<<<", (Object)JSON.toJSONString((Object)rmcResult));
            }
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u7684\u670d\u52a1\u4fe1\u606f\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listServiceInterface;
        }
        if (CollectionUtils.isEmpty((Map)((JSONObject)rmcResult.getData()))) {
            return listServiceInterface;
        }
        listServiceInterface = ((JSONObject)rmcResult.getData()).getJSONArray("list");
        return listServiceInterface;
    }

    private JSONArray pullRegionalism() {
        RestfulResult rmcResult;
        JSONArray listRegionalismBean = new JSONArray();
        String url = Consts.ccmServerUrl + this.SYNC_REGIONALISM;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ece\u4e92\u901a\u4e2d\u5fc3\u62c9\u53d6\u884c\u653f\u533a\u5212\u4fe1\u606f, url:{}", (Object)url);
        }
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            RestfulQuery<JSONObject> restfulQuery = new RestfulQuery<JSONObject>();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pageNo", (Object)1);
            jsonObject.put("pageSize", (Object)10000);
            restfulQuery.setParameter(jsonObject);
            responseWrap = HttpUtils.createPost(url).addJsonBody(restfulQuery).execute();
            if (responseWrap == null) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u884c\u653f\u533a\u5212\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return listRegionalismBean;
            }
            if (200 != responseWrap.statusCode()) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u884c\u653f\u533a\u5212\u5217\u8868\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
                return listRegionalismBean;
            }
        }
        catch (Exception e) {
            logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u884c\u653f\u533a\u5212\u5217\u8868\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listRegionalismBean;
        }
        try {
            rmcResult = (RestfulResult)JSON.toJavaObject((JSON)JSON.parseObject((String)responseWrap.getString()), RestfulResult.class);
            if (rmcResult == null || !String.valueOf(200).equals(rmcResult.getCode())) {
                logger.error("\u63a5\u6536\u884c\u653f\u533a\u5212\u5217\u8868\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u8fd4\u56de\u4ee3\u7801\u5f02\u5e38 {}", (Object)rmcResult);
                return listRegionalismBean;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u62c9\u53d6\u884c\u653f\u533a\u5212:\u3010{}\u3011<<<", (Object)JSON.toJSONString((Object)rmcResult));
            }
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u7684\u884c\u653f\u533a\u5212\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listRegionalismBean;
        }
        JSONObject jsonResult = (JSONObject)rmcResult.getData();
        if (CollectionUtils.isEmpty((Map)jsonResult)) {
            return listRegionalismBean;
        }
        return jsonResult.getJSONArray("list");
    }

    private JSONArray pullBusinessType() {
        RestfulResult rmcResult;
        JSONArray listBusinessType = new JSONArray();
        String sql = "select max(update_time) from t_sync_business_type";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        String url = Consts.ccmServerUrl + this.SYNC_SERVICE_TYPE;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ece\u4e92\u901a\u4e2d\u5fc3\u589e\u91cf\u62c9\u53d6\u4e1a\u52a1\u7c7b\u578b\u53c2\u6570, lastUpdateTime:{}, url:{}", (Object)lastUpdateTime, (Object)url);
        }
        RestfulQuery query = new RestfulQuery();
        HashMap<String, Long> parameter = new HashMap<String, Long>();
        parameter.put("lastUpdateTimestamp", lastUpdateTime);
        parameter.put("pageNo", 1L);
        parameter.put("pageSize", 10000L);
        query.setParameter(parameter);
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            responseWrap = HttpUtils.createPost(url).addJsonBody(query).execute();
            if (responseWrap == null) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return listBusinessType;
            }
            if (200 != responseWrap.statusCode()) {
                logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
                return listBusinessType;
            }
        }
        catch (Exception e) {
            logger.error("\u62c9\u53d6\u4e92\u901a\u4e2d\u5fc3\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listBusinessType;
        }
        try {
            rmcResult = (RestfulResult)JSON.toJavaObject((JSON)JSON.parseObject((String)responseWrap.getString()), RestfulResult.class);
            if (rmcResult == null || !String.valueOf(200).equals(rmcResult.getCode())) {
                logger.error("\u63a5\u6536\u7684\u8d44\u6e90\u4e1a\u52a1\u7c7b\u578b\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u8fd4\u56de\u4ee3\u7801\u5f02\u5e38 {}", (Object)rmcResult);
                return listBusinessType;
            }
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u7684\u8d44\u6e90\u4e1a\u52a1\u7c7b\u578b\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listBusinessType;
        }
        ArrayList results = new ArrayList();
        JSONObject businessTypeResult = (JSONObject)rmcResult.getData();
        if (CollectionUtils.isEmpty((Map)businessTypeResult)) {
            return listBusinessType;
        }
        listBusinessType = businessTypeResult.getJSONArray("list");
        return listBusinessType;
    }

    private int pullAndSaveServiceAndInterfaceInfo() {
        JSONArray interfaceDetailList;
        String url = Consts.ccmServerUrl + this.SYNC_SERVICE_INTERFACE;
        String sql = "SELECT max(update_time) FROM t_sync_service_interface";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ececcm\u83b7\u53d6\u7ea7\u8054\u63a5\u53e3\u7684url\u4e3a:{}, \u4e0a\u6b21\u66f4\u65b0\u6700\u5927\u65f6\u95f4\u6233", (Object)url, (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(interfaceDetailList = this.pullServiceInterfaceInfo(1, Consts.SYNC_DEFAULT_PAGE_SIZE, lastUpdateTime, url)))) {
            logger.debug("\u672c\u6b21\u7ea7\u8054\u63a5\u53e3\u6ca1\u6709\u66f4\u65b0");
            return 0;
        }
        int pageNum = 1;
        int pageSize = 200;
        JSONArray listServiceInterface = new JSONArray();
        while (true) {
            logger.debug("\u5f00\u59cb\u4ececcm\u62c9\u53d6\u7b2c{}\u9875\u7ea7\u8054\u63a5\u53e3>>>", (Object)pageNum);
            interfaceDetailList = this.pullServiceInterfaceInfo(pageNum, pageSize, 0L, url);
            logger.debug("\u7ed3\u675f\u4ececcm\u62c9\u53d6\u7b2c{}\u9875\u7ea7\u8054\u63a5\u53e3:\u3010{}\u3011<<<", (Object)pageNum, (Object)interfaceDetailList.toJSONString());
            if (!CollectionUtils.isEmpty((Collection)interfaceDetailList)) {
                listServiceInterface.addAll((Collection)interfaceDetailList);
            }
            if (CollectionUtils.isEmpty((Collection)interfaceDetailList) || interfaceDetailList.size() < pageSize) break;
            ++pageNum;
        }
        logger.info("\u4ece\u7ea7\u8054\u914d\u7f6e\u4e2d\u5fc3\u62c9\u53d6\u7ea7\u8054\u63a5\u53e3\u7ed3\u675f");
        logger.debug("\u672c\u6b21\u5171\u540c\u6b65\u5230{}\u6761\u7ea7\u8054\u63a5\u53e3", (Object)listServiceInterface.size());
        try {
            this.anewServiceAndInterfaceInfo(listServiceInterface);
        }
        catch (Throwable e) {
            logger.error("\u91cd\u65b0\u751f\u6210\u6240\u6709\u7ea7\u8054\u63a5\u53e3\u548c\u670d\u52a1\u6570\u636e\u51fa\u9519,", e);
        }
        logger.debug("\u91cd\u65b0\u751f\u6210\u5b8c\u6240\u6709\u7684\u7ea7\u8054\u63a5\u53e3\u548c\u670d\u52a1\u6570\u636e");
        return listServiceInterface.size();
    }

    public void anewServiceAndInterfaceInfo(JSONArray listServiceInterface) {
        if (CollectionUtils.isEmpty((Collection)listServiceInterface)) {
            logger.info("\u672c\u6b21\u4ececcm\u4e0a\u62c9\u53d6\u5230\u7684\u7ea7\u8054\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u672c\u6b21\u4ececcm\u4e0a\u62c9\u53d6\u5230\u7684\u7ea7\u8054\u63a5\u53e3\u6570\u636e\u4e3a:\u3010{}\u3011", (Object)listServiceInterface.toJSONString());
        }
        int size = listServiceInterface.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = listServiceInterface.getJSONObject(i);
            if (logger.isDebugEnabled()) {
                logger.debug("\u66f4\u65b0\u672c\u5730\u7ea7\u8054\u63a5\u53e3\u4fe1\u606f:[{}/{}],\u6570\u636e\u4e3a:\u3010{}\u3011>>>", new Object[]{i + 1, size, jsonObject.toJSONString()});
            }
            int status = jsonObject.getInteger("status");
            String interfaceId = jsonObject.getString("interfaceId");
            String serviceId = jsonObject.getString("serviceId");
            String regionalismCode = jsonObject.getString("regionCode");
            String serviceName = jsonObject.getString("serviceName");
            String serviceType = jsonObject.getString("serviceType");
            String positionCode = jsonObject.getString("positionCode");
            String interfaceCode = jsonObject.getString("interfaceCode");
            String interfaceName = jsonObject.getString("interfaceName");
            int version = jsonObject.getIntValue("version");
            String versionNote = jsonObject.getString("versionNote");
            String url = jsonObject.getString("url");
            long createTime = jsonObject.getLongValue("createTime");
            long updateTime = jsonObject.getLongValue("updateTime");
            try {
                String sql = "SELECT COUNT(1) FROM t_sync_service_interface WHERE interface_id = ?";
                Long count = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{interfaceId}, Long.class);
                Object[] args = null;
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updateServiceInterfaceSql;
                    args = new Object[]{interfaceCode, interfaceName, url, positionCode, regionalismCode, version, versionNote, status, createTime, updateTime, serviceId, serviceName, "", "", interfaceId};
                } else {
                    sql = insertServiceInterfaceSql;
                    args = new Object[]{interfaceId, interfaceCode, interfaceName, url, positionCode, regionalismCode, version, versionNote, status, createTime, updateTime, serviceId, serviceName, "", ""};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u66f4\u65b0\u672c\u5730\u7ea7\u8054\u63a5\u53e3\u4fe1\u606f:[{}/{}],\u6570\u636e\u7ed3\u675f<<<", (Object)(i + 1), (Object)size);
                continue;
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u7ea7\u8054\u63a5\u53e3\u51fa\u9519\uff1a\u3010{}\u3011", (Object)jsonObject.toJSONString(), (Object)e);
            }
        }
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_BUSINESS_TYPE != tableEnum && TableEnum.TABLE_REGISIONALISM != tableEnum && TableEnum.TABLE_SERVICE != tableEnum && TableEnum.TABLE_SERVICE_INTERFACE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

