/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.util.HttpUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class PamsSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PamsSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    private static String insertDeptSql = "INSERT INTO t_sync_department  (ID, AMOUNT, CODE, CONTACT, DEP_ABB, DEP_TYPE, DIRECT, DISPLAY_STATE, FLAG, GRADE, N_LAST_UPDATE_TIME, NAME, NOTE, ORDER_FIELD, PARENT_ID, PHONE, TREE_CODE, TREE_ID, parent_code)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updateDeptSql = "UPDATE t_sync_department SET AMOUNT=?, CODE=?, CONTACT=?, DEP_ABB=?, DEP_TYPE=?, DIRECT=?, DISPLAY_STATE=?, FLAG=?, GRADE=?, N_LAST_UPDATE_TIME=?, NAME=?, NOTE=?, ORDER_FIELD=?, PARENT_ID=?, PHONE=?, TREE_CODE=?, TREE_ID=?, parent_code=? WHERE ID=?";
    private static String insertPersonSql = "INSERT INTO t_sync_person (id, name, name_brief_spell, sex, code, identifier, dep_id, dep_code, position, position_input, office_phone, note, police, smobile, order_Field, flag, n_last_update_time, password)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updatePersonSql = "UPDATE t_sync_person SET name=?, name_brief_spell=?, sex=?, code=?, identifier=?, dep_id=?, dep_code=?, position=?, position_input=?, office_phone=?, note=?, police=?, smobile=?, order_Field=?, flag=?, n_last_update_time=? password=? WHERE id=?";
    private int pageSize = 200;
    private String dept_uri = TableEnum.TABLE_DEPARTMENT.getUri();
    private String person_uri = TableEnum.TABLE_PERSON.getUri();
    private volatile boolean syncDeptRunning = false;
    private volatile boolean syncPersonRunning = false;

    @Override
    String getPoolName() {
        return "pams";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    String uri = tableEnum.getUri();
                    String tableName = tableEnum.getTableName();
                    if (this.dept_uri.equals(uri)) {
                        try {
                            this.syncDept();
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    if (!this.person_uri.equals(uri)) continue;
                    try {
                        this.syncPerson();
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                }
                this.updatePersonTreeIdCode();
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65pams\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            }
        }, 2L, 600L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncDept() {
        PamsSyncHandler pamsSyncHandler = this;
        synchronized (pamsSyncHandler) {
            if (this.syncDeptRunning) {
                logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncDeptRunning = true;
        }
        try {
            int n = this.updateDept(this.pullAllDept());
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncDeptRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncPerson() {
        PamsSyncHandler pamsSyncHandler = this;
        synchronized (pamsSyncHandler) {
            if (this.syncPersonRunning) {
                logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncPersonRunning = true;
        }
        try {
            int n = this.updatePerson(this.pullAllPerson());
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncPersonRunning = false;
        }
    }

    private JSONArray pullAllPerson() {
        JSONArray listPerson;
        String url = Consts.pamsServerUrl + this.person_uri;
        String sql = "SELECT MAX(n_last_update_time) FROM t_sync_person";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65pams\u4eba\u5458\u63a5\u53e3\u7684url\u4e3a:{}, \u4e0a\u6b21\u66f4\u65b0\u6700\u5927\u65f6\u95f4\u6233", (Object)url, (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(listPerson = this.pullPamsData(lastUpdateTime, 1, this.pageSize, url)))) {
            logger.debug("\u672c\u6b21\u4eba\u5458\u6ca1\u6709\u66f4\u65b0,\u4e0a\u6b21\u66f4\u65b0\u6700\u5927\u65f6\u95f4\u6233:{}", (Object)lastUpdateTime);
            return new JSONArray();
        }
        int pageNum = 1;
        int pageSize = 200;
        JSONArray listPersonResult = new JSONArray();
        while (true) {
            logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u4eba\u5458>>>", (Object)pageNum);
            listPerson = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            if (logger.isDebugEnabled()) {
                logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u4eba\u5458:\u3010{}\u3011<<<", (Object)pageNum, (Object)listPersonResult.toJSONString());
            }
            if (!CollectionUtils.isEmpty((Collection)listPerson)) {
                listPersonResult.addAll((Collection)listPerson);
            }
            if (CollectionUtils.isEmpty((Collection)listPerson) || listPerson.size() < pageSize) break;
            ++pageNum;
        }
        logger.debug("\u4ecepams\u62c9\u53d6\u4eba\u5458\u4fe1\u606f\u5b8c\u6210");
        logger.debug("\u672c\u6b21\u5171\u540c\u6b65\u5230{}\u6761\u4eba\u5458", (Object)listPersonResult.size());
        return listPersonResult;
    }

    private int updatePerson(JSONArray listPersonResult) {
        try {
            String selectOneSql = "SELECT count(1) FROM t_sync_person WHERE id = ?";
            int size = listPersonResult.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = listPersonResult.getJSONObject(i);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u6570\u636e\u5165\u5e93:[{}/{}],\u6570\u636e:\u3010{}\u3011>>>", new Object[]{i + 1, size, jsonObject.toJSONString()});
                }
                String id = jsonObject.getString("id");
                String name = jsonObject.getString("name");
                String nameBriefSpell = jsonObject.getString("name_brief_spell");
                String code = jsonObject.getString("code");
                String depCode = jsonObject.getString("dep_code");
                String depId = jsonObject.getString("dep_id");
                String sex = jsonObject.getString("sex");
                String personType = jsonObject.getString("personType");
                String orderField = jsonObject.getString("seq");
                String police = jsonObject.getString("police");
                String grade = jsonObject.getString("grade");
                String position = jsonObject.getString("position");
                String commType = jsonObject.getString("comm_type");
                String identifier = jsonObject.getString("identifier");
                String mobile = jsonObject.getString("mobile");
                String leaderLevel = jsonObject.getString("leaderLevel");
                String displayFlag = jsonObject.getString("display_flag");
                String flag = jsonObject.getString("delete_flag");
                String lastUpdateTime1 = jsonObject.getString("n_last_update_time");
                String job = jsonObject.getString("job");
                String note = jsonObject.getString("note");
                String officePhone = jsonObject.getString("officePhone");
                String mobilePersonal = jsonObject.getString("mobilePersonal");
                String mobileMultimediaMessage = jsonObject.getString("mobileMultimediaMessage");
                String jxFlag = jsonObject.getString("jxFlag");
                String password = jsonObject.getString("password");
                Long count = (Long)this.basicSyncCommonDao.selectOne(selectOneSql, new Object[]{id}, Long.class);
                Object[] args = null;
                String sql = "";
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updatePersonSql;
                    args = new Object[]{name, nameBriefSpell, sex, code, identifier, depId, depCode, position, position, officePhone, note, police, mobile, orderField, flag, lastUpdateTime1, password, id};
                } else {
                    sql = insertPersonSql;
                    args = new Object[]{id, name, nameBriefSpell, sex, code, identifier, depId, depCode, position, position, officePhone, note, police, mobile, orderField, flag, lastUpdateTime1, password};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u4eba\u5458\u6570\u636e\u5165\u5e93:[{}/{}],<<<", (Object)(i + 1), (Object)size);
            }
        }
        catch (Throwable e) {
            logger.error("\u4ecepams\u540c\u6b65\u4eba\u5458\u6570\u636e\u51fa\u9519,", e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return listPersonResult.size();
    }

    private JSONArray pullAllDept() {
        JSONArray listDept;
        String url = Consts.pamsServerUrl + this.dept_uri;
        String sql = "SELECT MAX(n_last_update_time) FROM t_sync_department";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65pams\u5355\u4f4d\u63a5\u53e3\u7684url\u4e3a:{}, \u4e0a\u6b21\u66f4\u65b0\u6700\u5927\u65f6\u95f4\u6233:{}", (Object)url, (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(listDept = this.pullPamsData(lastUpdateTime, 1, this.pageSize, url)))) {
            logger.debug("\u672c\u6b21\u5355\u4f4d\u6ca1\u6709\u66f4\u65b0,\u4e0a\u6b21\u66f4\u65b0\u6700\u5927\u65f6\u95f4\u6233:{}", (Object)lastUpdateTime);
            return new JSONArray();
        }
        int pageNum = 1;
        int pageSize = 200;
        JSONArray listDeptResult = new JSONArray();
        while (true) {
            logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u5355\u4f4d>>>", (Object)pageNum);
            listDept = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            logger.debug("\u4ecepams\u62c9\u53d6\u7b2c{}\u9875\u5355\u4f4d:\u3010{}\u3011<<<", (Object)pageNum, (Object)listDept);
            if (!CollectionUtils.isEmpty((Collection)listDept)) {
                listDeptResult.addAll((Collection)listDept);
            }
            if (CollectionUtils.isEmpty((Collection)listDept) || listDept.size() < pageSize) break;
            ++pageNum;
        }
        logger.debug("\u4ecepams\u62c9\u53d6\u5355\u4f4d\u4fe1\u606f\u5b8c\u6210");
        logger.debug("\u672c\u6b21\u5171\u540c\u6b65\u5230{}\u6761\u5355\u4f4d", (Object)listDeptResult.size());
        return listDeptResult;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int updateDept(JSONArray listDeptResult) {
        try {
            String selectOneSql = "SELECT count(1) FROM t_sync_department WHERE id = ?";
            int size = listDeptResult.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = listDeptResult.getJSONObject(i);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5165\u5e93:[{}/{}],\u6570\u636e:\u3010{}\u3011>>>", new Object[]{i + 1, size, jsonObject.toJSONString()});
                }
                String id = jsonObject.getString("id");
                String parentId = jsonObject.getString("parent_id");
                String name = jsonObject.getString("name");
                String code = jsonObject.getString("code");
                String parentCode = jsonObject.getString("parent_code");
                String depAbb = jsonObject.getString("dep_abb");
                String grade = jsonObject.getString("grade");
                String orderField = jsonObject.getString("seq");
                String displayFlag = jsonObject.getString("display_flag");
                String flag = jsonObject.getString("delete_flag");
                String lastUpdateTime1 = jsonObject.getString("n_last_update_time");
                String phone = jsonObject.getString("phone");
                String treeId = jsonObject.getString("treeId");
                String treeCode = jsonObject.getString("treeCode");
                String amount = jsonObject.getString("amount");
                Long count = (Long)this.basicSyncCommonDao.selectOne(selectOneSql, new Object[]{id}, Long.class);
                Object[] args = null;
                String sql = "";
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updateDeptSql;
                    args = new Object[]{amount, code, phone, depAbb, "org", "0", displayFlag, flag, grade, lastUpdateTime1, name, "", orderField, parentId, phone, treeCode, treeId, parentCode, id};
                } else {
                    sql = insertDeptSql;
                    args = new Object[]{id, amount, code, phone, depAbb, "org", "0", displayFlag, flag, grade, lastUpdateTime1, name, "", orderField, parentId, phone, treeCode, treeId, parentCode};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5165\u5e93:[{}/{}]<<<", (Object)(i + 1), (Object)size);
            }
        }
        catch (Throwable e) {
            logger.error("\u4ecepams\u540c\u6b65\u5355\u4f4d\u6570\u636e\u51fa\u9519", e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return listDeptResult.size();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updatePersonTreeIdCode() {
        String sql = "UPDATE t_sync_person p, t_sync_department d set p.tree_id = d.tree_id, p.tree_code = d.tree_code WHERE p.dep_id = d.id";
        this.basicSyncCommonDao.updateBySql(sql, null);
    }

    public JSONArray pullPamsData(Long dataMaxVersion, int pageNo, int pageSize, String url) {
        JSONArray listPamsData = new JSONArray();
        HashMap<String, String> requestParam = new HashMap<String, String>(4);
        requestParam.put("thirdId", Consts.systemName);
        requestParam.put("lastTime", dataMaxVersion == null ? "0" : String.valueOf(dataMaxVersion));
        requestParam.put("pageNo", pageNo + "");
        requestParam.put("pageSize", pageSize + "");
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            responseWrap = HttpUtils.createForm(url).addParameters(requestParam).execute();
            if (responseWrap == null) {
                logger.error("\u62c9\u53d6pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u62c9\u53d6pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            if (200 != responseWrap.statusCode()) {
                logger.error("\u62c9\u53d6pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u62c9\u53d6pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
            }
        }
        catch (Exception e) {
            logger.error("\u62c9\u53d6pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        try {
            String json = responseWrap.getString();
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            String flag = jsonObject.getJSONObject("result").getString("flag");
            if (!"0".equals(flag)) {
                logger.error("\u62c9\u53d6pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fe1\u606f\u5931\u8d25flag:{}", (Object)flag);
                return listPamsData;
            }
            listPamsData = jsonObject.getJSONArray("list");
        }
        catch (Exception e) {
            logger.error("\u62c9\u53d6pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return listPamsData;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        List<TableEnum> listTableEnum = Arrays.asList(tableEnums).stream().filter(tableEnum -> TableEnum.TABLE_PERSON == tableEnum || TableEnum.TABLE_DEPARTMENT == tableEnum).collect(Collectors.toList());
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

