/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

import com.xdja.sync.util.KeyUtils;
import com.xdja.sync.util.SM2EngineExtend;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.util.Arrays;
import java.util.Base64;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class BcSm2Util {
    public static String encrypt(String publicKey, String data) {
        return BcSm2Util.encrypt(publicKey, data, SM2EngineExtend.CIPHERMODE_NORM);
    }

    public static String encrypt(String publicKey, String data, int cipherModel) {
        X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
        ECPoint publicKeyPoint = x9ECParameters.getCurve().decodePoint(Hex.decode((String)publicKey));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(publicKeyPoint, domainParameters);
        SM2EngineExtend sm2EngineExtend = new SM2EngineExtend();
        sm2EngineExtend.init(true, cipherModel, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            byte[] in = data.getBytes();
            arrayOfBytes = sm2EngineExtend.processBlock(in, 0, in.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Hex.toHexString(arrayOfBytes);
    }

    public static String decrypt(String privateKey, String cipherData) {
        return BcSm2Util.decrypt(privateKey, cipherData, SM2EngineExtend.CIPHERMODE_NORM);
    }

    public static String decrypt(String privateKey, String cipherData, int cipherMode) {
        byte[] cipherDataByte = Hex.decode((String)cipherData);
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        BigInteger privateKeyD = new BigInteger(privateKey, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2EngineExtend sm2EngineExtend = new SM2EngineExtend();
        sm2EngineExtend.init(false, cipherMode, (CipherParameters)privateKeyParameters);
        String result = "";
        try {
            SM2Engine sm2Engine = new SM2Engine();
            sm2Engine.init(false, (CipherParameters)privateKeyParameters);
            byte[] bytes = Base64.getDecoder().decode(sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length));
            System.out.println(new String(bytes));
            byte[] arrayOfBytes = sm2EngineExtend.processBlock(cipherDataByte, 0, cipherDataByte.length);
            return new String(arrayOfBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public static byte[] encrypt(byte[] data, PublicKey publicKey) {
        ECPublicKeyParameters localECPublicKeyParameters = null;
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey localECPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec localECParameterSpec = localECPublicKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            localECPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), localECDomainParameters);
        }
        SM2EngineExtend localSM2Engine = new SM2EngineExtend();
        localSM2Engine.init(true, (CipherParameters)new ParametersWithRandom(localECPublicKeyParameters, new SecureRandom()));
        try {
            byte[] arrayOfByte2 = localSM2Engine.processBlock(data, 0, data.length);
            return arrayOfByte2;
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] encodedata, PrivateKey privateKey) {
        SM2Engine localSM2Engine = new SM2Engine();
        BCECPrivateKey sm2PriK = (BCECPrivateKey)privateKey;
        ECParameterSpec localECParameterSpec = sm2PriK.getParameters();
        ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
        ECPrivateKeyParameters localECPrivateKeyParameters = new ECPrivateKeyParameters(sm2PriK.getD(), localECDomainParameters);
        localSM2Engine.init(false, (CipherParameters)localECPrivateKeyParameters);
        try {
            byte[] arrayOfByte3 = localSM2Engine.processBlock(encodedata, 0, encodedata.length);
            return arrayOfByte3;
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] signByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        Signature sig = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "BC");
        sig.initSign(privateKey);
        sig.update(data);
        byte[] ret = sig.sign();
        return ret;
    }

    public static boolean verifyByPublicKey(byte[] data, PublicKey publicKey, byte[] signature) throws Exception {
        Signature sig = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "BC");
        sig.initVerify(publicKey);
        sig.update(data);
        boolean ret = sig.verify(signature);
        return ret;
    }

    public static void main(String[] args) {
        try {
            String[] keys = KeyUtils.generateSmKey();
            PublicKey publicKey = KeyUtils.createPublicKey(keys[0]);
            Object[] strings = KeyUtils.generateSmKey(false);
            System.out.println(Arrays.toString(strings));
            String text = "hello";
            byte[] encrypt = BcSm2Util.encrypt(text.getBytes(StandardCharsets.UTF_8), publicKey);
            String s = Base64.getEncoder().encodeToString(encrypt);
            System.out.println(s);
            String pu = "0481d4e0e28873d76d8fee024ca482d5ceffac033d380c5b2495211a7938359a96bfe0e924220e413a5f78ac527cd66bce8d519d518f6b8c85303f293e6b16424a";
            String pri = "6805fec921b06b7c2a410136c8d539aa2fc7d78baf393c9344cf55f658ddd9";
            String encrypt1 = BcSm2Util.encrypt(pu, text);
            String decrypt = BcSm2Util.decrypt(encrypt1, pri);
            System.out.println(encrypt1);
            System.out.println(decrypt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

