/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.TableColumn;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.AppSyncHandler;
import com.xdja.sync.handler.CcmSyncHandler;
import com.xdja.sync.handler.PamsSyncHandler;
import com.xdja.sync.handler.ResourceSyncHandler;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ExecuteScheduleSyncHandler
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteScheduleSyncHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    private CcmSyncHandler ccmSyncHandler;
    @Autowired
    private PamsSyncHandler pamsSyncHandler;
    @Autowired
    private AppSyncHandler appSyncHandler;
    @Autowired
    private ResourceSyncHandler resourceSyncHandler;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private Map<String, AbstractSyncHandler> syncHandlers;

    public void run(TableEnum ... tableEnums) {
        tableEnums = null == tableEnums ? TableEnum.values() : tableEnums;
        this.checkRequiredTableSchema(tableEnums);
        TableEnum[] finalTableEnums = tableEnums;
        this.syncHandlers.values().forEach(iSyncHandler -> iSyncHandler.doHandler(finalTableEnums));
    }

    private void checkRequiredTableSchema(TableEnum[] tableEnums) {
        try {
            HashMap<String, String> mapDbAllTableName = new HashMap<String, String>();
            Connection connection = this.basicSyncCommonDao.getJdbcTemplate().getDataSource().getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet rs = metaData.getTables(connection.getCatalog(), null, null, null);
            while (rs.next()) {
                String table_name = rs.getString("TABLE_NAME");
                mapDbAllTableName.put(table_name.toLowerCase(), table_name.toLowerCase());
            }
            HashMap<String, List<TableColumn>> mapTableColumn = new HashMap<String, List<TableColumn>>();
            for (TableEnum tableEnum : tableEnums) {
                String tableName = tableEnum.getTableName();
                if (mapDbAllTableName.containsKey(tableName)) {
                    List<TableColumn> listTableColumn = this.getTableTableColumn(connection, tableName);
                    mapTableColumn.put(tableName, listTableColumn);
                    continue;
                }
                if (!((null != Consts.pamsServerUrl && !"".equals(Consts.pamsServerUrl) || !TableEnum.TABLE_PERSON.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_DEPARTMENT.getTableName().equalsIgnoreCase(tableName)) && (null != Consts.ccmServerUrl && !"".equals(Consts.ccmServerUrl) || !TableEnum.TABLE_REGISIONALISM.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_BUSINESS_TYPE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE_INTERFACE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_RESOURCE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_APP.getTableName().equalsIgnoreCase(tableName)))) continue;
                InputStream inputStream = ExecuteScheduleSyncHandler.class.getClassLoader().getResourceAsStream(tableName + ".sql");
                String sql = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
                this.basicSyncCommonDao.updateBySql(sql, null);
            }
            for (Map.Entry entry : mapTableColumn.entrySet()) {
                String tableName = (String)entry.getKey();
                List list = (List)entry.getValue();
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u8868\u7ed3\u6784\u5931\u8d25", (Throwable)e);
        }
    }

    public void assembleSql(String sql) {
        MySqlStatementParser sqlStatementParser = new MySqlStatementParser(sql);
    }

    public List<TableColumn> getTableTableColumn(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet rs = metaData.getColumns(null, "%", tableName, "%");
        ArrayList<TableColumn> listTableColumn = new ArrayList<TableColumn>();
        TableColumn tableColumn = null;
        while (rs.next()) {
            tableColumn = new TableColumn();
            String columnName = rs.getString("COLUMN_NAME");
            String columnType = rs.getString("TYPE_NAME");
            int dataSize = rs.getInt("COLUMN_SIZE");
            int digits = rs.getInt("DECIMAL_DIGITS");
            int nullable = rs.getInt("NULLABLE");
            tableColumn.setColumnName(columnName);
            tableColumn.setColumnType(columnType);
            tableColumn.setDataSize(dataSize);
            tableColumn.setDigits(digits);
            tableColumn.setNullable(nullable);
            listTableColumn.add(tableColumn);
        }
        return listTableColumn;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Consts.applicationContext = applicationContext;
    }
}

