/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xdja.log.annotation.AutoLog;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.enums.LogStatus;
import com.xdja.log.service.BasicLogCacheService;
import com.xdja.log.threadlocal.ResponseResultThreadLocal;
import com.xdja.sync.service.BasicSyncPersonService;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;
import src.main.java.com.xdja.sync.util.IpAddressUtils;

@Component
@Aspect
public class BasicAutoLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(BasicAutoLogAspect.class);
    @Value(value="${log.switch:on}")
    private String logSwitch;
    @Autowired
    private BasicLogCacheService basicLogCacheService;
    @Autowired
    private BasicSyncPersonService basicSyncPersonService;

    @Pointcut(value="@annotation(com.xdja.log.annotation.AutoLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long beginTime = System.currentTimeMillis();
        int status = LogStatus.SUCCESS.getCode();
        Object result = null;
        long costTime = 0L;
        try {
            result = proceedingJoinPoint.proceed();
            this.cacheLog(proceedingJoinPoint, System.currentTimeMillis() - beginTime, result, status, null);
        }
        catch (Throwable e) {
            logger.error("\u65e5\u5fd7\u8bb0\u5f55\u6267\u884c\u4e1a\u52a1\u5931\u8d25\uff1a", e);
            status = LogStatus.FAIL.getCode();
            this.cacheLog(proceedingJoinPoint, System.currentTimeMillis() - beginTime, result, status, e.getMessage());
            throw e;
        }
        return result;
    }

    private void cacheLog(ProceedingJoinPoint proceedingJoinPoint, long costTime, Object result, int status, String errorMsg) {
        LogCacheBean logCacheBean;
        if ("on".equalsIgnoreCase(this.logSwitch) && null != (logCacheBean = this.buildLogBean(proceedingJoinPoint, costTime, result, status, errorMsg))) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u7f13\u5b58\u65e5\u5fd7");
            }
            this.basicLogCacheService.cacheLog(logCacheBean);
        }
    }

    protected LogCacheBean buildLogBean(ProceedingJoinPoint proceedingJoinPoint, long costTime, Object result, int status, String errorMsg) {
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = signature.getMethod();
        AutoLog autoLog = method.getAnnotation(AutoLog.class);
        if (null == autoLog) {
            return null;
        }
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return null;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        if (null == requestAttributes) {
            return null;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        LogCacheBean logCacheBean = new LogCacheBean();
        logCacheBean.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        logCacheBean.setLogContent(autoLog.logContent());
        logCacheBean.setLogType(autoLog.logType());
        logCacheBean.setOperateType(autoLog.operateType().getCode());
        logCacheBean.setStatus(status);
        logCacheBean.setErrorMsg(errorMsg);
        String loginUserId = (String)request.getAttribute("loginUserId");
        String loginUserCode = (String)request.getAttribute("loginUserCode");
        String loginUserName = (String)request.getAttribute("loginUserName");
        logCacheBean.setCreateBy(loginUserId);
        logCacheBean.setUserId(loginUserId);
        logCacheBean.setUserName(loginUserName);
        logCacheBean.setUserCode(loginUserCode);
        String method1 = request.getMethod();
        logCacheBean.setRequestMethod(method1);
        StringBuffer requestURL = request.getRequestURL();
        logCacheBean.setRequestUrl(requestURL.toString());
        logCacheBean.setRequestHeader(this.getRequestHeaderParam(request));
        logCacheBean.setRequestBody(this.getRequestParams(request, (JoinPoint)proceedingJoinPoint));
        logCacheBean.setResponseHeader(this.getResponseHeaderParam(response));
        if (method.getReturnType().getName().equals("void")) {
            result = ResponseResultThreadLocal.getResult();
            ResponseResultThreadLocal.removeResult();
        }
        logCacheBean.setResponseBody(result instanceof String ? result.toString() : JSON.toJSONString((Object)result));
        logCacheBean.setIp(IpAddressUtils.getIpAddress(request));
        logCacheBean.setCostTime(costTime);
        logCacheBean.setCreateTime(System.currentTimeMillis());
        return logCacheBean;
    }

    protected String getPathParam(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        return new AntPathMatcher().extractPathWithinPattern(bestMatchPattern, path);
    }

    protected String getRequestHeaderParam(HttpServletRequest request) {
        StringBuffer buffer = new StringBuffer();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            buffer.append(" ");
            buffer.append(key);
            buffer.append(": ");
            buffer.append(value);
        }
        return buffer.toString();
    }

    protected String getResponseHeaderParam(HttpServletResponse response) {
        StringBuffer buffer = new StringBuffer();
        Collection headerNames = response.getHeaderNames();
        for (String key : headerNames) {
            String value = response.getHeader(key);
            buffer.append(" ");
            buffer.append(key);
            buffer.append(": ");
            buffer.append(value);
        }
        return buffer.toString();
    }

    protected Map<String, String> getFormParam(HttpServletRequest request) {
        HashMap<String, String> formParam = new HashMap<String, String>();
        Map map = request.getParameterMap();
        for (Map.Entry e : map.entrySet()) {
            formParam.put((String)e.getKey(), ((String[])e.getValue())[0]);
        }
        return formParam;
    }

    protected String getRequestParams(HttpServletRequest request, JoinPoint joinPoint) {
        String httpMethod = request.getMethod();
        String params = "";
        if ("POST".equals(httpMethod) || "PUT".equals(httpMethod) || "PATCH".equals(httpMethod)) {
            Object[] paramsArray = joinPoint.getArgs();
            Object[] arguments = new Object[paramsArray.length];
            for (int i = 0; i < paramsArray.length; ++i) {
                if (paramsArray[i] instanceof BindingResult || paramsArray[i] instanceof ServletRequest || paramsArray[i] instanceof ServletResponse || paramsArray[i] instanceof MultipartFile) continue;
                arguments[i] = paramsArray[i];
            }
            int maxLenth = Integer.MAX_VALUE;
            PropertyFilter profilter = new PropertyFilter(){

                public boolean apply(Object o, String name, Object value) {
                    return true;
                }
            };
            params = JSONObject.toJSONString((Object)arguments, (SerializeFilter)profilter, (SerializerFeature[])new SerializerFeature[0]);
        } else {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = joinPoint.getArgs();
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] paramNames = u.getParameterNames(method);
            StringBuffer buffer = new StringBuffer();
            if (args != null && paramNames != null) {
                for (int i = 0; i < args.length; ++i) {
                    buffer.append(" ");
                    buffer.append(paramNames[i]);
                    buffer.append(": ");
                    buffer.append(args[i]);
                }
            }
            params = buffer.toString();
        }
        return params;
    }
}

