/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.bean.LogCacheKey;
import com.xdja.log.handler.BasicLogHandlerFactory;
import com.xdja.log.service.BasicLogCacheService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisBasicLogCacheServiceImpl
implements BasicLogCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisBasicLogCacheServiceImpl.class);
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public void cacheLog(LogCacheBean logCacheBean) {
        try {
            this.stringRedisTemplate.opsForList().rightPush((Object)LogCacheKey.getLogCacheKey(), (Object)JSON.toJSONString((Object)logCacheBean));
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58\u65e5\u5fd7\u5931\u8d25\u3010\u57fa\u4e8eRedis\u7f13\u5b58\u3011:", (Throwable)e);
        }
    }

    @Override
    public void consumeLog() {
        ListOperations stringStringListOperations = this.stringRedisTemplate.opsForList();
        String json = null;
        while (true) {
            try {
                while (true) {
                    if (null != (json = (String)stringStringListOperations.leftPop((Object)LogCacheKey.getLogCacheKey(), 5L, TimeUnit.SECONDS)) && !"".equals(json.trim())) {
                        LogCacheBean logCacheBean = (LogCacheBean)JSON.parseObject((String)json, LogCacheBean.class);
                        BasicLogHandlerFactory.dispatchListener(logCacheBean);
                        continue;
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                logger.error("\u6d88\u8d39\u65e5\u5fd7\u5931\u8d25\u3010\u57fa\u4e8eRedis\u7f13\u5b58\u3011:", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

