/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.service.BasicSyncResourceService;
import com.xdja.sync.util.CredentialUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AppResourceSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicSyncResourceService basicSyncResourceService;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private AppResourceSyncHandler appResourceSyncHandler;
    @Value(value="${sync.appResource.interval:300}")
    private Long syncAppInterval;
    private volatile boolean syncAppResourceRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "app";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP_RESOURCE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncAppResource();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, 30L, this.syncAppInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncAppResource() {
        if (logger.isDebugEnabled()) {
            logger.debug("===============\u5f00\u59cb\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        AppResourceSyncHandler appResourceSyncHandler = this;
        synchronized (appResourceSyncHandler) {
            if (this.syncAppResourceRunning) {
                logger.error("\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncAppResourceRunning = true;
        }
        int syncAppTotal = 0;
        try {
            List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.warn("\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u9700\u8981\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u7684\u5e94\u7528\u5217\u8868:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncApp));
            }
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            for (SyncApp syncApp : listSyncApp) {
                int appResourceTotal = 0;
                String appId = syncApp.getAppId();
                String appRegionalismCode = syncApp.getRegionalismCode();
                String appNetworkAreaCode = syncApp.getNetworkAreaCode();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u5f00\u59cb\u540c\u6b65\u884c\u653f\u533a\u5212:[{}]\u5e94\u7528\u4fe1\u606f:appId:[{}]\u7684\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f>>>", (Object)appRegionalismCode, (Object)appId);
                }
                try {
                    HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
                    mapReqParam.put("pageNo", 1);
                    mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
                    mapReqParam.put("appId", appId);
                    mapReqParam.put("appRegionalismCode", appRegionalismCode);
                    JSONArray resourceAllList = new JSONArray();
                    int pageNo = 1;
                    while (true) {
                        mapReqParam.put("pageNo", pageNo);
                        JSONArray resourceList = this.queryOffsiteAppResourceList(localRegionalismCode, localNetworkCode, mapReqParam);
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5e94\u7528id:\u3010{}\u3011, \u5e94\u7528\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appId, appRegionalismCode, pageNo, null != resourceList ? resourceList.toJSONString() : null});
                        }
                        if (Objects.isNull(resourceList) || CollectionUtils.isEmpty((Collection)resourceList)) {
                            logger.debug("\u672c\u6b21\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u6570\u636e\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f");
                            break;
                        }
                        resourceAllList.addAll((Collection)resourceList);
                        appResourceTotal += resourceList.size();
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5e94\u7528id:\u3010{}\u3011, \u5e94\u7528\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e\u5b8c\u6210,\u672c\u6b21\u62c9\u53d6:[{}]\u6761,\u5df2\u62c9\u53d6:\u3010{}\u3011<<<", new Object[]{appId, appRegionalismCode, pageNo, resourceList.size(), appResourceTotal});
                        }
                        if (CollectionUtils.isEmpty((Collection)resourceList) || resourceList.size() < this.pageSize) {
                            if (!logger.isDebugEnabled()) break;
                            logger.debug("\u672c\u6b21\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u6570\u636e\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f");
                            break;
                        }
                        ++pageNo;
                    }
                    this.appResourceSyncHandler.saveAppResource(appId, appRegionalismCode, appNetworkAreaCode, resourceAllList);
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5e94\u7528id:\u3010{}\u3011, \u5e94\u7528\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, e});
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u5f00\u59cb\u540c\u6b65\u884c\u653f\u533a\u5212:\u3010{}\u3011\u5e94\u7528\u4fe1\u606f:appId:\u3010{}\u3011\u5e94\u7528\u8d44\u6e90\u5173\u7cfb<<<", (Object)appRegionalismCode, (Object)appId);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncAppResourceRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("===============\u5f00\u59cb\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f<<<");
        }
        return syncAppTotal;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void saveAppResource(String appId, String appRegionalismCode, String appNetworkCode, JSONArray resourceList) {
        void var12_18;
        String sql = null;
        if (null == resourceList || resourceList.isEmpty()) {
            sql = "DELETE FROM t_sync_app_resource  where app_id = ?  and app_regionalism_Code = ? ";
            this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode});
            return;
        }
        HashMap<String, JSONObject> mapJSONObject = new HashMap<String, JSONObject>();
        for (int i = 0; i < resourceList.size(); ++i) {
            JSONObject jsonObject = resourceList.getJSONObject(i);
            String resourceId = jsonObject.getString("resourceId");
            String resourceRegionalismCode = jsonObject.getString("resourceRegionalismCode");
            mapJSONObject.put((String)resourceId + resourceRegionalismCode, jsonObject);
        }
        sql = "SELECT * FROM t_sync_app_resource  where app_id = ?  and app_regionalism_Code = ? ";
        List<?> listDbSyncAppResource = this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncAppResource.class);
        HashMap<Object, SyncAppResource> mapDbJSONObject = new HashMap<Object, SyncAppResource>();
        if (null != listDbSyncAppResource && !listDbSyncAppResource.isEmpty()) {
            for (SyncAppResource syncAppResource : listDbSyncAppResource) {
                String key = syncAppResource.getResourceId() + syncAppResource.getResourceRegionalismCode();
                mapDbJSONObject.put(key, syncAppResource);
            }
        }
        SyncAppResource syncAppResource = null;
        ArrayList<SyncAppResource> listAddJSONObject = new ArrayList<SyncAppResource>();
        for (Map.Entry entry : mapJSONObject.entrySet()) {
            String string = (String)entry.getKey();
            if (mapDbJSONObject.containsKey(string)) continue;
            JSONObject value = (JSONObject)entry.getValue();
            String resourceId = value.getString("resourceId");
            String resourceRegionalismCode = value.getString("resourceRegionalismCode");
            syncAppResource = new SyncAppResource();
            syncAppResource.setAppId(appId);
            syncAppResource.setAppRegionalismCode(appRegionalismCode);
            syncAppResource.setResourceId(resourceId);
            syncAppResource.setResourceRegionalismCode(resourceRegionalismCode);
            listAddJSONObject.add(syncAppResource);
        }
        ArrayList listDeleteJSONObject = new ArrayList();
        for (Map.Entry entry : mapDbJSONObject.entrySet()) {
            String key = (String)entry.getKey();
            if (mapJSONObject.containsKey(key)) continue;
            listDeleteJSONObject.add(entry.getValue());
        }
        if (null != listDeleteJSONObject && !listDeleteJSONObject.isEmpty()) {
            sql = "UPDATE t_sync_app_resource SET status = 3, LAST_UPDATE_TIME = ? where app_id = ?  and app_regionalism_Code = ?  and resource_id = ?  and resource_regionalism_Code = ? ";
            for (SyncAppResource syncAppResource2 : listDeleteJSONObject) {
                Object[] values = new Object[]{System.currentTimeMillis(), appId, appRegionalismCode, syncAppResource2.getResourceId(), syncAppResource2.getResourceRegionalismCode()};
                this.basicSyncCommonDao.updateBySql(sql, values);
            }
        }
        boolean bl = false;
        while (var12_18 < listAddJSONObject.size()) {
            SyncAppResource syncAppResource3 = (SyncAppResource)listAddJSONObject.get((int)var12_18);
            String resourceId = syncAppResource3.getResourceId();
            String resourceRegionalismCode = syncAppResource3.getResourceRegionalismCode();
            SyncResource syncResource = this.basicSyncResourceService.querySyncResourceById(resourceId, resourceRegionalismCode);
            Integer resourceNetworkAreaCode = null;
            if (null != syncResource) {
                resourceNetworkAreaCode = syncResource.getNetworkAreaCode();
            }
            sql = "DELETE FROM t_sync_app_resource  where app_id = ?  and app_regionalism_Code = ? and RESOURCE_ID = ? and RESOURCE_REGIONALISM_CODE = ? ";
            this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode, resourceId, resourceRegionalismCode});
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            sql = "INSERT INTO t_sync_app_resource (APP_RESOURCE_ID, APP_ID, APP_REGIONALISM_CODE, APP_NETWORK_CODE, RESOURCE_ID, RESOURCE_REGIONALISM_CODE, RESOURCE_NETWORK_CODE, CREATE_TIME, LAST_UPDATE_TIME, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
            Object[] args = new Object[]{id, appId, appRegionalismCode, appNetworkCode, resourceId, resourceRegionalismCode, resourceNetworkAreaCode, System.currentTimeMillis(), System.currentTimeMillis(), 1};
            try {
                this.basicSyncCommonDao.updateBySql(sql, args);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5931\u8d25:", (Throwable)e);
            }
            ++var12_18;
        }
    }

    private JSONArray queryOffsiteAppResourceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_06.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212:[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("resourceList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212[{}]\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        return resultList;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP_RESOURCE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

