create table t_sync_resource
(
  id        VARCHAR2(32) not null,
  resource_id     VARCHAR2(128),
  regionalism_Code     VARCHAR2(32),
  network_area_code     VARCHAR2(1) default '1',
  resource_type     NUMBER(1),
  service_type     VARCHAR2(32),
  resource_service_type     VARCHAR2(12),
  resource_operator_type     VARCHAR2(2),
  resource_interface_type     VARCHAR2(2),
  resource_interface_address     VARCHAR2(500),
  power_type     VARCHAR2(2),
  resource_name     VARCHAR2(500),
  resource_description     VARCHAR2(500),
  status     NUMBER(1),
  publish_scope     VARCHAR2(4000),
  register_time     NUMBER(19),
  update_time     NUMBER(19),
  dep_code     VARCHAR2(100),
  owner_Identifier     VARCHAR2(18),
  approver_Identifier     VARCHAR2(18),
  approve_Time     NUMBER(19),
  last_Update_Time     NUMBER(19)
);
comment on table t_sync_resource is '全国服务平台信息表';
comment on column t_sync_resource.id is '主键';
comment on column t_sync_resource.resource_id is '资源ID\r\n单个平台内唯一,规则为“XXXXXXXXXX(12位服务事权单位机构代码，事权单位为公安机关则按照GA380填写；事权单位为非公安机关则填写18位统一社会信用代码)-X(1位区域类型)-XXXX（4位业务类型代码）-XXXXX(字母或数字，总长度不超过32)”；其中流水号采取机构单位内小编吗（即不同机构单位内流水号从1开始）。编号一经生成后不可修改（可以删除），且不复用；如：\r\n010000000000-3-0100-XXXXX 部级平台Ⅲ类区通用数据查询服务\r\n1级，服务资源事权单位机构代码\r\n2级，系统区域标识\r\n3级，业务类型代码\r\n4级，字母或数字，总长度不超过32\r\n业务类型代码：\r\n0100	查询检索类服务\r\n0200	比对订阅类服务\r\n0300	模型分析类服务\r\n0400	数据推送类服务\r\n0500	数据鉴权服务\r\n0600	数据操作类服务\r\n0700	数据服务管理类服务\r\n0800	其他服务';
comment on column t_sync_resource.regionalism_code is '行政区划编码code，GA380标准组织机构代码';
comment on column t_sync_resource.network_area_code is '服务网络区域代码 1 互联网, 2 公安移动信息网, 3 公安网, 4 视频专网';
comment on column t_sync_resource.resource_type is '资源可用区域标识\r\n1-Ⅰ类资源\r\n2-Ⅱ类资源\r\n3-Ⅲ类资源';
comment on column t_sync_resource.service_type is '服务类型';
comment on column t_sync_resource.resource_service_type is '资源服务类型\r\n第1位为总类型：\r\n1-摆渡交换\r\n2-请求服务\r\n3-授权访问\r\n第2位为细分类型，如果没有用0表示';
comment on column t_sync_resource.resource_operator_type is '资源操作类型\r\n1-查询、2-写入、3-更新、4-删除';
comment on column t_sync_resource.resource_interface_type is '资源接口类型\r\n资源接口类型\r\n11-HTTP\r\n12-HTTPS\r\n21-TCP\r\n22-UDP';
comment on column t_sync_resource.resource_interface_address is '资源接口地址';
comment on column t_sync_resource.power_type is '资源授权方式\r\n10-全公开、21-需由使用地授权、22-需由归属地授权、23-需由两地授权、31-需向使用地申请、32-需向归属地申请、33-需向两地申请';
comment on column t_sync_resource.resource_name is '资源名称';
comment on column t_sync_resource.resource_description is '资源描述';
comment on column t_sync_resource.status is '资源状态 1 启用；0 禁用';
comment on column t_sync_resource.publish_scope is '资源发布范围，多个以英文逗号分割，GA380标准组织机构代码组成';
comment on column t_sync_resource.register_time is '资源注册时间戳';
comment on column t_sync_resource.update_Time is '资源更新时间戳';
comment on column t_sync_resource.dep_code is '来源机构标识\r\n资源所有者所属部门代码（应按照全国统一部门代码返回）';
comment on column t_sync_resource.owner_Identifier is '注册人标识\r\n资源注册人身份证号码';
comment on column t_sync_resource.approver_Identifier is '审批人标识资源审批人身份证号码';
comment on column t_sync_resource.approve_Time is '审批时间';
comment on column t_sync_resource.last_Update_Time is '最后一次更新时间';
alter table t_sync_resource add primary key (id);
alter table t_sync_resource add unique (resource_id, network_area_Code, regionalism_code);
