/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xdja.log.annotation.AutoLog;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.enums.ClientType;
import com.xdja.log.enums.LogStatus;
import com.xdja.log.enums.RequestMethod;
import com.xdja.log.enums.RequestType;
import com.xdja.log.handler.BasicLogHandlerFactory;
import com.xdja.log.service.BasicLogCacheService;
import com.xdja.log.threadlocal.ResponseResultThreadLocal;
import com.xdja.sync.service.BasicSyncPersonService;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;
import src.main.java.com.xdja.sync.util.IpAddressUtils;

@Component
@Aspect
public class BasicAutoLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(BasicAutoLogAspect.class);
    private static final String LOG_SWITCH_KEY = "log.switch";
    @Autowired
    private Environment environment;
    @Autowired
    private BasicLogCacheService basicLogCacheService;
    @Autowired
    private BasicSyncPersonService basicSyncPersonService;
    @Autowired
    private BasicLogHandlerFactory basicLogHandlerFactory;

    @Pointcut(value="@annotation(com.xdja.log.annotation.AutoLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long beginTime = System.currentTimeMillis();
        int status = LogStatus.SUCCESS.getCode();
        Object result = null;
        try {
            result = proceedingJoinPoint.proceed();
            this.cacheLog(proceedingJoinPoint, System.currentTimeMillis() - beginTime, result, status, null);
        }
        catch (Throwable e) {
            logger.error("\u65e5\u5fd7\u8bb0\u5f55\u6267\u884c\u4e1a\u52a1\u5931\u8d25\uff1a", e);
            status = LogStatus.FAIL.getCode();
            this.cacheLog(proceedingJoinPoint, System.currentTimeMillis() - beginTime, result, status, e.getMessage());
            throw e;
        }
        return result;
    }

    private void cacheLog(ProceedingJoinPoint proceedingJoinPoint, long costTime, Object result, int status, String errorMsg) {
        try {
            LogCacheBean logCacheBean;
            String logSwitch = this.environment.getProperty(LOG_SWITCH_KEY, "off");
            if ("on".equalsIgnoreCase(logSwitch) && null != (logCacheBean = this.buildLogBean(proceedingJoinPoint, costTime, result, status, errorMsg))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u7f13\u5b58\u65e5\u5fd7LogCacheBean:\u3010{}\u3011", (Object)JSON.toJSONString((Object)logCacheBean));
                }
                this.basicLogCacheService.cacheLog(logCacheBean);
            }
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    protected LogCacheBean buildLogBean(ProceedingJoinPoint proceedingJoinPoint, long costTime, Object result, int status, String errorMsg) {
        boolean flag;
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = signature.getMethod();
        AutoLog autoLog = method.getAnnotation(AutoLog.class);
        if (null == autoLog) {
            return null;
        }
        ClientType clientType = autoLog.clientType();
        if (!ClientType.ADMIN.equals((Object)clientType) && !(flag = this.basicLogHandlerFactory.existExcludeAdminLogHandler())) {
            return null;
        }
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes1) {
            return null;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        if (null == requestAttributes) {
            return null;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        LogCacheBean logCacheBean = new LogCacheBean();
        logCacheBean.setClientType(clientType.getCode());
        logCacheBean.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        logCacheBean.setLogContent(autoLog.logContent());
        logCacheBean.setLogType(autoLog.logType());
        logCacheBean.setOperateType(autoLog.operateType().getCode());
        logCacheBean.setCreateBy((String)request.getAttribute("loginUserId"));
        logCacheBean.setUserId((String)request.getAttribute("loginUserId"));
        logCacheBean.setUserName((String)request.getAttribute("loginUserName"));
        logCacheBean.setUserCode((String)request.getAttribute("loginUserCode"));
        String httpMethod = request.getMethod();
        logCacheBean.setRequestMethod(RequestMethod.changeCode(httpMethod));
        if ("post".equalsIgnoreCase(httpMethod)) {
            String contentType = request.getContentType();
            if (contentType.contains(ContentType.APPLICATION_JSON.getMimeType())) {
                logCacheBean.setRequestType(RequestType.JSON.getCode());
            } else if (contentType.contains(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                logCacheBean.setRequestType(RequestType.FORM.getCode());
            }
        }
        StringBuffer requestURL = request.getRequestURL();
        logCacheBean.setRequestUrl(requestURL.toString());
        logCacheBean.setRequestHeader(this.getRequestHeaderParam(request));
        logCacheBean.setRequestBody(this.getRequestParams(request, (JoinPoint)proceedingJoinPoint));
        logCacheBean.setResponseHeader(this.getResponseHeaderParam(response));
        if (method.getReturnType().getName().equalsIgnoreCase("void")) {
            result = ResponseResultThreadLocal.getResult();
            ResponseResultThreadLocal.removeResult();
        }
        logCacheBean.setResponseBody(result instanceof String ? result.toString() : JSON.toJSONString((Object)result));
        logCacheBean.setStatus(status);
        logCacheBean.setErrorMsg(errorMsg);
        String headerCode = response.getHeader("code");
        if (null != headerCode && !"".equalsIgnoreCase(headerCode)) {
            int code = Integer.parseInt(headerCode);
            logCacheBean.setStatus(code);
            if (LogStatus.SUCCESS.getCode() != code) {
                String headerMsg = response.getHeader("message");
                try {
                    logCacheBean.setErrorMsg(URLDecoder.decode(headerMsg, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logCacheBean.setErrorMsg(headerMsg);
                }
            }
        }
        logCacheBean.setIp(IpAddressUtils.getIpAddress(request));
        logCacheBean.setCostTime(costTime);
        logCacheBean.setCreateTime(System.currentTimeMillis());
        return logCacheBean;
    }

    protected String getPathParam(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        return new AntPathMatcher().extractPathWithinPattern(bestMatchPattern, path);
    }

    protected String getRequestHeaderParam(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return JSON.toJSONString(map);
    }

    protected String getResponseHeaderParam(HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        Collection headerNames = response.getHeaderNames();
        for (String key : headerNames) {
            String value = response.getHeader(key);
            map.put(key, value);
        }
        return JSON.toJSONString(map);
    }

    protected Map<String, String> getFormParam(HttpServletRequest request) {
        HashMap<String, String> formParam = new HashMap<String, String>();
        Map map = request.getParameterMap();
        for (Map.Entry e : map.entrySet()) {
            formParam.put((String)e.getKey(), ((String[])e.getValue())[0]);
        }
        return formParam;
    }

    protected String getRequestParams(HttpServletRequest request, JoinPoint joinPoint) {
        String httpMethod = request.getMethod();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String params = "";
        if ("POST".equals(httpMethod)) {
            Object[] paramsArray = joinPoint.getArgs();
            ArrayList<Object> listArg = new ArrayList<Object>();
            for (int i = 0; i < paramsArray.length; ++i) {
                Object param = paramsArray[i];
                if (param instanceof BindingResult || param instanceof ServletRequest || param instanceof ServletResponse || param instanceof MultipartFile) continue;
                listArg.add(param);
            }
            int maxLenth = Integer.MAX_VALUE;
            PropertyFilter profilter = new PropertyFilter(){

                public boolean apply(Object o, String name, Object value) {
                    return true;
                }
            };
            if (listArg.size() == 1) {
                Object o = listArg.get(0);
                params = o instanceof String ? o.toString() : JSONObject.toJSONString(o, (SerializeFilter)profilter, (SerializerFeature[])new SerializerFeature[0]);
            } else if (listArg.size() > 1) {
                params = JSONObject.toJSONString(listArg, (SerializeFilter)profilter, (SerializerFeature[])new SerializerFeature[0]);
            }
        } else {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = joinPoint.getArgs();
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] paramNames = u.getParameterNames(method);
            if (args != null && paramNames != null) {
                for (int i = 0; i < args.length; ++i) {
                    String key = paramNames[i];
                    Object value = args[i];
                    map.put(key, value);
                }
            }
            params = JSON.toJSONString(map);
        }
        return params;
    }
}

