/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.handler;

import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.enums.ClientType;
import com.xdja.log.handler.AdminBasicLogSaveHandler;
import com.xdja.log.handler.BasicLogSaveHandler;
import com.xdja.log.service.BasicLogCacheService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class BasicLogHandlerFactory
implements ApplicationContextAware,
InitializingBean {
    @Autowired
    private BasicLogCacheService basicLogCacheService;
    @Autowired
    private AdminBasicLogSaveHandler adminBasicLogSaveHandler;
    private List<BasicLogSaveHandler> listLogHandler = null;

    public boolean existExcludeAdminLogHandler() {
        return null != this.listLogHandler && this.listLogHandler.size() > 0;
    }

    public void handlerLog(LogCacheBean logCacheBean) {
        Integer clientType = logCacheBean.getClientType();
        if (ClientType.ADMIN.getCode() == clientType.intValue()) {
            this.adminBasicLogSaveHandler.saveLog(logCacheBean);
        } else if (null != this.listLogHandler && !this.listLogHandler.isEmpty()) {
            for (BasicLogSaveHandler logSaveHandler : this.listLogHandler) {
                logSaveHandler.saveLog(logCacheBean);
            }
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Map logHandlerMapTmp = context.getBeansOfType(BasicLogSaveHandler.class);
        this.listLogHandler = new ArrayList<BasicLogSaveHandler>();
        for (BasicLogSaveHandler logSaveHandler : logHandlerMapTmp.values()) {
            if (logSaveHandler instanceof AdminBasicLogSaveHandler) continue;
            this.listLogHandler.add(logSaveHandler);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                BasicLogHandlerFactory.this.basicLogCacheService.consumeLog();
            }
        });
        thread.setDaemon(true);
        thread.setName("log-consumer-thread");
        thread.start();
    }
}

