/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.util.excel;

import com.xdja.log.util.excel.ExcelCell;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static void getExcel(OutputStream output, String sheetName, List<?> dates) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment((short)2);
        cellStyleWithDate.setVerticalAlignment((short)1);
        cellStyleWithDate.setBorderBottom((short)1);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft((short)1);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight((short)1);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop((short)1);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment((short)2);
        cellStyleHead.setVerticalAlignment((short)1);
        cellStyleHead.setBorderBottom((short)6);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft((short)1);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight((short)1);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop((short)1);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern((short)1);
        Field[] fields = dates.get(0).getClass().getDeclaredFields();
        int x = 0;
        HSSFCell cell = row.createCell(x);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        for (Field field : fields) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCell.title());
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        for (int i = 0; i < dates.size(); ++i) {
            row = sheet.createRow(1 + i);
            row.setHeightInPoints(20.0f);
            Object object = dates.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void getExcel(OutputStream output, String sheetName, String title, List<?> dates) throws Exception {
        Field[] fields;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment((short)2);
        cellStyleWithDate.setVerticalAlignment((short)1);
        cellStyleWithDate.setBorderBottom((short)1);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft((short)1);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight((short)1);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop((short)1);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment((short)2);
        cellStyleHead.setVerticalAlignment((short)1);
        cellStyleHead.setBorderBottom((short)6);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft((short)1);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight((short)1);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop((short)1);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern((short)1);
        HSSFCellStyle cellStyleTitle = wb.createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setVerticalAlignment((short)1);
        cellStyleTitle.setBorderBottom((short)1);
        cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderLeft((short)1);
        cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderRight((short)1);
        cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderTop((short)1);
        cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)13);
        cellStyleTitle.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        for (Field field : fields = dates.get(0).getClass().getDeclaredFields()) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCell.title());
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCell titleCell = row.createCell(0);
        titleCell.setCellValue(title);
        titleCell.setCellStyle((CellStyle)cellStyleTitle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, x - 1));
        for (int i = 0; i < dates.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            Object object = dates.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void getExcel(OutputStream output, String sheetName, List<String> listTitle, List<Object[]> dates) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment((short)2);
        cellStyleWithDate.setVerticalAlignment((short)1);
        cellStyleWithDate.setBorderBottom((short)1);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft((short)1);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight((short)1);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop((short)1);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment((short)2);
        cellStyleHead.setVerticalAlignment((short)1);
        cellStyleHead.setBorderBottom((short)6);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft((short)1);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight((short)1);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop((short)1);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern((short)1);
        HSSFCellStyle cellStyleTitle = wb.createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setVerticalAlignment((short)1);
        cellStyleTitle.setBorderBottom((short)1);
        cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderLeft((short)1);
        cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderRight((short)1);
        cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderTop((short)1);
        cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)13);
        cellStyleTitle.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        for (String title : listTitle) {
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(title);
            sheet.setColumnWidth(x, 12800);
            ++x;
        }
        for (int i = 0; i < dates.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            Object[] object = dates.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            Object[] aryData = dates.get(i);
            int n = 1;
            for (Object tmp : aryData) {
                HSSFCell data = row.createCell(n);
                if (null == tmp) {
                    data.setCellValue("");
                    data.setCellStyle((CellStyle)cellStyleWithDate);
                } else if (tmp instanceof Date) {
                    data.setCellValue((Date)tmp);
                    data.setCellStyle((CellStyle)cellStyleWithDate);
                } else {
                    data.setCellValue((String)tmp);
                    data.setCellStyle((CellStyle)cellStyle);
                }
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void getExcelAsTitle(OutputStream output, String sheetName, String title, List<?> dates, List<String> titleList) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment((short)2);
        cellStyleWithDate.setVerticalAlignment((short)1);
        cellStyleWithDate.setBorderBottom((short)1);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft((short)1);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight((short)1);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop((short)1);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment((short)2);
        cellStyleHead.setVerticalAlignment((short)1);
        cellStyleHead.setBorderBottom((short)6);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft((short)1);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight((short)1);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop((short)1);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern((short)1);
        HSSFCellStyle cellStyleTitle = wb.createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setVerticalAlignment((short)1);
        cellStyleTitle.setBorderBottom((short)1);
        cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderLeft((short)1);
        cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderRight((short)1);
        cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderTop((short)1);
        cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)13);
        cellStyleTitle.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        Field[] fields = dates.get(0).getClass().getDeclaredFields();
        int j = 0;
        for (Field field : fields) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(titleList.get(j));
            ++j;
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCell titleCell = row.createCell(0);
        titleCell.setCellValue(title);
        titleCell.setCellStyle((CellStyle)cellStyleTitle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, x - 1));
        for (int i = 0; i < dates.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            Object object = dates.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    if (8 != excelCell.fontColor()) {
                        HSSFCellStyle errorInfoCellStyle = wb.createCellStyle();
                        errorInfoCellStyle.setAlignment((short)2);
                        errorInfoCellStyle.setVerticalAlignment((short)1);
                        errorInfoCellStyle.setBorderBottom((short)1);
                        errorInfoCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
                        errorInfoCellStyle.setBorderLeft((short)1);
                        errorInfoCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
                        errorInfoCellStyle.setBorderRight((short)1);
                        errorInfoCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
                        errorInfoCellStyle.setBorderTop((short)1);
                        errorInfoCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
                        HSSFFont font1 = wb.createFont();
                        font1.setColor(excelCell.fontColor());
                        errorInfoCellStyle.setFont((Font)font1);
                        data.setCellStyle((CellStyle)errorInfoCellStyle);
                    } else {
                        data.setCellStyle((CellStyle)cellStyle);
                    }
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void getExcel(OutputStream output, String sheetName, List<?> dates, Class<?> clazz) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment((short)2);
        cellStyleWithDate.setVerticalAlignment((short)1);
        cellStyleWithDate.setBorderBottom((short)1);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft((short)1);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight((short)1);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop((short)1);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment((short)2);
        cellStyleHead.setVerticalAlignment((short)1);
        cellStyleHead.setBorderBottom((short)6);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft((short)1);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight((short)1);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop((short)1);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern((short)1);
        Field[] fields = clazz.getDeclaredFields();
        int x = 0;
        HSSFCell cell = row.createCell(x);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        for (Field field : fields) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCell.title());
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        for (int i = 0; i < dates.size(); ++i) {
            row = sheet.createRow(1 + i);
            row.setHeightInPoints(20.0f);
            Object object = dates.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void getExcel(OutputStream output, int length, String sheetName, List<?> dates, Class<?> clazz) throws Exception {
        int readLength;
        Field[] fields = dates.get(0).getClass().getDeclaredFields();
        ArrayList<String> fileNames = new ArrayList<String>();
        File zip = new File("temp.zip");
        int m = dates.size() / length + 1;
        for (int j = 0; j < m; ++j) {
            int min;
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFCreationHelper createHelper = wb.getCreationHelper();
            HSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)1);
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setBorderLeft((short)1);
            cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setBorderRight((short)1);
            cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyle.setBorderTop((short)1);
            cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
            HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
            cellStyleWithDate.setAlignment((short)2);
            cellStyleWithDate.setVerticalAlignment((short)1);
            cellStyleWithDate.setBorderBottom((short)1);
            cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setBorderLeft((short)1);
            cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setBorderRight((short)1);
            cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setBorderTop((short)1);
            cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
            HSSFCellStyle cellStyleHead = wb.createCellStyle();
            cellStyleHead.setAlignment((short)2);
            cellStyleHead.setVerticalAlignment((short)1);
            cellStyleHead.setBorderBottom((short)6);
            cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setBorderLeft((short)1);
            cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setBorderRight((short)1);
            cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setBorderTop((short)1);
            cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
            cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellStyleHead.setFillPattern((short)1);
            HSSFSheet sheet = wb.createSheet(sheetName + (length * j + 1) + "-" + (dates.size() - j * length + 1 > length + 1 ? length * (j + 1) : dates.size()));
            HSSFRow row = sheet.createRow(0);
            row.setHeightInPoints(30.0f);
            int x = 0;
            HSSFCell cell = row.createCell(x);
            cell.setCellStyle((CellStyle)cellStyleHead);
            cell.setCellValue("\u5e8f\u53f7");
            sheet.setColumnWidth(x, 2560);
            ++x;
            String file = "data_" + (length * j + 1) + "-" + (dates.size() - j * length + 1 > length + 1 ? length * (j + 1) : dates.size()) + ".xls";
            fileNames.add(file);
            FileOutputStream o = null;
            o = new FileOutputStream(file);
            for (Field field : fields) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                HSSFCell cellHead = row.createCell(x);
                cellHead.setCellStyle((CellStyle)cellStyleHead);
                cellHead.setCellValue(excelCell.title());
                sheet.setColumnWidth(x, 256 * excelCell.width());
                ++x;
            }
            int n = min = dates.size() - j * length + 1 > length + 1 ? length + 1 : dates.size() - j * length + 1;
            for (int i = 1; i < min; ++i) {
                row = sheet.createRow(0 + i);
                row.setHeightInPoints(20.0f);
                Object object = dates.get(length * j + i - 1);
                HSSFCell xh = row.createCell(0);
                xh.setCellStyle((CellStyle)cellStyle);
                xh.setCellValue((double)(length * j + i));
                int n2 = 1;
                for (Field field : object.getClass().getDeclaredFields()) {
                    ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                    if (null == excelCell) continue;
                    field.setAccessible(true);
                    HSSFCell data = row.createCell(n2);
                    if (excelCell.isDate()) {
                        if (null != field.get(object)) {
                            Date date = new Date(Long.parseLong(field.get(object).toString()));
                            data.setCellValue(date);
                            data.setCellStyle((CellStyle)cellStyleWithDate);
                        } else {
                            data.setCellValue("");
                            data.setCellStyle((CellStyle)cellStyleWithDate);
                        }
                    } else {
                        if (field.get(object) != null) {
                            data.setCellValue(field.get(object).toString());
                        }
                        data.setCellStyle((CellStyle)cellStyle);
                    }
                    field.setAccessible(false);
                    ++n2;
                }
            }
            wb.write((OutputStream)o);
            o.flush();
            o.close();
        }
        File[] srcfile = new File[fileNames.size()];
        int n = fileNames.size();
        for (int i = 0; i < n; ++i) {
            srcfile[i] = new File((String)fileNames.get(i));
        }
        ExcelUtil.ZipFiles(srcfile, zip);
        FileInputStream inStream = new FileInputStream(zip);
        byte[] buf = new byte[4096];
        while ((readLength = inStream.read(buf)) != -1) {
            output.write(buf, 0, readLength);
        }
        inStream.close();
        int n3 = fileNames.size();
        for (int i = 0; i < n3; ++i) {
            FileUtils.forceDelete((File)new File((String)fileNames.get(i)));
        }
        FileUtils.forceDelete((File)zip);
    }

    public static void ZipFiles(File[] srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            for (int i = 0; i < srcfile.length; ++i) {
                int len;
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void exportExcel(String title, OutputStream output, String sheetName, List<Map<String, Object>> maps, String[] heanderNames, String[] keys) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        CellStyle titleCellStyle = ExcelUtil.createTitleCellStyle(wb);
        CellStyle headCellStyle = ExcelUtil.createHeadCellStyle(wb);
        CellStyle normalCellStyle = ExcelUtil.createNormalCellStyle(wb);
        HSSFSheet sheet = wb.createSheet(sheetName);
        sheet.createFreezePane(0, 2);
        HSSFRow titleRow = sheet.createRow(0);
        titleRow.setHeightInPoints(60.0f);
        HSSFRow row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell titleCell = titleRow.createCell(x);
        titleCell.setCellStyle(titleCellStyle);
        titleCell.setCellValue(title);
        HSSFCell cellHead = row.createCell(x);
        cellHead.setCellStyle(headCellStyle);
        cellHead.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 1280);
        ++x;
        if (maps == null || heanderNames == null || keys == null || heanderNames.length != keys.length) {
            throw new Exception("\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bfc\u51faexcel\u64cd\u4f5c\uff01");
        }
        for (String header : heanderNames) {
            titleCell = titleRow.createCell(x);
            titleCell.setCellStyle(titleCellStyle);
            cellHead = row.createCell(x);
            cellHead.setCellStyle(headCellStyle);
            cellHead.setCellValue(header);
            sheet.setColumnWidth(x, 5120);
            ++x;
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, (int)((short)heanderNames.length)));
        for (int i = 0; i < maps.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle(normalCellStyle);
            xh.setCellValue((double)(i + 1));
            HSSFCell data = null;
            int n = 1;
            String value = null;
            Map<String, Object> map = maps.get(i);
            for (String key : keys) {
                data = row.createCell(n++);
                value = map.get(key) == null ? "" : map.get(key).toString();
                data.setCellValue(!StringUtils.isEmpty((Object)value) ? value : "");
                data.setCellStyle(normalCellStyle);
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static CellStyle createTitleCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment((short)2);
        titleCellStyle.setVerticalAlignment((short)1);
        titleCellStyle.setBorderBottom((short)6);
        titleCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderLeft((short)1);
        titleCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderRight((short)1);
        titleCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderTop((short)1);
        titleCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        titleCellStyle.setFillPattern((short)1);
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)24);
        titleCellStyle.setFont((Font)font);
        return titleCellStyle;
    }

    private static CellStyle createHeadCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle headCellStyle = wb.createCellStyle();
        headCellStyle.setAlignment((short)2);
        headCellStyle.setVerticalAlignment((short)1);
        headCellStyle.setBorderBottom((short)2);
        headCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderLeft((short)1);
        headCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderRight((short)1);
        headCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderTop((short)1);
        headCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headCellStyle.setFillPattern((short)1);
        return headCellStyle;
    }

    private static CellStyle createNormalCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle normalCellStyle = wb.createCellStyle();
        normalCellStyle.setAlignment((short)2);
        normalCellStyle.setVerticalAlignment((short)1);
        normalCellStyle.setBorderBottom((short)1);
        normalCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderLeft((short)1);
        normalCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderRight((short)1);
        normalCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderTop((short)1);
        normalCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setWrapText(true);
        return normalCellStyle;
    }

    public static Sheet parseExcel(MultipartFile file, int sheetNum) throws IOException {
        if (file == null) {
            return null;
        }
        InputStream is = file.getInputStream();
        String version = file.getOriginalFilename().endsWith(".xls") ? "2003" : "2007";
        XSSFSheet sheet = null;
        if ("2003".equals(version)) {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            sheet = wb.getSheetAt(sheetNum);
        } else {
            XSSFWorkbook xwb = new XSSFWorkbook(is);
            sheet = xwb.getSheetAt(sheetNum);
        }
        return sheet;
    }
}

