/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.dao.AppResourceSyncDao;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.service.BasicSyncResourceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppResourceSyncDaoImpl
implements AppResourceSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceSyncDaoImpl.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicSyncResourceService basicSyncResourceService;

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveAppResource(String appId, String appRegionalismCode, String appNetworkCode, JSONArray resourceList) {
        void var12_18;
        String sql = null;
        if (null == resourceList || resourceList.isEmpty()) {
            sql = "DELETE FROM t_sync_app_resource  where app_id = ?  and app_regionalism_Code = ? ";
            this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode});
            return;
        }
        HashMap<String, JSONObject> mapJSONObject = new HashMap<String, JSONObject>();
        for (int i = 0; i < resourceList.size(); ++i) {
            JSONObject jsonObject = resourceList.getJSONObject(i);
            String resourceId = jsonObject.getString("resourceId");
            String resourceRegionalismCode = jsonObject.getString("resourceRegionalismCode");
            mapJSONObject.put((String)resourceId + resourceRegionalismCode, jsonObject);
        }
        sql = "SELECT * FROM t_sync_app_resource  where app_id = ?  and app_regionalism_Code = ? ";
        List<?> listDbSyncAppResource = this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncAppResource.class);
        HashMap<Object, SyncAppResource> mapDbJSONObject = new HashMap<Object, SyncAppResource>();
        if (null != listDbSyncAppResource && !listDbSyncAppResource.isEmpty()) {
            for (SyncAppResource syncAppResource : listDbSyncAppResource) {
                String key = syncAppResource.getResourceId() + syncAppResource.getResourceRegionalismCode();
                mapDbJSONObject.put(key, syncAppResource);
            }
        }
        SyncAppResource syncAppResource = null;
        ArrayList<SyncAppResource> listAddJSONObject = new ArrayList<SyncAppResource>();
        for (Map.Entry entry : mapJSONObject.entrySet()) {
            String string = (String)entry.getKey();
            if (mapDbJSONObject.containsKey(string)) continue;
            JSONObject value = (JSONObject)entry.getValue();
            String resourceId = value.getString("resourceId");
            String resourceRegionalismCode = value.getString("resourceRegionalismCode");
            syncAppResource = new SyncAppResource();
            syncAppResource.setAppId(appId);
            syncAppResource.setAppRegionalismCode(appRegionalismCode);
            syncAppResource.setResourceId(resourceId);
            syncAppResource.setResourceRegionalismCode(resourceRegionalismCode);
            listAddJSONObject.add(syncAppResource);
        }
        ArrayList listDeleteJSONObject = new ArrayList();
        for (Map.Entry entry : mapDbJSONObject.entrySet()) {
            String key = (String)entry.getKey();
            if (mapJSONObject.containsKey(key)) continue;
            listDeleteJSONObject.add(entry.getValue());
        }
        if (null != listDeleteJSONObject && !listDeleteJSONObject.isEmpty()) {
            sql = "UPDATE t_sync_app_resource SET status = 3, LAST_UPDATE_TIME = ? where app_id = ?  and app_regionalism_Code = ?  and resource_id = ?  and resource_regionalism_Code = ? ";
            for (SyncAppResource syncAppResource2 : listDeleteJSONObject) {
                Object[] values = new Object[]{System.currentTimeMillis(), appId, appRegionalismCode, syncAppResource2.getResourceId(), syncAppResource2.getResourceRegionalismCode()};
                this.basicSyncCommonDao.updateBySql(sql, values);
            }
        }
        boolean bl = false;
        while (var12_18 < listAddJSONObject.size()) {
            SyncAppResource syncAppResource3 = (SyncAppResource)listAddJSONObject.get((int)var12_18);
            String resourceId = syncAppResource3.getResourceId();
            String resourceRegionalismCode = syncAppResource3.getResourceRegionalismCode();
            SyncResource syncResource = this.basicSyncResourceService.querySyncResourceById(resourceId, resourceRegionalismCode);
            Integer resourceNetworkAreaCode = null;
            if (null != syncResource) {
                resourceNetworkAreaCode = syncResource.getNetworkAreaCode();
            }
            sql = "DELETE FROM t_sync_app_resource  where app_id = ?  and app_regionalism_Code = ? and RESOURCE_ID = ? and RESOURCE_REGIONALISM_CODE = ? ";
            this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode, resourceId, resourceRegionalismCode});
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            sql = "INSERT INTO t_sync_app_resource (APP_RESOURCE_ID, APP_ID, APP_REGIONALISM_CODE, APP_NETWORK_CODE, RESOURCE_ID, RESOURCE_REGIONALISM_CODE, RESOURCE_NETWORK_CODE, CREATE_TIME, LAST_UPDATE_TIME, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
            Object[] args = new Object[]{id, appId, appRegionalismCode, appNetworkCode, resourceId, resourceRegionalismCode, resourceNetworkAreaCode, System.currentTimeMillis(), System.currentTimeMillis(), 1};
            try {
                this.basicSyncCommonDao.updateBySql(sql, args);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5931\u8d25:", (Throwable)e);
            }
            ++var12_18;
        }
    }
}

