/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.Regionalism;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.AppSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.util.CredentialUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AppSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private AppSyncDao appSyncDao;
    @Value(value="${sync.app.interval:300}")
    private Long syncAppInterval;
    private volatile boolean syncAppRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "app";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncApp();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528,\u5f02\u5e38:", (Throwable)e);
            }
        }, 30L, this.syncAppInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncApp() {
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528>>>>>>");
        }
        AppSyncHandler appSyncHandler = this;
        synchronized (appSyncHandler) {
            if (this.syncAppRunning) {
                logger.error("\u540c\u6b65\u5e94\u7528,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncAppRunning = true;
        }
        int syncAppTotal = 0;
        try {
            List<String> listRegionalismCode = this.basicInfoSyncService.getRegionalismCodeList(Regionalism.STATUS_NORMAL);
            if (CollectionUtils.isEmpty(listRegionalismCode)) {
                logger.error("\u540c\u6b65\u5e94\u7528,\u5168\u56fd\u884c\u653f\u533a\u5212\u7f16\u7801\u4e3a\u7a7a(t_sync_regionalisms),\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528,\u5168\u56fd\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011", Arrays.asList(listRegionalismCode));
            }
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            for (String appRegionalismCode : listRegionalismCode) {
                Long appLastUpdateTime = this.appSyncDao.getAppLastUpdateTime(appRegionalismCode);
                appLastUpdateTime = null == appLastUpdateTime ? 0L : appLastUpdateTime;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,lastUpdateTime:\u3010{}\u3011>>>", (Object)appRegionalismCode, (Object)appLastUpdateTime);
                }
                HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
                mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
                mapReqParam.put("updateTime", appLastUpdateTime);
                mapReqParam.put("fromRegionalismCode", localRegionalismCode);
                mapReqParam.put("appRegionalismCode", appRegionalismCode);
                JSONArray result = new JSONArray();
                int pageNo = 1;
                while (true) {
                    block23: {
                        try {
                            mapReqParam.put("pageNo", pageNo);
                            JSONArray appList = this.queryAppList(appRegionalismCode, localNetworkCode, mapReqParam);
                            if (logger.isDebugEnabled()) {
                                logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,page:\u3010{}\u3011,rows:\u3010{}\u3011>>>", new Object[]{appRegionalismCode, pageNo, appList.toJSONString()});
                            }
                            if (Objects.isNull(appList) || CollectionUtils.isEmpty((Collection)appList)) {
                                logger.debug("\u540c\u6b65\u5e94\u7528,\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f");
                                break;
                            }
                            result.addAll((Collection)appList);
                            syncAppTotal += appList.size();
                            if (logger.isDebugEnabled()) {
                                logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,page:\u3010{}\u3011,rows:\u3010{}\u3011,total:\u3010{}\u3011<<<", new Object[]{appRegionalismCode, pageNo, appList.toJSONString(), syncAppTotal});
                            }
                            if (CollectionUtils.isEmpty((Collection)appList) || appList.size() < this.pageSize) {
                                if (!logger.isDebugEnabled()) break;
                                logger.debug("\u540c\u6b65\u5e94\u7528,\u672c\u6b21\u540c\u6b65\u5e94\u7528\u6570\u636e\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f");
                            }
                            break block23;
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,page:\u3010{}\u3011,\u5f02\u5e38:", new Object[]{appRegionalismCode, pageNo, e});
                        }
                        break;
                    }
                    ++pageNo;
                }
                this.appSyncDao.saveApp(result, appRegionalismCode);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,lastUpdateTime:[{}]<<<", (Object)appRegionalismCode, (Object)appLastUpdateTime);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncAppRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528<<<\u8017\u65f6:\u3010{}\u3011", (Object)(System.currentTimeMillis() - startTime));
        }
        return syncAppTotal;
    }

    private JSONArray queryAppList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_MAM_SVC_01.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,app:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,\u5e94\u7528\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("roamAppList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        for (int i = 0; i < resultList.size(); ++i) {
            JSONObject appInfo = resultList.getJSONObject(i);
            String appId = appInfo.getString("appId");
            try {
                JSONObject detail = this.queryAppDetail(appId, regionalismCode, localNetworkCode);
                if (Objects.isNull(detail)) {
                    logger.warn("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,appId:[{}]\u8be6\u7ec6\u4fe1\u606f\u4e3a\u7a7a", (Object)regionalismCode, (Object)appId);
                    continue;
                }
                appInfo.putAll((Map)detail);
                continue;
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,appId:\u3010{}\u3011\u8be6\u60c5\u5931\u8d25:", new Object[]{regionalismCode, appId, e});
                throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528" + appId + "\u8be6\u60c5\u9519\u8bef:" + e.getMessage());
            }
        }
        return resultList;
    }

    private JSONObject queryAppDetail(String appId, String regionalismCode, String localNetworkCode) {
        JSONObject result;
        HashMap<String, String> mapReqParam = new HashMap<String, String>();
        mapReqParam.put("appId", appId);
        mapReqParam.put("appRegionalismCode", regionalismCode);
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_MAM_SVC_02.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,appId:[{}]\u8be6\u60c5\u4fe1\u606f:\u3010{}\u3011", new Object[]{regionalismCode, appId, json});
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.error("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,appId:[{}]\u8be6\u60c5\u4fe1\u606f:\u3010{}\u3011", new Object[]{regionalismCode, appId, json});
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528" + appId + "\u8be6\u60c5\u9519\u8bef:\u5e94\u7528\u8be6\u60c5\u4e3a\u7a7a");
        }
        try {
            result = JSON.parseObject((String)json);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528,appRegionalismCode:\u3010{}\u3011,appId\u3010{}\u3011\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a\u3010{}\u3011", new Object[]{regionalismCode, appId, json});
            throw SyncClientException.operateErrorException(String.format("\u540c\u6b65\u884c\u653f\u533a\u5212%s\u5e94\u7528%s\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38", regionalismCode, appId));
        }
        return result;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

