/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.enums;

public enum OperateType {
    ADD(1, "\u589e\u52a0"),
    DELETE(2, "\u5220\u9664"),
    UPDATE(3, "\u66f4\u65b0"),
    QUERY(4, "\u67e5\u8be2");

    private int code;
    private String desc;

    public static String getNameByCode(int code) {
        OperateType[] values;
        for (OperateType requestMethod : values = OperateType.values()) {
            if (requestMethod.getCode() != code) continue;
            return requestMethod.getDesc();
        }
        return QUERY.getDesc();
    }

    public static int getCodeByName(String name) {
        OperateType[] values;
        for (OperateType requestMethod : values = OperateType.values()) {
            if (!requestMethod.getDesc().equals(name)) continue;
            return requestMethod.getCode();
        }
        return QUERY.getCode();
    }

    private OperateType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

