/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.util;

import com.xdja.log.bean.Dict;
import com.xdja.log.enums.AocLogType;
import com.xdja.log.enums.MamLogType;
import com.xdja.log.enums.RsbLogType;
import com.xdja.log.enums.UaaLogType;
import com.xdja.log.enums.UpmLogType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogEnumUtil {
    private static final String AOC_CODE = "aoc";
    private static final String MAM_CODE = "mam";
    private static final String MAM_ANDROID_CODE = "mam_android";
    private static final String RSB_CODE = "rsb";
    private static final String UAA_CODE = "uaa";
    public static final Map<Integer, String> SYSTEM_LOGS = new HashMap<Integer, String>();

    public static List<Dict> getLogDicts(String systemCode) {
        switch (systemCode) {
            case "aoc": {
                return LogEnumUtil.getDicts(AocLogType.AOC_SYSTEM_LOGS);
            }
            case "mam": {
                return LogEnumUtil.getDicts(MamLogType.MAM_SYSTEM_LOGS);
            }
            case "mam_android": {
                return LogEnumUtil.getDicts(MamLogType.MAM_ANDROID_LOGS);
            }
            case "rsb": {
                return LogEnumUtil.getDicts(RsbLogType.RSB_SYSTEM_LOGS);
            }
            case "uaa": {
                return LogEnumUtil.getDicts(UaaLogType.UAA_SYSTEM_LOGS);
            }
        }
        return LogEnumUtil.getDicts(UpmLogType.UPM_SYSTEM_LOGS);
    }

    public static List<Dict> getDicts(Map<Integer, String> systemLogs) {
        ArrayList<Dict> dicts = new ArrayList<Dict>();
        for (Map.Entry<Integer, String> entry : systemLogs.entrySet()) {
            dicts.add(new Dict(entry.getKey(), entry.getValue()));
        }
        return dicts;
    }

    static {
        SYSTEM_LOGS.putAll(AocLogType.AOC_SYSTEM_LOGS);
        SYSTEM_LOGS.putAll(MamLogType.MAM_SYSTEM_LOGS);
        SYSTEM_LOGS.putAll(RsbLogType.RSB_SYSTEM_LOGS);
        SYSTEM_LOGS.putAll(UaaLogType.UAA_SYSTEM_LOGS);
        SYSTEM_LOGS.putAll(UpmLogType.UPM_SYSTEM_LOGS);
        SYSTEM_LOGS.putAll(MamLogType.MAM_ANDROID_LOGS);
    }
}

