/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.PersonAppSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PersonAppSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PersonAppSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private PersonAppSyncDao personAppSyncDao;
    @Value(value="${sync.personApp.interval:300}")
    private Long syncPersonAppInterval;
    private volatile boolean syncPersonAppRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "personApp";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_PERSON_APP.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncPersonApp();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, 30L, this.syncPersonAppInterval, TimeUnit.SECONDS);
    }

    @Transactional(rollbackFor={Exception.class})
    public int syncPersonApp() {
        List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
        return this.syncPersonApp(listSyncApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncPersonApp(List<SyncApp> listSyncApp) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        PersonAppSyncHandler personAppSyncHandler = this;
        synchronized (personAppSyncHandler) {
            if (this.syncPersonAppRunning) {
                logger.error("\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncPersonAppRunning = true;
        }
        int syncAppTotal = 0;
        try {
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.warn("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5e94\u7528:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncApp));
            }
            for (SyncApp syncApp : listSyncApp) {
                String appId = syncApp.getAppId();
                String appRegionalismCode = syncApp.getRegionalismCode();
                String appNetworkAreaCode = syncApp.getNetworkAreaCode();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011,appRegionalismCode:\u3010{}\u3011>>>", (Object)appId, (Object)appRegionalismCode);
                }
                try {
                    List<SyncPersonApp> listPullSyncPersonApp = this.pullPersonAppList(appId, appRegionalismCode, appNetworkAreaCode);
                    if (null == listPullSyncPersonApp || listPullSyncPersonApp.isEmpty()) {
                        logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5220\u9664\u5168\u90e8", (Object)appId, (Object)appRegionalismCode);
                        List<SyncPersonApp> listDbSyncPersonApp = this.personAppSyncDao.queryPersonAppByAppId(appId, appRegionalismCode);
                        if (null != listDbSyncPersonApp && listDbSyncPersonApp.size() > 0) {
                            for (SyncPersonApp syncPersonApp : listDbSyncPersonApp) {
                                syncPersonApp.setStatus(SyncAppResource.status_delete_3);
                                syncPersonApp.setLastUpdateTime(System.currentTimeMillis());
                                this.personAppSyncDao.updatePersonAppStatus(syncPersonApp);
                            }
                        }
                    } else {
                        List<SyncPersonApp> listDeleteSyncPersonApp;
                        List<SyncPersonApp> list;
                        List<SyncPersonApp> listAddSyncPersonApp;
                        HashMap<String, SyncPersonApp> mapPullPersonApp = new HashMap<String, SyncPersonApp>();
                        for (int i = 0; i < listPullSyncPersonApp.size(); ++i) {
                            SyncPersonApp syncPersonApp;
                            syncPersonApp = listPullSyncPersonApp.get(i);
                            String key = syncPersonApp.getPersonId() + syncPersonApp.getPersonRegionalismCode() + syncPersonApp.getAppId() + syncPersonApp.getAppRegionalismCode();
                            mapPullPersonApp.put(key, syncPersonApp);
                        }
                        List<SyncPersonApp> listDbSyncPersonApp = this.personAppSyncDao.queryPersonAppByAppId(appId, appRegionalismCode);
                        HashMap<String, SyncPersonApp> mapDbSyncPersonApp = new HashMap<String, SyncPersonApp>();
                        if (null != listDbSyncPersonApp && !listDbSyncPersonApp.isEmpty()) {
                            for (SyncPersonApp syncPersonApp : listDbSyncPersonApp) {
                                String key = syncPersonApp.getPersonId() + syncPersonApp.getPersonRegionalismCode() + syncPersonApp.getAppId() + syncPersonApp.getAppRegionalismCode();
                                mapPullPersonApp.put(key, syncPersonApp);
                            }
                        }
                        if (null != (listAddSyncPersonApp = this.computeAddSyncPersonApp(mapPullPersonApp, mapDbSyncPersonApp)) && listAddSyncPersonApp.size() > 0) {
                            if (logger.isDebugEnabled()) {
                                logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u65b0\u589e:\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(listAddSyncPersonApp)});
                            }
                            for (Object personApp : listAddSyncPersonApp) {
                                long currentTimeMillis = System.currentTimeMillis();
                                ((SyncPersonApp)personApp).setCreateTime(currentTimeMillis);
                                ((SyncPersonApp)personApp).setLastUpdateTime(currentTimeMillis);
                                this.personAppSyncDao.savePersonApp((SyncPersonApp)personApp);
                            }
                        }
                        if (null != (list = this.computeUpdateSyncPersonApp(mapPullPersonApp, mapDbSyncPersonApp)) && list.size() > 0) {
                            Object personApp;
                            if (logger.isDebugEnabled()) {
                                logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u66f4\u65b0:\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(list)});
                            }
                            personApp = list.iterator();
                            while (personApp.hasNext()) {
                                SyncPersonApp personApp2 = (SyncPersonApp)personApp.next();
                                long currentTimeMillis = System.currentTimeMillis();
                                personApp2.setCreateTime(currentTimeMillis);
                                personApp2.setLastUpdateTime(currentTimeMillis);
                                this.personAppSyncDao.savePersonApp(personApp2);
                            }
                        }
                        if (null != (listDeleteSyncPersonApp = this.computeDeleteSyncPersonApp(mapPullPersonApp, mapDbSyncPersonApp)) && !listDeleteSyncPersonApp.isEmpty()) {
                            if (logger.isDebugEnabled()) {
                                logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u5220\u9664:\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(listDeleteSyncPersonApp)});
                            }
                            for (SyncPersonApp personApp : listDeleteSyncPersonApp) {
                                long currentTimeMillis = System.currentTimeMillis();
                                personApp.setCreateTime(currentTimeMillis);
                                personApp.setLastUpdateTime(currentTimeMillis);
                                this.personAppSyncDao.updatePersonAppStatus(personApp);
                            }
                        }
                        logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{appId, appRegionalismCode, listAddSyncPersonApp.size(), listDeleteSyncPersonApp.size()});
                    }
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, e});
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<", (Object)appId, (Object)appRegionalismCode);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncPersonAppRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    private List<SyncPersonApp> computeDeleteSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
        ArrayList<SyncPersonApp> listDeleteSyncPersonApp = new ArrayList<SyncPersonApp>();
        for (Map.Entry<String, SyncPersonApp> entry : mapDbSyncPersonApp.entrySet()) {
            String key = entry.getKey();
            if (mapPullSyncPersonApp.containsKey(key)) continue;
            long currentTimeMillis = System.currentTimeMillis();
            SyncPersonApp value = entry.getValue();
            value.setLastUpdateTime(currentTimeMillis);
            value.setStatus(SyncPersonApp.status_delete_3);
            listDeleteSyncPersonApp.add(value);
        }
        return listDeleteSyncPersonApp;
    }

    private List<SyncPersonApp> computeAddSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
        ArrayList<SyncPersonApp> listAddSyncPersonApp = new ArrayList<SyncPersonApp>();
        for (Map.Entry<String, SyncPersonApp> entry : mapPullSyncPersonApp.entrySet()) {
            String key = entry.getKey();
            if (mapDbSyncPersonApp.containsKey(key)) continue;
            long currentTimeMillis = System.currentTimeMillis();
            SyncPersonApp syncPersonApp = entry.getValue();
            syncPersonApp.setPersonAppId(IdGeneratorUtil.nextIdNum());
            syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
            syncPersonApp.setCreateTime(currentTimeMillis);
            syncPersonApp.setLastUpdateTime(currentTimeMillis);
            listAddSyncPersonApp.add(syncPersonApp);
        }
        return listAddSyncPersonApp;
    }

    private List<SyncPersonApp> computeUpdateSyncPersonApp(Map<String, SyncPersonApp> mapPullSyncPersonApp, Map<String, SyncPersonApp> mapDbSyncPersonApp) {
        ArrayList<SyncPersonApp> listUpdateSyncPersonApp = new ArrayList<SyncPersonApp>();
        for (Map.Entry<String, SyncPersonApp> entry : mapPullSyncPersonApp.entrySet()) {
            String key = entry.getKey();
            if (!mapDbSyncPersonApp.containsKey(key)) continue;
            long currentTimeMillis = System.currentTimeMillis();
            SyncPersonApp syncPersonApp = mapDbSyncPersonApp.get(key);
            syncPersonApp.setStatus(SyncPersonApp.status_grant_1);
            syncPersonApp.setCreateTime(currentTimeMillis);
            syncPersonApp.setLastUpdateTime(currentTimeMillis);
            listUpdateSyncPersonApp.add(syncPersonApp);
        }
        return listUpdateSyncPersonApp;
    }

    private List<SyncPersonApp> pullPersonAppList(String appId, String appRegionalismCode, String appNetworkAreaCode) {
        HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
        mapReqParam.put("pageNo", 1);
        mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
        mapReqParam.put("appId", appId);
        mapReqParam.put("appRegionalismCode", appRegionalismCode);
        long appResourceTotal = 0L;
        String localRegionalismCode = Consts.local_regionalismCode;
        String localNetworkCode = Consts.local_networkAreaCode;
        JSONArray listPerson = new JSONArray();
        int pageNo = 1;
        while (true) {
            mapReqParam.put("pageNo", pageNo);
            JSONArray personList = this.queryOffsitePersonAppList(localRegionalismCode, localNetworkCode, mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appId, appRegionalismCode, pageNo, null != personList ? personList.toJSONString() : null});
            }
            if (!CollectionUtils.isEmpty((Collection)personList)) {
                listPerson.addAll((Collection)personList);
                appResourceTotal += (long)personList.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, rows:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{appId, appRegionalismCode, pageNo, personList.toJSONString(), appResourceTotal});
            }
            if (CollectionUtils.isEmpty((Collection)personList) || personList.size() < this.pageSize) {
                if (!logger.isDebugEnabled()) break;
                logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)appId, (Object)appRegionalismCode);
                break;
            }
            ++pageNo;
        }
        return this.buildSyncPersonApp(listPerson, appId, appRegionalismCode, appNetworkAreaCode);
    }

    private List<SyncPersonApp> buildSyncPersonApp(JSONArray personList, String appId, String appRegionalismCode, String appNetworkAreaCode) {
        ArrayList<SyncPersonApp> listSyncPersonApp = new ArrayList<SyncPersonApp>();
        if (null == personList) {
            return listSyncPersonApp;
        }
        SyncPersonApp syncPersonApp = null;
        for (int i = 0; i < personList.size(); ++i) {
            JSONObject jsonObject = personList.getJSONObject(i);
            String personId = jsonObject.getString("personId");
            String personRegionalismCode = jsonObject.getString("personRegionalismCode");
            syncPersonApp = new SyncPersonApp();
            syncPersonApp.setAppId(appId);
            syncPersonApp.setAppRegionalismCode(appRegionalismCode);
            syncPersonApp.setAppNetworkCode(appNetworkAreaCode);
            syncPersonApp.setPersonId(personId);
            syncPersonApp.setPersonRegionalismCode(personRegionalismCode);
            listSyncPersonApp.add(syncPersonApp);
        }
        return listSyncPersonApp;
    }

    private JSONArray queryOffsitePersonAppList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_03.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,appResource:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("personList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u4eba\u5458\u5e94\u7528\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        return resultList;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_PERSON_APP != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

