/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.service.impl;

import com.xdja.sync.bean.SyncServiceInterface;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.service.BasicSyncServiceInterfaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicSyncServiceInterfaceServiceImpl
implements BasicSyncServiceInterfaceService {
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public SyncServiceInterface querySyncServiceInterfaceByCode(String regionalismCode, String interfaceCode, String networkAreaCode) {
        String sql = "SELECT * FROM t_sync_service_interface WHERE regionalism_code = ? AND interface_code = ? ";
        Object[] args = new Object[]{regionalismCode, interfaceCode};
        if (null != networkAreaCode && !"".equals(networkAreaCode)) {
            sql = sql + " AND network_area_code = ?";
            args = new Object[]{regionalismCode, interfaceCode, networkAreaCode};
        }
        return (SyncServiceInterface)this.basicSyncCommonDao.selectOne(sql, args, SyncServiceInterface.class);
    }

    @Override
    public String queryInterfaceUrl(String regionalismCode, String interfaceCode) {
        SyncServiceInterface syncServiceInterface = this.querySyncServiceInterfaceByCode(regionalismCode, interfaceCode, null);
        return null != syncServiceInterface ? syncServiceInterface.getInterfaceUrl() : "";
    }

    @Override
    public String queryInterfaceUrl(String regionalismCode, String interfaceCode, String networkCode) {
        SyncServiceInterface syncServiceInterface = this.querySyncServiceInterfaceByCode(regionalismCode, interfaceCode, networkCode);
        return null != syncServiceInterface ? syncServiceInterface.getInterfaceUrl() : "";
    }
}

